/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.doclet.config;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.RootDoc;
import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSFacet;
import com.sun.xml.xsom.XSRestrictionSimpleType;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.parser.XSOMParser;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.config.ConfigurationDoc;
import org.infinispan.config.ConfigurationDocRef;
import org.infinispan.config.ConfigurationDocs;
import org.infinispan.tools.doclet.config.XMLTreeOutputWalker;
import org.infinispan.tools.doclet.html.HtmlGenerator;
import org.infinispan.tools.schema.TreeNode;
import org.infinispan.tools.schema.XSOMSchemaTreeWalker;
import org.infinispan.util.ReflectionUtil;

public abstract class AbstractConfigHtmlGenerator
extends HtmlGenerator {
    protected static final String CONFIG_REF = "configRef";
    protected static final String CONFIG_REF_NAME_ATT = "name";
    protected static final String CONFIG_REF_PARENT_NAME_ATT = "parentName";
    protected static final String CONFIG_REF_DESC_ATT = "desc";
    private static final int LEVEL_MULT = 3;
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("infinispan.tools.configdoc.debug", "false"));
    protected RootDoc rootDoc;
    protected StringBuilder sb = new StringBuilder();

    public AbstractConfigHtmlGenerator(String encoding, String title, String bottom, String footer, String header, String metaDescription, List<String> metaKeywords) {
        super(encoding, title, bottom, footer, header, metaDescription, metaKeywords);
    }

    protected abstract List<Class<?>> getConfigBeans() throws Exception;

    protected abstract String getSchemaFile();

    protected abstract String getRootElementName();

    protected void preXMLTableOfContentsCreate(XSOMSchemaTreeWalker sw, XMLTreeOutputWalker tw) {
    }

    protected void postXMLTableOfContentsCreate(XSOMSchemaTreeWalker w, XMLTreeOutputWalker tw) {
    }

    protected boolean preVisitNode(TreeNode n) {
        return true;
    }

    protected boolean postVisitNode(TreeNode n) {
        return false;
    }

    protected String getTitle() {
        return "<h2>Configuration reference</h2><br/>";
    }

    public RootDoc getRootDoc() {
        return this.rootDoc;
    }

    public void setRootDoc(RootDoc rootDoc) {
        this.rootDoc = rootDoc;
    }

    public InputStream lookupFile(String filename) {
        InputStream is;
        InputStream inputStream = is = filename == null || filename.length() == 0 ? null : this.getAsInputStreamFromClassLoader(filename);
        if (is == null) {
            try {
                is = new FileInputStream(filename);
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        return is;
    }

    protected InputStream getAsInputStreamFromClassLoader(String filename) {
        InputStream is;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = is = cl == null ? null : cl.getResourceAsStream(filename);
        if (is == null) {
            is = this.getClass().getClassLoader().getResourceAsStream(filename);
        }
        return is;
    }

    protected StringBuilder getStringBuilder() {
        return this.sb;
    }

    @Override
    protected String generateContents() {
        this.sb.append(this.getTitle());
        try {
            List<Class<?>> configBeans = this.getConfigBeans();
            if (configBeans == null || configBeans.isEmpty()) {
                throw new Exception("Configuration bean classes are not specified. Make sure that getConfigBeans() method returns a list of classes. Documentation creation aborted");
            }
            XMLTreeOutputWalker tw = new XMLTreeOutputWalker(this.sb);
            String schemaFile = this.getSchemaFile();
            if (schemaFile == null) {
                throw new Exception("Schema file name not specified. Documentation creation aborted");
            }
            InputStream file = this.lookupFile(schemaFile);
            if (file == null) {
                throw new Exception("Schema file " + schemaFile + " not found on classpath. Documentation creation aborted");
            }
            XSOMParser reader = new XSOMParser();
            try {
                reader.parse(file);
            }
            finally {
                file.close();
            }
            XSSchemaSet xss = reader.getResult();
            XSOMSchemaTreeWalker w = new XSOMSchemaTreeWalker(xss.getSchema(1), this.getRootElementName());
            TreeNode root = w.getRoot();
            this.associateBeansWithTreeNodes(configBeans, root);
            this.preXMLTableOfContentsCreate(w, tw);
            this.sb.append("<div class=\"source\"><pre>");
            tw.preOrderTraverse(root);
            this.sb.append("</pre></div>");
            this.postXMLTableOfContentsCreate(w, tw);
            for (TreeNode n : root) {
                boolean skip = this.preVisitNode(n);
                if (skip) continue;
                this.sb.append("<div class=\"section\">\n");
                this.debug("Generating " + n + " bean is " + n.getBeanClass());
                this.generateHeaderForConfigurationElement(this.sb, tw, n);
                if (!n.getAttributes().isEmpty()) {
                    this.generateAttributeTableRows(this.sb, n);
                }
                boolean breakLoop = this.postVisitNode(n);
                this.sb.append("</div>\n");
                if (!breakLoop) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            System.out.println("Exception while generating configuration reference " + e);
            e.printStackTrace();
        }
        return this.sb.toString();
    }

    private void associateBeansWithTreeNodes(List<Class<?>> configBeans, TreeNode root) {
        for (TreeNode n : root) {
            if (n.getBeanClass() != null) continue;
            for (Class<?> clazz : configBeans) {
                ConfigurationDoc[] docs;
                if (clazz.isAnnotationPresent(ConfigurationDoc.class)) {
                    this.associate(clazz.getAnnotation(ConfigurationDoc.class), n, clazz);
                    continue;
                }
                if (!clazz.isAnnotationPresent(ConfigurationDocs.class)) continue;
                ConfigurationDoc[] configurationDocArray = docs = clazz.getAnnotation(ConfigurationDocs.class).value();
                int n2 = docs.length;
                int n3 = 0;
                while (n3 < n2) {
                    ConfigurationDoc cd = configurationDocArray[n3];
                    this.associate(cd, n, clazz);
                    ++n3;
                }
            }
        }
    }

    private void associate(ConfigurationDoc cd, TreeNode n, Class<?> clazz) {
        if (cd != null) {
            String thisNode = cd.name();
            String parentNode = cd.parentName();
            if (n.getName().equalsIgnoreCase(thisNode)) {
                if (parentNode.equalsIgnoreCase(n.getParent().getName())) {
                    this.debug("Parent associated " + clazz + " with node " + n.getName() + ", parent " + parentNode);
                    n.setBeanClass(clazz);
                } else if (parentNode.length() == 0) {
                    this.debug("Normal associated " + clazz + " with node " + n.getName());
                    n.setBeanClass(clazz);
                }
            }
        }
    }

    private void generateAttributeTableRows(StringBuilder sb, TreeNode n) {
        sb.append("<table class=\"bodyTable\"> ");
        sb.append("<tr class=\"a\"><th>Attribute</th><th>Type</th><th>Default</th><th>Description</th></tr>\n");
        Class<?> bean = n.getBeanClass();
        Object beanClassInstance = null;
        try {
            Constructor<?>[] constructors;
            Constructor<?>[] constructorArray = constructors = bean.getDeclaredConstructors();
            int n2 = constructors.length;
            int n3 = 0;
            while (n3 < n2) {
                Constructor<?> c = constructorArray[n3];
                if (c.getParameterTypes().length == 0) {
                    c.setAccessible(true);
                    beanClassInstance = c.newInstance(new Object[0]);
                }
                ++n3;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("TreeNode " + n.getName() + " is associated with a bean class " + bean + " whose instantiation failed on default contructor ");
        }
        if (beanClassInstance == null) {
            throw new RuntimeException("Bean class could not be instantied, aborting!");
        }
        Set<XSAttributeDecl> attributes = n.getAttributes();
        for (XSAttributeDecl a : attributes) {
            this.generateTableRowForAttribute(a, sb, beanClassInstance);
        }
        sb.append("</table>\n");
    }

    protected void generateTableRowForAttribute(XSAttributeDecl a, StringBuilder sb, Object beanClassInstance) {
        sb.append("<tr class=\"b\">");
        sb.append("<td>").append("<code>" + a.getName() + "</code>").append("</td>\n");
        sb.append("<td>").append("<code>" + a.getType().getName() + "</code>");
        boolean isRestricted = false;
        XSRestrictionSimpleType restriction = a.getType().asRestriction();
        Collection declaredFacets = restriction.getDeclaredFacets();
        for (XSFacet facet : declaredFacets) {
            if (!facet.getName().equalsIgnoreCase("enumeration")) continue;
            isRestricted = true;
            break;
        }
        this.debug("attribute = " + a.getName() + "(restricted = " + isRestricted + ")", 1);
        if (isRestricted) {
            sb.append("* (");
            for (XSFacet facet : declaredFacets) {
                sb.append(String.valueOf(facet.getValue().toString()) + '|');
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(")</td>\n");
        } else {
            sb.append("</td>\n");
        }
        Field field = this.findField(beanClassInstance.getClass(), a.getName());
        if (field == null) {
            throw new RuntimeException("Null field for " + beanClassInstance.getClass() + " attribute " + a.getName());
        }
        if (a.getDefaultValue() != null) {
            this.debug("annotation-defined default = " + a.getDefaultValue(), 2);
            sb.append("<td>").append(a.getDefaultValue().toString()).append("</td>\n");
        } else {
            Object defaultValue = null;
            try {
                defaultValue = ReflectionUtil.getValue((Object)beanClassInstance, (String)field.getName());
                if (defaultValue != null) {
                    sb.append("<td>").append(defaultValue.toString()).append("</td>\n");
                    this.debug("field-defined default = " + defaultValue, 2);
                } else {
                    this.debug("field-defined default is null!", 2);
                    sb.append("<td>").append("null").append("</td>\n");
                }
            }
            catch (Exception e) {
                this.debug("Caught exception, bean is " + beanClassInstance.getClass() + ", looking for field " + a.getName() + ", field " + field, 2);
                e.printStackTrace();
                sb.append("<td>").append("N/A").append("</td>\n");
            }
        }
        String desc = null;
        Doc docElement = null;
        ConfigurationDocRef docRef = null;
        if (field.isAnnotationPresent(ConfigurationDoc.class)) {
            desc = field.getAnnotation(ConfigurationDoc.class).desc();
        } else if (field.isAnnotationPresent(ConfigurationDocRef.class)) {
            docRef = field.getAnnotation(ConfigurationDocRef.class);
            docElement = this.findDocElement(docRef.bean(), docRef.targetElement());
            desc = docElement.commentText();
        }
        if (desc != null) {
            sb.append("<td>").append(desc).append("\n");
            String htmlFile = field.getDeclaringClass().getName().replace(".", "/").replace("$", ".").concat(".html");
            if (docRef != null) {
                htmlFile = docRef.bean().getName().replace(".", "/").replace("$", ".").concat(".html");
                if (docElement instanceof MethodDoc) {
                    MethodDoc mDocElement = (MethodDoc)docElement;
                    Parameter[] parameters = mDocElement.parameters();
                    String targetElement = docRef.targetElement();
                    StringBuilder javadocTarget = new StringBuilder(targetElement);
                    javadocTarget.append("(");
                    Parameter[] parameterArray = parameters;
                    int n = parameters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Parameter parameter = parameterArray[n2];
                        javadocTarget.append(parameter.type().qualifiedTypeName()).append(",");
                        ++n2;
                    }
                    javadocTarget.deleteCharAt(javadocTarget.length() - 1);
                    javadocTarget.append(")");
                    sb.append(" (<a href=\"" + htmlFile.concat("#").concat(javadocTarget.toString()) + "\">" + "Javadoc</a>)");
                }
            } else {
                sb.append(" (<a href=\"" + htmlFile.concat("#").concat(field.getName()) + "\">" + "Javadoc</a>)");
            }
            sb.append("</td>\n");
        }
        sb.append("</tr>\n");
    }

    private void debug(String s, int level) {
        if (DEBUG) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < level * 3) {
                sb.append(" ");
                ++i;
            }
            sb.append("> ").append(s);
            System.out.println(sb.toString());
        }
    }

    private void debug(String s) {
        this.debug(s, 0);
    }

    private boolean validString(String s) {
        return s != null && s.length() > 0;
    }

    protected void generateHeaderForConfigurationElement(StringBuilder sb, XMLTreeOutputWalker tw, TreeNode n) {
        sb.append("<a name=\"").append("ce_" + n.getParent().getName() + "_" + n.getName() + "\">" + "</a>");
        sb.append("<h3><a name=\"" + n.getName() + "\"></a>" + n.getName() + "</h3>");
        sb.append("\n<p>");
        Class<?> beanClass = n.getBeanClass();
        Map<String, String> desc = this.findDescription(beanClass);
        if (!desc.isEmpty()) {
            for (Map.Entry<String, String> e : desc.entrySet()) {
                if (!n.getName().equals(e.getKey())) continue;
                sb.append(e.getValue());
            }
        }
        sb.append("<BR/><BR />");
        if (n.getParent().getParent() != null) {
            sb.append("The parent element is <a href=\"").append("#ce_" + n.getParent().getParent().getName() + "_" + n.getParent().getName() + "\">" + "&lt;" + n.getParent().getName() + "&gt;" + "</a>.  ");
        }
        if (!n.getChildren().isEmpty()) {
            int childCount = n.getChildren().size();
            int count = 1;
            if (childCount == 1) {
                sb.append("The only child element is ");
            } else {
                sb.append("Child elements are ");
            }
            for (TreeNode tn : n.getChildren()) {
                sb.append("<a href=\"").append("#ce_" + tn.getParent().getName() + "_" + tn.getName() + "\">" + "&lt;" + tn.getName() + "&gt;" + "</a>");
                if (count < childCount) {
                    sb.append(", ");
                } else {
                    sb.append(".");
                }
                ++count;
            }
            sb.append("\n");
        }
        sb.append("</p>");
    }

    protected Field findField(Class<?> clazz, String name) {
        Field f = null;
        boolean found = false;
        Class<?> current = clazz;
        while (current != null) {
            try {
                f = current.getDeclaredField(name);
                return f;
            }
            catch (NoSuchFieldException e) {
                current = current.getSuperclass();
            }
        }
        List anFields = ReflectionUtil.getAnnotatedFields(clazz, ConfigurationDoc.class);
        for (Field field : anFields) {
            if (!field.getAnnotation(ConfigurationDoc.class).name().equals(name)) continue;
            f = field;
            found = true;
            break;
        }
        if (!found) {
            anFields = ReflectionUtil.getAnnotatedFields(clazz, ConfigurationDocRef.class);
            for (Field field : anFields) {
                if (!field.getAnnotation(ConfigurationDocRef.class).name().equals(name)) continue;
                f = field;
                break;
            }
        }
        return f;
    }

    protected Map<String, String> findDescription(AnnotatedElement e) {
        HashMap<String, String> m = new HashMap<String, String>();
        ConfigurationDoc cd = e.getAnnotation(ConfigurationDoc.class);
        if (cd != null) {
            this.extractConfigurationDocComments(e, m, cd);
        } else if (e.isAnnotationPresent(ConfigurationDocs.class)) {
            ConfigurationDoc[] configurationDocs;
            ConfigurationDoc[] configurationDocArray = configurationDocs = e.getAnnotation(ConfigurationDocs.class).value();
            int n = configurationDocs.length;
            int n2 = 0;
            while (n2 < n) {
                ConfigurationDoc cd2 = configurationDocArray[n2];
                this.extractConfigurationDocComments(e, m, cd2);
                ++n2;
            }
        }
        return m;
    }

    protected void extractConfigurationDocComments(AnnotatedElement e, Map<String, String> m, ConfigurationDoc cd) {
        if (cd != null) {
            if (this.validString(cd.desc())) {
                m.put(cd.name(), cd.desc());
            } else if (e instanceof Class) {
                Class clazz = (Class)e;
                ClassDoc classDoc = this.rootDoc.classNamed(clazz.getName());
                m.put(cd.name(), classDoc.commentText());
            }
        }
    }

    protected Doc findDocElement(Class<?> c, String elementName) {
        while (true) {
            ClassDoc classDoc = this.rootDoc.classNamed(c.getName());
            MethodDoc[] methodDocArray = classDoc.methods();
            int n = methodDocArray.length;
            int n2 = 0;
            while (n2 < n) {
                MethodDoc md = methodDocArray[n2];
                if (md.name().equalsIgnoreCase(elementName)) {
                    return md;
                }
                ++n2;
            }
            methodDocArray = classDoc.fields();
            n = methodDocArray.length;
            n2 = 0;
            while (n2 < n) {
                MethodDoc fd = methodDocArray[n2];
                if (fd.name().equalsIgnoreCase(elementName)) {
                    return fd;
                }
                ++n2;
            }
            if (c.getSuperclass() == null) break;
            c = c.getSuperclass();
        }
        return null;
    }
}

