/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.doclet.config;

import org.infinispan.tools.schema.AbstractTreeWalker;
import org.infinispan.tools.schema.TreeNode;

public class XMLTreeOutputWalker
extends AbstractTreeWalker {
    private final StringBuilder sb;
    private static final String IDENT = "  ";

    public XMLTreeOutputWalker(StringBuilder sb) {
        this.sb = sb;
    }

    @Override
    public void visitNode(TreeNode treeNode) {
        String ident = "";
        int i = 0;
        while (i <= treeNode.getDepth()) {
            ident = String.valueOf(ident) + IDENT;
            ++i;
        }
        this.sb.append(String.valueOf(ident) + "&lt;<a href=\"" + "#ce_" + treeNode.getParent().getName() + "_" + treeNode.getName() + "\">" + treeNode.getName() + "</a>&gt;" + "\n");
    }

    public TreeNode findNode(TreeNode tn, String name, String parent) {
        TreeNode result = null;
        if (tn.getName().equals(name) && tn.getParent() != null && tn.getParent().getName().equals(parent)) {
            result = tn;
        } else {
            for (TreeNode child : tn.getChildren()) {
                result = this.findNode(child, name, parent);
                if (result != null) break;
            }
        }
        return result;
    }
}

