/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.doclet.jmx;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.tools.doclet.jmx.JmxComponent;
import org.infinispan.tools.doclet.jmx.JmxHtmlGenerator;
import org.infinispan.tools.doclet.jmx.MBeanAttribute;
import org.infinispan.tools.doclet.jmx.MBeanComponent;
import org.infinispan.tools.doclet.jmx.MBeanOperation;

public class JmxDoclet {
    static String outputDirectory = ".";
    static String header;
    static String footer;
    static String encoding;
    static String title;
    static String bottom;

    public static boolean start(RootDoc root) throws IOException {
        ClassDoc[] classes = root.classes();
        LinkedList<MBeanComponent> mbeans = new LinkedList<MBeanComponent>();
        ClassDoc[] classDocArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            ClassDoc cd = classDocArray[n2];
            MBeanComponent mbean = JmxDoclet.toJmxComponent(cd);
            if (mbean != null) {
                mbeans.add(mbean);
            }
            ++n2;
        }
        Collections.sort(mbeans);
        JmxHtmlGenerator generator = new JmxHtmlGenerator(encoding, JmxDoclet.jmxTitle(), bottom, footer, header, "JMX components exposed by Infinispan", Arrays.asList("JMX", "Infinispan", "Data Grids", "Documentation", "Reference", "MBeans", "Management", "Console"), mbeans);
        generator.generateHtml(String.valueOf(outputDirectory) + File.separator + "jmxComponents.html");
        return true;
    }

    private static String jmxTitle() {
        String s = "JMX Components";
        if (title == null || title.length() == 0) {
            return s;
        }
        s = String.valueOf(s) + " (" + title + ")";
        return s;
    }

    public static int optionLength(String option) {
        return ConfigurationImpl.getInstance().optionLength(option);
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) {
        String[][] stringArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            String[] option = stringArray[n2];
            if (option[0].equals("-d")) {
                outputDirectory = option[1];
            } else if (option[0].equals("-encoding")) {
                encoding = option[1];
            } else if (option[0].equals("-bottom")) {
                bottom = option[1];
            } else if (option[0].equals("-footer")) {
                footer = option[1];
            } else if (option[0].equals("-header")) {
                header = option[1];
            } else if (option[0].equals("-doctitle")) {
                title = option[1];
            }
            ++n2;
        }
        return ConfigurationImpl.getInstance().validOptions(options, reporter);
    }

    private static MBeanComponent toJmxComponent(ClassDoc cd) {
        MBeanAttribute attr;
        String annotationName;
        AnnotationDesc a;
        int n;
        AnnotationDesc[] annotationDescArray;
        boolean isMBean = false;
        MBeanComponent mbc = new MBeanComponent();
        mbc.className = cd.qualifiedTypeName();
        mbc.name = cd.typeName();
        AnnotationDesc[] annotationDescArray2 = cd.annotations();
        int n2 = annotationDescArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            AnnotationDesc a2 = annotationDescArray2[n3];
            AnnotationTypeDoc atd = a2.annotationType();
            String annotationName2 = atd.qualifiedTypeName();
            if (annotationName2.equals(MBean.class.getName())) {
                isMBean = true;
                JmxDoclet.setNameDesc(a2.elementValues(), mbc);
            }
            ++n3;
        }
        annotationDescArray2 = cd.methods();
        n2 = annotationDescArray2.length;
        n3 = 0;
        while (n3 < n2) {
            AnnotationDesc method = annotationDescArray2[n3];
            annotationDescArray = method.annotations();
            n = annotationDescArray.length;
            int n4 = 0;
            while (n4 < n) {
                a = annotationDescArray[n4];
                annotationName = a.annotationType().qualifiedTypeName();
                if (annotationName.equals(ManagedOperation.class.getName())) {
                    isMBean = true;
                    MBeanOperation o = new MBeanOperation();
                    o.name = method.name();
                    JmxDoclet.setNameDesc(a.elementValues(), o);
                    o.returnType = method.returnType().simpleTypeName();
                    Parameter[] parameterArray = method.parameters();
                    int n5 = parameterArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        Parameter p = parameterArray[n6];
                        o.addParam(p.type().simpleTypeName());
                        ++n6;
                    }
                    mbc.operations.add(o);
                } else if (annotationName.equals(ManagedAttribute.class.getName())) {
                    isMBean = true;
                    attr = new MBeanAttribute();
                    if (method.name().startsWith("get") || method.name().startsWith("is")) {
                        attr.type = method.returnType().simpleTypeName();
                    } else if (method.parameters().length > 0) {
                        attr.type = method.parameters()[0].type().simpleTypeName();
                    }
                    attr.name = JmxDoclet.fromBeanConvention(method.name());
                    JmxDoclet.setNameDesc(a.elementValues(), attr);
                    JmxDoclet.setWritable(a.elementValues(), attr);
                    mbc.attributes.add(attr);
                }
                ++n4;
            }
            ++n3;
        }
        annotationDescArray2 = cd.fields(false);
        n2 = annotationDescArray2.length;
        n3 = 0;
        while (n3 < n2) {
            AnnotationDesc field = annotationDescArray2[n3];
            annotationDescArray = field.annotations();
            n = annotationDescArray.length;
            int n7 = 0;
            while (n7 < n) {
                a = annotationDescArray[n7];
                annotationName = a.annotationType().qualifiedTypeName();
                if (annotationName.equals(ManagedAttribute.class.getName())) {
                    isMBean = true;
                    attr = new MBeanAttribute();
                    attr.name = field.name();
                    attr.type = field.type().simpleTypeName();
                    JmxDoclet.setNameDesc(a.elementValues(), attr);
                    JmxDoclet.setWritable(a.elementValues(), attr);
                    mbc.attributes.add(attr);
                }
                ++n7;
            }
            ++n3;
        }
        if (isMBean) {
            Collections.sort(mbc.attributes);
            Collections.sort(mbc.operations);
            return mbc;
        }
        return null;
    }

    private static String fromBeanConvention(String getterOrSetter) {
        if (getterOrSetter.startsWith("get") || getterOrSetter.startsWith("set")) {
            String withoutGet = getterOrSetter.substring(4);
            return String.valueOf(Character.toUpperCase(getterOrSetter.charAt(3))) + withoutGet;
        }
        if (getterOrSetter.startsWith("is")) {
            String withoutIs = getterOrSetter.substring(3);
            return String.valueOf(Character.toUpperCase(getterOrSetter.charAt(2))) + withoutIs;
        }
        return getterOrSetter;
    }

    private static void setNameDesc(AnnotationDesc.ElementValuePair[] evps, JmxComponent mbc) {
        AnnotationDesc.ElementValuePair[] elementValuePairArray = evps;
        int n = evps.length;
        int n2 = 0;
        while (n2 < n) {
            AnnotationDesc.ElementValuePair evp = elementValuePairArray[n2];
            if (evp.element().name().equals("objectName")) {
                mbc.name = evp.value().value().toString();
            } else if (evp.element().name().equals("name")) {
                mbc.name = evp.value().value().toString();
            } else if (evp.element().name().equals("description")) {
                mbc.desc = evp.value().value().toString();
            }
            ++n2;
        }
    }

    private static void setWritable(AnnotationDesc.ElementValuePair[] evps, MBeanAttribute attr) {
        AnnotationDesc.ElementValuePair[] elementValuePairArray = evps;
        int n = evps.length;
        int n2 = 0;
        while (n2 < n) {
            AnnotationDesc.ElementValuePair evp = elementValuePairArray[n2];
            if (evp.element().name().equals("writable")) {
                attr.writable = (Boolean)evp.value().value();
            }
            ++n2;
        }
    }
}

