/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.xsd;

import gnu.getopt.Getopt;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;

public class XSDoc {
    private final Map<String, Document> xmls = new HashMap<String, Document>();
    private final Transformer xslt;
    private final DocumentBuilder docBuilder;

    XSDoc() throws Exception {
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setURIResolver(new URIResolver(){

            @Override
            public Source resolve(String href, String base) throws TransformerException {
                Document doc = (Document)XSDoc.this.xmls.get(XSDoc.getBaseFileName(href));
                if (doc != null) {
                    return new DOMSource(doc);
                }
                return null;
            }
        });
        ClassLoader cl = XSDoc.class.getClassLoader();
        InputStream xsl = cl.getResourceAsStream("xsd/xsdoc.xslt");
        this.xslt = factory.newTransformer(new StreamSource(xsl));
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        this.docBuilder = dbf.newDocumentBuilder();
    }

    void transform(String fileName, File outputDir) throws Exception {
        Document doc = this.docBuilder.parse(new File(fileName));
        String name = XSDoc.getBaseFileName(fileName);
        this.xmls.put(name, doc);
        this.xslt.transform(new DOMSource(doc), new StreamResult(new File(outputDir, name + ".html")));
    }

    public static String getBaseFileName(String absoluteFileName) {
        int slash = absoluteFileName.lastIndexOf(47);
        int dot = absoluteFileName.lastIndexOf(46);
        return absoluteFileName.substring(slash + 1, dot);
    }

    public static void main(String[] argv) throws Exception {
        XSDoc xsDoc = new XSDoc();
        String outputDir = System.getProperty("user.dir");
        Getopt opts = new Getopt("xsdoc", argv, "o:");
        int opt = opts.getopt();
        while (opt > -1) {
            switch (opt) {
                case 111: {
                    outputDir = opts.getOptarg();
                }
            }
            opt = opts.getopt();
        }
        File outDir = new File(outputDir);
        outDir.mkdirs();
        for (int i = opts.getOptind(); i < argv.length; ++i) {
            xsDoc.transform(argv[i], outDir);
        }
    }
}

