/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.xsd;

import gnu.getopt.Getopt;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XSDoc {
    private final Map<String, Document> xmls = new HashMap<String, Document>();
    private final Transformer xslt;
    private final DocumentBuilder docBuilder;
    private final Document indexDoc;
    private Element indexRoot;
    private TransformerFactory factory = TransformerFactory.newInstance();

    XSDoc() throws Exception {
        this.factory.setURIResolver(new URIResolver(){

            @Override
            public Source resolve(String href, String base) throws TransformerException {
                Document doc = (Document)XSDoc.this.xmls.get(XSDoc.getBaseFileName(href));
                if (doc != null) {
                    return new DOMSource(doc);
                }
                return null;
            }
        });
        ClassLoader cl = XSDoc.class.getClassLoader();
        try (InputStream xsl = cl.getResourceAsStream("xsd/xsdoc.xslt");){
            this.xslt = this.factory.newTransformer(new StreamSource(xsl));
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        this.docBuilder = dbf.newDocumentBuilder();
        this.indexDoc = this.docBuilder.newDocument();
        this.indexRoot = this.indexDoc.createElement("files");
        this.indexDoc.appendChild(this.indexRoot);
    }

    void transform(String fileName, File outputDir) throws Exception {
        Document doc = this.docBuilder.parse(new File(fileName));
        String name = XSDoc.getBaseFileName(fileName);
        this.xmls.put(name, doc);
        this.xslt.transform(new DOMSource(doc), new StreamResult(new File(outputDir, name + ".html")));
        Element item = this.indexDoc.createElement("file");
        item.setAttribute("name", name + ".html");
        item.setAttribute("ns", ((Element)doc.getFirstChild()).getAttribute("targetNamespace"));
        this.indexRoot.appendChild(item);
    }

    private void generateIndex(File outputDir) throws Exception {
        XSDoc.printDocument(this.indexDoc, System.out);
        ClassLoader cl = XSDoc.class.getClassLoader();
        try (InputStream xsl = cl.getResourceAsStream("xsd/index.xslt");){
            Transformer indexXSLT = this.factory.newTransformer(new StreamSource(xsl));
            indexXSLT.transform(new DOMSource(this.indexDoc), new StreamResult(new File(outputDir, "index.html")));
        }
    }

    public static String getBaseFileName(String absoluteFileName) {
        int slash = absoluteFileName.lastIndexOf(47);
        int dot = absoluteFileName.lastIndexOf(46);
        return absoluteFileName.substring(slash + 1, dot);
    }

    public static void printDocument(Document doc, OutputStream out) throws IOException, TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.transform(new DOMSource(doc), new StreamResult(new OutputStreamWriter(out, "UTF-8")));
    }

    public static void main(String[] argv) throws Exception {
        XSDoc xsDoc = new XSDoc();
        String outputDir = System.getProperty("user.dir");
        Getopt opts = new Getopt("xsdoc", argv, "o:");
        int opt = opts.getopt();
        while (opt > -1) {
            switch (opt) {
                case 111: {
                    outputDir = opts.getOptarg();
                }
            }
            opt = opts.getopt();
        }
        File outDir = new File(outputDir);
        outDir.mkdirs();
        for (int i = opts.getOptind(); i < argv.length; ++i) {
            xsDoc.transform(argv[i], outDir);
        }
        xsDoc.generateIndex(outDir);
    }
}

