/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.jdbc.migrator.marshaller.externalizers;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.tools.jdbc.migrator.marshaller.externalizers.LegacyIds;

@Immutable
public class SingletonListExternalizer
extends AbstractExternalizer<List<?>> {
    public void writeObject(ObjectOutput output, List<?> list) throws IOException {
        output.writeObject(list.get(0));
    }

    public List<?> readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        return Collections.singletonList(input.readObject());
    }

    public Integer getId() {
        return LegacyIds.SINGLETON_LIST;
    }

    public Set<Class<? extends List<?>>> getTypeClasses() {
        return Util.asSet((Object[])new Class[]{Util.loadClass((String)"java.util.Collections$SingletonList", null)});
    }
}

