/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.jdbc.migrator.marshaller;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.io.ByteBufferImpl;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.ImmortalCacheValue;
import org.infinispan.container.entries.MortalCacheEntry;
import org.infinispan.container.entries.MortalCacheValue;
import org.infinispan.container.entries.TransientCacheEntry;
import org.infinispan.container.entries.TransientCacheValue;
import org.infinispan.container.entries.TransientMortalCacheEntry;
import org.infinispan.container.entries.TransientMortalCacheValue;
import org.infinispan.container.entries.metadata.MetadataImmortalCacheEntry;
import org.infinispan.container.entries.metadata.MetadataImmortalCacheValue;
import org.infinispan.container.entries.metadata.MetadataMortalCacheEntry;
import org.infinispan.container.entries.metadata.MetadataMortalCacheValue;
import org.infinispan.container.entries.metadata.MetadataTransientCacheEntry;
import org.infinispan.container.entries.metadata.MetadataTransientCacheValue;
import org.infinispan.container.entries.metadata.MetadataTransientMortalCacheEntry;
import org.infinispan.container.entries.metadata.MetadataTransientMortalCacheValue;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.container.versioning.SimpleClusteredVersion;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.InternalMetadataImpl;
import org.infinispan.test.data.Key;
import org.infinispan.test.data.Person;
import org.infinispan.tools.jdbc.migrator.marshaller.LegacyVersionAwareMarshaller;
import org.infinispan.util.KeyValuePair;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(testName="tools.LegacyVersionAwareMarshallerTest", groups={"functional"})
public class LegacyVersionAwareMarshallerTest {
    private final StreamingMarshaller marshaller;
    private Map<String, byte[]> byteMap;

    public LegacyVersionAwareMarshallerTest() {
        HashMap<Integer, TestObjectExternalizer> externalizerMap = new HashMap<Integer, TestObjectExternalizer>();
        externalizerMap.put(256, new TestObjectExternalizer());
        this.marshaller = new LegacyVersionAwareMarshaller(externalizerMap);
    }

    @BeforeTest
    public void beforeTest() throws Exception {
        Path path = new File("src/test/resources/marshalled_bytes_8.x.bin").toPath();
        byte[] bytes = Files.readAllBytes(path);
        this.byteMap = (Map)this.marshaller.objectFromByteBuffer(bytes);
    }

    public void testUnmarshalling() throws Exception {
        this.unmarshallAndAssertEquality("List", Arrays.asList(new Person("Alan Shearer"), new Person("Nolberto Solano")));
        this.unmarshallAndAssertEquality("SingletonList", Collections.singletonList(new Key("Key", false)));
        this.unmarshallAndAssertEquality("SingletonMap", Collections.singletonMap("Key", "Value"));
        this.unmarshallAndAssertEquality("SingletonSet", Collections.singleton(new Key("Key", false)));
        this.unmarshallAndAssertEquality("KeyValuePair", new KeyValuePair((Object)"Key", (Object)"Value"));
        this.unmarshallAndAssertEquality("ImmortalCacheEntry", new ImmortalCacheEntry((Object)"Key", (Object)"Value"));
        this.unmarshallAndAssertEquality("MortalCacheEntry", new MortalCacheEntry((Object)"Key", (Object)"Value", 1L, 1L));
        this.unmarshallAndAssertEquality("TransientCacheEntry", new TransientCacheEntry((Object)"Key", (Object)"Value", 1L, 1L));
        this.unmarshallAndAssertEquality("TransientMortalCacheEntry", new TransientMortalCacheEntry((Object)"Key", (Object)"Value", 1L, 1L, 1L));
        this.unmarshallAndAssertEquality("ImmortalCacheValue", new ImmortalCacheValue((Object)"Value"));
        this.unmarshallAndAssertEquality("MortalCacheValue", new MortalCacheValue((Object)"Value", 1L, 1L));
        this.unmarshallAndAssertEquality("TransientCacheValue", new TransientCacheValue((Object)"Value", 1L, 1L));
        this.unmarshallAndAssertEquality("TransientMortalCacheValue", new TransientMortalCacheValue((Object)"Value", 1L, 1L, 1L));
        Metadata metadata = new EmbeddedMetadata.Builder().version((EntryVersion)new NumericVersion(1L)).build();
        this.unmarshallAndAssertEquality("EmbeddedMetadata", metadata);
        this.unmarshallAndAssertEquality("SimpleClusteredVersion", new SimpleClusteredVersion(1, 1L));
        this.unmarshallAndAssertEquality("MetadataImmortalCacheEntry", new MetadataImmortalCacheEntry((Object)"Key", (Object)"Value", metadata));
        this.unmarshallAndAssertEquality("MetadataMortalCacheEntry", new MetadataMortalCacheEntry((Object)"Key", (Object)"Value", metadata, 1L));
        this.unmarshallAndAssertEquality("MetadataTransientCacheEntry", new MetadataTransientCacheEntry((Object)"Key", (Object)"Value", metadata, 1L));
        this.unmarshallAndAssertEquality("MetadataTransientMortalCacheEntry", new MetadataTransientMortalCacheEntry((Object)"Key", (Object)"Value", metadata, 1L));
        this.unmarshallAndAssertEquality("MetadataImmortalCacheValue", new MetadataImmortalCacheValue((Object)"Value", metadata));
        this.unmarshallAndAssertEquality("MetadataMortalCacheValue", new MetadataMortalCacheValue((Object)"Value", metadata, 1L));
        this.unmarshallAndAssertEquality("MetadataTransientCacheValue", new MetadataTransientCacheValue((Object)"Value", metadata, 1L));
        this.unmarshallAndAssertEquality("MetadataTransientMortalCacheValue", new MetadataTransientMortalCacheValue((Object)"Value", metadata, 1L, 1L));
        byte[] bytes = "Test".getBytes();
        this.unmarshallAndAssertEquality("ByteBufferImpl", new ByteBufferImpl(bytes, 0, bytes.length));
        this.unmarshallAndAssertEquality("KeyValuePair", new KeyValuePair((Object)"Key", (Object)"Value"));
        InternalMetadataImpl internalMetadata = new InternalMetadataImpl(metadata, 1L, 1L);
        this.unmarshallAndAssertEquality("InternalMetadataImpl", internalMetadata);
        this.unmarshallAndAssertEquality("CustomExternalizer", new TestObject(1, "Test"));
    }

    private void unmarshallAndAssertEquality(String key, Object expectedObj) throws Exception {
        byte[] bytes = this.byteMap.get(key);
        assert (bytes != null);
        Object readObj = this.marshaller.objectFromByteBuffer(bytes);
        Assert.assertEquals((Object)readObj, (Object)expectedObj);
    }

    public static class TestObjectExternalizer
    implements AdvancedExternalizer<TestObject> {
        public Set<Class<? extends TestObject>> getTypeClasses() {
            return Collections.singleton(TestObject.class);
        }

        public Integer getId() {
            return 256;
        }

        public void writeObject(ObjectOutput objectOutput, TestObject testObject) throws IOException {
            objectOutput.writeInt(testObject.id);
            MarshallUtil.marshallString((String)testObject.someString, (ObjectOutput)objectOutput);
        }

        public TestObject readObject(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            TestObject testObject = new TestObject();
            testObject.id = objectInput.readInt();
            testObject.someString = MarshallUtil.unmarshallString((ObjectInput)objectInput);
            return testObject;
        }
    }

    private static class TestObject {
        int id;
        String someString;

        TestObject() {
        }

        TestObject(int id, String someString) {
            this.id = id;
            this.someString = someString;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestObject that = (TestObject)o;
            if (this.id != that.id) {
                return false;
            }
            return this.someString != null ? this.someString.equals(that.someString) : that.someString == null;
        }

        public int hashCode() {
            int result = this.id;
            result = 31 * result + (this.someString != null ? this.someString.hashCode() : 0);
            return result;
        }
    }
}

