/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.jdbc.migrator;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Properties;
import java.util.Set;
import org.h2.Driver;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.persistence.jdbc.DatabaseType;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.tools.jdbc.migrator.Element;
import org.infinispan.tools.jdbc.migrator.JDBCMigrator;
import org.infinispan.tools.jdbc.migrator.MarshallerType;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(testName="tools.Test", groups={"functional"})
public class MigratorSerializerTest {
    private static final String DB_URL = "jdbc:h2:mem:%s;DB_CLOSE_DELAY=-1";
    private static final String USER = "sa";
    private static final Class DRIVER = Driver.class;
    private static final DatabaseType DB_DIALECT = DatabaseType.H2;
    private static final String TABLE_ID_COL = "ID_COLUMN";
    private static final String TABLE_ID_TYPE = "VARCHAR(255)";
    private static final String TABLE_DATA_COL = "DATA_COLUMN";
    private static final String TABLE_DATA_TYPE = "BLOB";
    private static final String TABLE_TS_COL = "TIMESTAMP_COLUMN";
    private static final String TABLE_TS_TYPE = "BIGINT";
    private static final GlobalConfiguration GLOBAL_CONFIG = new GlobalConfigurationBuilder().build();
    private JDBCMigrator migrator;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        Configuration config = this.createDatabaseConfig(true);
        DefaultCacheManager cacheManager = new DefaultCacheManager(GLOBAL_CONFIG, config);
        Cache cache = cacheManager.getCache(this.getClass().getName());
        cache.put((Object)1, (Object)new TestEntry("1234"));
        Properties props = new Properties();
        this.createDatabaseConfigProperties(props, true);
        this.createDatabaseConfigProperties(props, false);
        this.migrator = new JDBCMigrator(props);
    }

    public void testSerializerLoaded() throws Exception {
        this.migrator.run();
        Configuration config = this.createDatabaseConfig(false);
        DefaultCacheManager cm = new DefaultCacheManager(GLOBAL_CONFIG, config);
        Cache cache = cm.getCache(this.getClass().getName());
        AssertJUnit.assertEquals((int)1, (int)cache.size());
        AssertJUnit.assertNotNull((Object)cache.get((Object)1));
    }

    private Configuration createDatabaseConfig(boolean source) {
        String tableName = source ? Element.SOURCE.toString() : Element.TARGET.toString();
        return ((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)new ConfigurationBuilder().persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class)).dialect(DB_DIALECT)).table().createOnStart(source)).tableNamePrefix(tableName)).idColumnName(TABLE_ID_COL)).idColumnType(TABLE_ID_TYPE)).dataColumnName(TABLE_DATA_COL)).dataColumnType(TABLE_DATA_TYPE)).timestampColumnName(TABLE_TS_COL)).timestampColumnType(TABLE_TS_TYPE)).connectionPool().connectionUrl(DB_URL).username(USER).driverClass(DRIVER).build();
    }

    private void createDatabaseConfigProperties(Properties props, boolean source) {
        Element type = source ? Element.SOURCE : Element.TARGET;
        props.put(this.propKey(type, Element.TYPE), Element.STRING.toString());
        props.put(this.propKey(type, Element.CACHE_NAME), this.getClass().getName());
        props.put(this.propKey(type, Element.MARSHALLER), MarshallerType.CURRENT);
        props.put(this.propKey(type, Element.DIALECT), DB_DIALECT.toString());
        props.put(this.propKey(type, Element.CONNECTION_POOL, Element.USERNAME), USER);
        props.put(this.propKey(type, Element.CONNECTION_POOL, Element.CONNECTION_URL), DB_URL);
        props.put(this.propKey(type, Element.CONNECTION_POOL, Element.DRIVER_CLASS), DRIVER.getName());
        props.put(this.propKey(type, Element.TABLE, Element.STRING, Element.TABLE_NAME_PREFIX), type.toString());
        props.put(this.propKey(type, Element.TABLE, Element.STRING, Element.ID, Element.NAME), TABLE_ID_COL);
        props.put(this.propKey(type, Element.TABLE, Element.STRING, Element.ID, Element.TYPE), TABLE_ID_TYPE);
        props.put(this.propKey(type, Element.TABLE, Element.STRING, Element.DATA, Element.NAME), TABLE_DATA_COL);
        props.put(this.propKey(type, Element.TABLE, Element.STRING, Element.DATA, Element.TYPE), TABLE_DATA_TYPE);
        props.put(this.propKey(type, Element.TABLE, Element.STRING, Element.TIMESTAMP, Element.NAME), TABLE_TS_COL);
        props.put(this.propKey(type, Element.TABLE, Element.STRING, Element.TIMESTAMP, Element.TYPE), TABLE_TS_TYPE);
    }

    private String propKey(Element ... elements) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < elements.length; ++i) {
            sb.append(elements[i].toString());
            if (i == elements.length - 1) continue;
            sb.append(".");
        }
        return sb.toString();
    }

    public static class TestEntrySerializer
    implements AdvancedExternalizer<TestEntry> {
        public Set<Class<? extends TestEntry>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{TestEntry.class});
        }

        public Integer getId() {
            return 2017;
        }

        public void writeObject(ObjectOutput output, TestEntry object) throws IOException {
            output.writeObject(object.toString());
        }

        public TestEntry readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return TestEntry.of((String)input.readObject());
        }
    }

    @SerializeWith(value=TestEntrySerializer.class)
    public static class TestEntry
    implements Serializable {
        private final String s;

        public TestEntry(String s) {
            this.s = s;
        }

        public static TestEntry of(String s) {
            return new TestEntry(s);
        }

        public String toString() {
            return this.s;
        }
    }
}

