/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.jdbc.migrator;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.marshall.core.GlobalMarshaller;
import org.infinispan.persistence.jdbc.DatabaseType;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.test.data.Person;
import org.infinispan.tools.jdbc.migrator.Element;
import org.infinispan.tools.jdbc.migrator.MarshallerType;
import org.infinispan.tools.jdbc.migrator.MigratorConfiguration;
import org.infinispan.tools.jdbc.migrator.StoreType;
import org.infinispan.tools.jdbc.migrator.marshaller.LegacyVersionAwareMarshaller;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(testName="tools.MigratorConfigurationTest", groups={"functional"})
public class MigratorConfigurationTest {
    private static final String DEFAULT_CACHE_NAME = "testCache";
    private static final AtomicInteger externalizerReadCount = new AtomicInteger();
    private static final AtomicInteger externalizerWriteCount = new AtomicInteger();

    @BeforeMethod
    public void init() {
        externalizerReadCount.set(0);
        externalizerWriteCount.set(0);
    }

    public void testCustomMarshallerLoaded() {
        Properties properties = this.createBaseProperties();
        properties.put(this.propKey(Element.SOURCE, Element.MARSHALLER, Element.TYPE), MarshallerType.CUSTOM.toString());
        properties.put(this.propKey(Element.SOURCE, Element.MARSHALLER, Element.CLASS), GenericJBossMarshaller.class.getName());
        MigratorConfiguration config = new MigratorConfiguration(true, properties);
        StreamingMarshaller marshaller = config.getMarshaller();
        assert (marshaller != null);
        assert (marshaller instanceof GenericJBossMarshaller);
    }

    public void testLegacyMarshallerAndExternalizersLoaded() throws Exception {
        String externalizers = "1:" + PersonExternalizer.class.getName();
        Properties properties = this.createBaseProperties();
        properties.put(this.propKey(Element.SOURCE, Element.MARSHALLER, Element.TYPE), MarshallerType.LEGACY.toString());
        properties.put(this.propKey(Element.SOURCE, Element.MARSHALLER, Element.EXTERNALIZERS), externalizers);
        MigratorConfiguration config = new MigratorConfiguration(true, properties);
        StreamingMarshaller marshaller = config.getMarshaller();
        assert (marshaller != null);
        assert (marshaller instanceof LegacyVersionAwareMarshaller);
        byte[] bytes = new byte[]{3, 1, -2, 3, -1, 1, 1};
        Object object = marshaller.objectFromByteBuffer(bytes);
        assert (object != null);
        assert (object instanceof Person);
        assert (externalizerReadCount.get() == 1);
    }

    public void testCurrentMarshallerLoadedAndExternalizersLoaded() throws Exception {
        String externalizers = "1:" + PersonExternalizer.class.getName();
        Properties properties = this.createBaseProperties();
        properties.put(this.propKey(Element.SOURCE, Element.MARSHALLER, Element.TYPE), MarshallerType.CURRENT.toString());
        properties.put(this.propKey(Element.SOURCE, Element.MARSHALLER, Element.EXTERNALIZERS), externalizers);
        MigratorConfiguration config = new MigratorConfiguration(true, properties);
        StreamingMarshaller marshaller = config.getMarshaller();
        assert (marshaller != null);
        assert (marshaller instanceof GlobalMarshaller);
        byte[] bytes = marshaller.objectToByteBuffer((Object)new Person(Person.class.getName()));
        Person person = (Person)marshaller.objectFromByteBuffer(bytes);
        assert (person != null);
        assert (person.getName().equals(Person.class.getName()));
        assert (externalizerReadCount.get() == 1);
        assert (externalizerWriteCount.get() == 1);
    }

    public void testDbPropertiesLoaded() throws Exception {
        Element[] storeTypes;
        Properties properties = this.createBaseProperties();
        properties.putAll((Map<?, ?>)this.createBaseProperties(Element.TARGET));
        for (Element storeType : storeTypes = new Element[]{Element.SOURCE, Element.TARGET}) {
            properties.put(this.propKey(storeType, Element.DB, Element.MAJOR_VERSION), "1");
            properties.put(this.propKey(storeType, Element.DB, Element.MINOR_VERSION), "1");
            properties.put(this.propKey(storeType, Element.DB, Element.DISABLE_INDEXING), "true");
            properties.put(this.propKey(storeType, Element.DB, Element.DISABLE_UPSERT), "true");
        }
        for (Element storeType : storeTypes) {
            MigratorConfiguration migratorConfig = new MigratorConfiguration(storeType == Element.SOURCE, properties);
            JdbcStringBasedStoreConfigurationBuilder builder = migratorConfig.getJdbcConfigBuilder();
            Configuration cacheConfig = builder.build();
            JdbcStringBasedStoreConfiguration config = (JdbcStringBasedStoreConfiguration)cacheConfig.persistence().stores().get(0);
            assert (config.dbMajorVersion() == 1);
            assert (config.dbMinorVersion() == 1);
            assert (Boolean.parseBoolean(config.properties().getProperty("infinispan.jdbc.indexing.disabled")));
            assert (Boolean.parseBoolean(config.properties().getProperty("infinispan.jdbc.upsert.disabled")));
        }
    }

    private Properties createBaseProperties() {
        return this.createBaseProperties(Element.SOURCE);
    }

    private Properties createBaseProperties(Element orientation) {
        Properties properties = new Properties();
        properties.put(this.propKey(orientation, Element.CACHE_NAME), DEFAULT_CACHE_NAME);
        properties.put(this.propKey(orientation, Element.TYPE), StoreType.MIXED.toString());
        properties.put(this.propKey(orientation, Element.DIALECT), DatabaseType.H2.toString());
        properties.put(this.propKey(orientation, Element.CONNECTION_POOL, Element.CONNECTION_URL), "jdbc:postgresql:postgres");
        properties.put(this.propKey(orientation, Element.CONNECTION_POOL, Element.DRIVER_CLASS), "org.postgresql.Driver");
        return properties;
    }

    private String propKey(Element ... elements) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < elements.length; ++i) {
            sb.append(elements[i].toString());
            if (i == elements.length - 1) continue;
            sb.append(".");
        }
        return sb.toString();
    }

    public static class PersonExternalizer
    implements AdvancedExternalizer<Person> {
        public Set<Class<? extends Person>> getTypeClasses() {
            return Collections.singleton(Person.class);
        }

        public void writeObject(ObjectOutput output, Person object) throws IOException {
            externalizerWriteCount.incrementAndGet();
            MarshallUtil.marshallString((String)object.getName(), (ObjectOutput)output);
        }

        public Integer getId() {
            return 1;
        }

        public Person readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            externalizerReadCount.incrementAndGet();
            Person person = new Person();
            person.setName(MarshallUtil.unmarshallString((ObjectInput)input));
            return person;
        }
    }
}

