/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator;

import java.util.Properties;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.tools.store.migrator.Element;
import org.infinispan.tools.store.migrator.StoreMigrator;
import org.infinispan.tools.store.migrator.TestUtil;
import org.infinispan.tools.store.migrator.marshaller.MarshallerType;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="org.infinispan.tools.store.migrator.AbstractReaderTest", groups={"functional"})
public abstract class AbstractReaderTest {
    private static final String TEST_CACHE_NAME = "reader-test";

    public abstract Configuration getTargetCacheConfig();

    protected void configureStoreProperties(Properties properties, Element type) {
        MarshallerType marshallerType = type == Element.SOURCE ? MarshallerType.LEGACY : MarshallerType.CURRENT;
        properties.put(TestUtil.propKey(type, Element.CACHE_NAME), TEST_CACHE_NAME);
        properties.put(TestUtil.propKey(type, Element.MARSHALLER, Element.TYPE), marshallerType.toString());
        properties.put(TestUtil.propKey(type, Element.MARSHALLER, Element.EXTERNALIZERS), "256:" + TestUtil.TestObjectExternalizer.class.getName());
    }

    @Test
    public void readerCompatibilityTest() throws Exception {
        Properties properties = new Properties();
        this.configureStoreProperties(properties, Element.SOURCE);
        this.configureStoreProperties(properties, Element.TARGET);
        new StoreMigrator(properties).run();
        GlobalConfiguration globalConfig = new GlobalConfigurationBuilder().serialization().addAdvancedExternalizer(256, (AdvancedExternalizer)new TestUtil.TestObjectExternalizer()).build();
        Configuration config = this.getTargetCacheConfig();
        DefaultCacheManager manager = new DefaultCacheManager(globalConfig, config);
        Cache cache = manager.getCache(TEST_CACHE_NAME);
        for (String key : TestUtil.TEST_MAP.keySet()) {
            Object stored = cache.get((Object)key);
            AssertJUnit.assertNotNull((String)String.format("Key=%s", key), (Object)stored);
            Object expected = TestUtil.TEST_MAP.get(key);
            AssertJUnit.assertNotNull((String)String.format("Key=%s", key), (Object)stored);
            AssertJUnit.assertEquals((Object)expected, (Object)stored);
        }
    }
}

