/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator;

import java.util.Properties;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.SingleFileStoreConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.rocksdb.configuration.CompressionType;
import org.infinispan.persistence.rocksdb.configuration.RocksDBStoreConfigurationBuilder;
import org.infinispan.persistence.sifs.configuration.SoftIndexFileStoreConfigurationBuilder;
import org.infinispan.tools.store.migrator.Element;
import org.infinispan.tools.store.migrator.StoreMigrator;
import org.infinispan.tools.store.migrator.StoreProperties;
import org.infinispan.tools.store.migrator.StoreType;
import org.infinispan.tools.store.migrator.jdbc.JdbcConfigurationUtil;
import org.infinispan.tools.store.migrator.marshaller.SerializationConfigUtil;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;

class TargetStoreFactory {
    private static final String DEFAULT_CACHE_NAME = StoreMigrator.class.getName();

    TargetStoreFactory() {
    }

    static EmbeddedCacheManager getCacheManager(Properties properties) {
        StoreProperties props = new StoreProperties(Element.TARGET, properties);
        GlobalConfigurationBuilder globalBuilder = new GlobalConfigurationBuilder();
        globalBuilder.defaultCacheName(DEFAULT_CACHE_NAME);
        SerializationConfigUtil.configureSerialization(props, globalBuilder.serialization());
        GlobalConfiguration globalConfig = globalBuilder.build();
        return new DefaultCacheManager(globalConfig, new ConfigurationBuilder().build());
    }

    static AdvancedCache getTargetCache(EmbeddedCacheManager manager, Properties properties) {
        StoreProperties props = new StoreProperties(Element.TARGET, properties);
        ConfigurationBuilder configBuilder = new ConfigurationBuilder();
        configBuilder.persistence().addStore(TargetStoreFactory.getInitializedStoreBuilder(props)).purgeOnStartup(true);
        configBuilder.invocationBatching().transaction().transactionMode(TransactionMode.TRANSACTIONAL).transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup());
        String cacheName = props.cacheName();
        manager.defineConfiguration(cacheName, configBuilder.build());
        return manager.getCache(cacheName).getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD});
    }

    private static StoreConfigurationBuilder getInitializedStoreBuilder(StoreProperties props) {
        PersistenceConfigurationBuilder persistenceBuilder = new ConfigurationBuilder().persistence();
        StoreType storeType = StoreType.valueOf(props.get(Element.TYPE).toUpperCase());
        switch (storeType) {
            case LEVELDB: 
            case JDBC_BINARY: 
            case JDBC_MIXED: {
                throw new CacheConfigurationException(String.format("%s cannot be a target store as it no longer exists", new Object[]{storeType}));
            }
            case JDBC_STRING: {
                return JdbcConfigurationUtil.configureStore(props, new JdbcStringBasedStoreConfigurationBuilder(persistenceBuilder));
            }
            case ROCKSDB: {
                props.required(Element.LOCATION);
                String location = props.get(Element.LOCATION);
                RocksDBStoreConfigurationBuilder builder = new RocksDBStoreConfigurationBuilder(persistenceBuilder);
                builder.location(location).expiredLocation(location + "-expired-");
                String compressionType = props.get(Element.COMPRESSION);
                if (compressionType != null) {
                    builder.compressionType(CompressionType.valueOf((String)compressionType.toUpperCase()));
                }
                return builder;
            }
            case SINGLE_FILE_STORE: {
                props.required(Element.LOCATION);
                return new SingleFileStoreConfigurationBuilder(persistenceBuilder).location(props.get(Element.LOCATION));
            }
            case SOFT_INDEX_FILE_STORE: {
                props.required(Element.LOCATION);
                props.required(Element.INDEX_LOCATION);
                return new SoftIndexFileStoreConfigurationBuilder(persistenceBuilder).dataLocation(props.get(Element.LOCATION)).indexLocation(props.get(Element.INDEX_LOCATION));
            }
        }
        throw new CacheConfigurationException(String.format("Unknown store type '%s'", new Object[]{storeType}));
    }
}

