/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.infinispan.Version;
import org.infinispan.client.hotrod.impl.async.DefaultAsyncExecutorFactory;
import org.infinispan.commons.equivalence.AnyEquivalence;
import org.infinispan.commons.executors.BlockingThreadPoolExecutorFactory;
import org.infinispan.commons.jmx.PerThreadMBeanServerLookup;
import org.infinispan.commons.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.ClusterLoaderConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.InterceptorConfiguration;
import org.infinispan.configuration.cache.SingleFileStoreConfiguration;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.distribution.ch.impl.ReplicatedConsistentHashFactory;
import org.infinispan.distribution.groups.KXGrouper;
import org.infinispan.eviction.EvictionType;
import org.infinispan.factories.threads.DefaultThreadFactory;
import org.infinispan.interceptors.FooInterceptor;
import org.infinispan.marshall.AdvancedExternalizerTest;
import org.infinispan.marshall.TestObjectStreamMarshaller;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.ManagedConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.PooledConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.SimpleConnectionFactoryConfiguration;
import org.infinispan.persistence.jpa.configuration.JpaStoreConfiguration;
import org.infinispan.persistence.remote.configuration.RemoteServerConfiguration;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfiguration;
import org.infinispan.persistence.rest.configuration.ConnectionPoolConfiguration;
import org.infinispan.persistence.rest.configuration.RestStoreConfiguration;
import org.infinispan.persistence.rocksdb.configuration.RocksDBStoreConfiguration;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.tx.TestLookup;
import org.infinispan.tools.config.ConfigurationConverter;
import org.infinispan.tools.customs.CustomDataContainer;
import org.infinispan.tools.customs.CustomTransport;
import org.infinispan.transaction.lookup.GenericTransactionManagerLookup;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="tools.ConfigurationConverterTest", groups={"functional"})
public class ConfigurationConverterTest
extends AbstractInfinispanTest {
    public static final String SERIALIZED_CONFIG_FILE_NAME = "target/serialized_config.xml";

    public void testConversionFrom60() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ConfigurationConverter.convert((InputStream)ConfigurationConverterTest.class.getResourceAsStream("/6.0.xml"), (OutputStream)baos);
        ParserRegistry pr = new ParserRegistry();
        pr.parse((InputStream)new ByteArrayInputStream(baos.toByteArray()));
    }

    public void testConversionAndSerializationFrom60() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ConfigurationConverter.convert((InputStream)ConfigurationConverterTest.class.getResourceAsStream("/6.0.xml"), (OutputStream)baos);
        try (FileOutputStream outputStream = new FileOutputStream(SERIALIZED_CONFIG_FILE_NAME);){
            baos.writeTo(outputStream);
        }
        ParserRegistry parserRegistry = new ParserRegistry(Thread.currentThread().getContextClassLoader(), true);
        ConfigurationBuilderHolder holder = parserRegistry.parseFile(SERIALIZED_CONFIG_FILE_NAME);
        this.assertGlobalPropertiesConverted(holder);
        this.assertDefaultConfigApplied(holder);
        this.assertDataContainerConverted(holder);
        this.assertIndexingConverted(holder);
        this.assertTransactionConverted(holder);
        this.assertLockingConverted(holder);
        this.assertCompatibilityConverted(holder);
        this.assertBackupsConverted(holder);
        this.assertExpirationEvictionConverted(holder);
        this.assertCustomInterceptorsConverted(holder);
        this.assertDeadlockDetectionConverted(holder);
        this.assertJmxStatisticsConverted(holder);
        this.assertStoreAsBinaryConverted(holder);
        this.assertClusteringConverted(holder);
        this.assertPersistenceConverted(holder);
        this.assertUnsafeConverted(holder);
    }

    private void assertGlobalPropertiesConverted(ConfigurationBuilderHolder holder) {
        GlobalConfiguration globalConfiguration = holder.getGlobalConfigurationBuilder().build();
        AssertJUnit.assertEquals((String)"infinispan-cluster", (String)globalConfiguration.transport().clusterName());
        AssertJUnit.assertEquals((String)"r1", (String)globalConfiguration.transport().rackId());
        AssertJUnit.assertEquals((String)"m1", (String)globalConfiguration.transport().machineId());
        AssertJUnit.assertEquals((String)"s1", (String)globalConfiguration.transport().siteId());
        AssertJUnit.assertTrue((boolean)(globalConfiguration.transport().transport() instanceof CustomTransport));
        AssertJUnit.assertEquals((String)"s1", (String)globalConfiguration.sites().localSite());
        TypedProperties props = globalConfiguration.transport().properties();
        boolean stackVerified = false;
        for (String name : props.stringPropertyNames()) {
            if (!name.startsWith("stackFilePath-")) continue;
            AssertJUnit.assertEquals((Object)"jgroups-udp.xml", (Object)props.get((Object)name));
            stackVerified = true;
        }
        if (!stackVerified) {
            AssertJUnit.fail((String)"The stack verification failed! No stack element present.");
        }
        this.assertTransportFactories(globalConfiguration);
        this.assertGlobalSerialization(globalConfiguration);
        this.assertGlobalExecutorsConverted(globalConfiguration);
        AssertJUnit.assertTrue((boolean)globalConfiguration.globalJmxStatistics().allowDuplicateDomains());
        AssertJUnit.assertTrue((boolean)(globalConfiguration.globalJmxStatistics().mbeanServerLookup() instanceof PerThreadMBeanServerLookup));
        AssertJUnit.assertTrue((boolean)globalConfiguration.globalJmxStatistics().enabled());
        AssertJUnit.assertEquals((String)"funky_domain", (String)globalConfiguration.globalJmxStatistics().domain());
        AssertJUnit.assertEquals((String)"TestCacheManager", (String)globalConfiguration.globalJmxStatistics().cacheManagerName());
        AssertJUnit.assertEquals((Object)"testValue", (Object)globalConfiguration.globalJmxStatistics().properties().get((Object)"testKey"));
        AssertJUnit.assertEquals((String)"REGISTER", (String)globalConfiguration.shutdown().hookBehavior().name());
    }

    private void assertTransportFactories(GlobalConfiguration gb) {
        DefaultThreadFactory threadFactory = (DefaultThreadFactory)gb.transport().remoteCommandThreadPool().threadFactory();
        AssertJUnit.assertEquals((String)"infinispan", (String)threadFactory.threadGroup().getName());
        AssertJUnit.assertEquals((String)"%G %i", (String)threadFactory.threadNamePattern());
        AssertJUnit.assertEquals((int)1, (int)threadFactory.initialPriority());
        BlockingThreadPoolExecutorFactory threadPool = (BlockingThreadPoolExecutorFactory)gb.transport().remoteCommandThreadPool().threadPoolFactory();
        AssertJUnit.assertEquals((int)2, (int)threadPool.coreThreads());
        AssertJUnit.assertEquals((int)30, (int)threadPool.maxThreads());
        AssertJUnit.assertEquals((int)100000, (int)threadPool.queueLength());
        AssertJUnit.assertEquals((long)10000L, (long)threadPool.keepAlive());
        threadFactory = (DefaultThreadFactory)gb.transport().transportThreadPool().threadFactory();
        AssertJUnit.assertEquals((String)"infinispan", (String)threadFactory.threadGroup().getName());
        AssertJUnit.assertEquals((String)"%G %i", (String)threadFactory.threadNamePattern());
        AssertJUnit.assertEquals((int)1, (int)threadFactory.initialPriority());
        threadPool = (BlockingThreadPoolExecutorFactory)gb.transport().transportThreadPool().threadPoolFactory();
        AssertJUnit.assertEquals((int)25, (int)threadPool.coreThreads());
        AssertJUnit.assertEquals((int)25, (int)threadPool.maxThreads());
        AssertJUnit.assertEquals((int)10000, (int)threadPool.queueLength());
        AssertJUnit.assertEquals((long)60000L, (long)threadPool.keepAlive());
    }

    private void assertGlobalSerialization(GlobalConfiguration globalConfiguration) {
        AssertJUnit.assertTrue((boolean)(globalConfiguration.serialization().marshaller() instanceof TestObjectStreamMarshaller));
        AssertJUnit.assertEquals((short)Version.getVersionShort((String)"1.0.0"), (short)globalConfiguration.serialization().version());
        AssertJUnit.assertEquals((int)3, (int)globalConfiguration.serialization().advancedExternalizers().size());
        AssertJUnit.assertTrue((boolean)(globalConfiguration.serialization().advancedExternalizers().get(1234) instanceof AdvancedExternalizerTest.IdViaConfigObj.Externalizer));
        AssertJUnit.assertTrue((boolean)(globalConfiguration.serialization().advancedExternalizers().get(3456) instanceof AdvancedExternalizerTest.IdViaBothObj.Externalizer));
        AssertJUnit.assertTrue((boolean)(globalConfiguration.serialization().advancedExternalizers().get(5678) instanceof AdvancedExternalizerTest.IdViaAnnotationObj.Externalizer));
    }

    private void assertGlobalExecutorsConverted(GlobalConfiguration globalConfiguration) {
        DefaultThreadFactory threadFactory = (DefaultThreadFactory)globalConfiguration.listenerThreadPool().threadFactory();
        AssertJUnit.assertEquals((String)"infinispan", (String)threadFactory.threadGroup().getName());
        AssertJUnit.assertEquals((String)"%G %i", (String)threadFactory.threadNamePattern());
        AssertJUnit.assertEquals((int)1, (int)threadFactory.initialPriority());
        BlockingThreadPoolExecutorFactory threadPool = (BlockingThreadPoolExecutorFactory)globalConfiguration.listenerThreadPool().threadPoolFactory();
        AssertJUnit.assertEquals((int)2, (int)threadPool.coreThreads());
        AssertJUnit.assertEquals((int)5, (int)threadPool.maxThreads());
        AssertJUnit.assertEquals((int)12000, (int)threadPool.queueLength());
        AssertJUnit.assertEquals((long)60000L, (long)threadPool.keepAlive());
        threadFactory = (DefaultThreadFactory)globalConfiguration.persistenceThreadPool().threadFactory();
        AssertJUnit.assertEquals((String)"infinispan", (String)threadFactory.threadGroup().getName());
        AssertJUnit.assertEquals((String)"%G %i", (String)threadFactory.threadNamePattern());
        AssertJUnit.assertEquals((int)1, (int)threadFactory.initialPriority());
        threadPool = (BlockingThreadPoolExecutorFactory)globalConfiguration.persistenceThreadPool().threadPoolFactory();
        AssertJUnit.assertEquals((int)6, (int)threadPool.coreThreads());
        AssertJUnit.assertEquals((int)6, (int)threadPool.maxThreads());
        AssertJUnit.assertEquals((int)10001, (int)threadPool.queueLength());
        AssertJUnit.assertEquals((long)60000L, (long)threadPool.keepAlive());
        threadFactory = (DefaultThreadFactory)globalConfiguration.expirationThreadPool().threadFactory();
        AssertJUnit.assertEquals((String)"infinispan", (String)threadFactory.threadGroup().getName());
        AssertJUnit.assertEquals((String)"%G %i", (String)threadFactory.threadNamePattern());
        AssertJUnit.assertEquals((int)1, (int)threadFactory.initialPriority());
        AssertJUnit.assertNotNull((Object)globalConfiguration.expirationThreadPool().threadPoolFactory());
    }

    private void assertDataContainerConverted(ConfigurationBuilderHolder holder) {
        Configuration config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("withDataContainer")).build();
        AssertJUnit.assertFalse((boolean)config.clustering().cacheMode().isClustered());
        AssertJUnit.assertTrue((boolean)(config.dataContainer().dataContainer() instanceof CustomDataContainer));
        AssertJUnit.assertTrue((boolean)(config.dataContainer().valueEquivalence() instanceof AnyEquivalence));
        AssertJUnit.assertTrue((boolean)(config.dataContainer().keyEquivalence() instanceof AnyEquivalence));
    }

    private void assertDefaultConfigApplied(ConfigurationBuilderHolder holder) {
        for (Map.Entry e : holder.getNamedConfigurationBuilders().entrySet()) {
            Configuration config = ((ConfigurationBuilder)e.getValue()).build();
            String name = (String)e.getKey();
            if (!name.startsWith("transaction") && !name.startsWith("tx")) {
                AssertJUnit.assertFalse((String)("Assertion failed for cache: " + e), (boolean)config.transaction().transactionMode().isTransactional());
                AssertJUnit.assertEquals((long)123L, (long)config.transaction().reaperWakeUpInterval());
                AssertJUnit.assertEquals((long)3123L, (long)config.transaction().completedTxTimeout());
            }
            if (!name.startsWith("locking")) {
                AssertJUnit.assertEquals((long)1000L, (long)config.locking().lockAcquisitionTimeout());
                AssertJUnit.assertEquals((int)100, (int)config.locking().concurrencyLevel());
            }
            boolean jmxEnabled = "jmxEnabled".equals(name);
            AssertJUnit.assertEquals((boolean)jmxEnabled, (boolean)config.jmxStatistics().enabled());
        }
    }

    private void assertIndexingConverted(ConfigurationBuilderHolder holder) {
        Configuration config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("withIndexingNotLocal")).build();
        AssertJUnit.assertFalse((boolean)config.clustering().cacheMode().isClustered());
        AssertJUnit.assertEquals((String)"ALL", (String)config.indexing().index().name());
        AssertJUnit.assertEquals((Object)"test1", (Object)config.indexing().properties().get((Object)"test"));
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("withIndexingLocalOnly")).build();
        AssertJUnit.assertFalse((boolean)config.clustering().cacheMode().isClustered());
        AssertJUnit.assertEquals((String)"LOCAL", (String)config.indexing().index().name());
        AssertJUnit.assertEquals((Object)"test1", (Object)config.indexing().properties().get((Object)"test"));
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("withDisabledIndexing")).build();
        AssertJUnit.assertFalse((boolean)config.clustering().cacheMode().isClustered());
        AssertJUnit.assertEquals((String)"NONE", (String)config.indexing().index().name());
    }

    private void assertTransactionConverted(ConfigurationBuilderHolder holder) {
        Configuration config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("transactionalWithInvocationBatching")).build();
        AssertJUnit.assertFalse((boolean)config.clustering().cacheMode().isClustered());
        AssertJUnit.assertTrue((boolean)config.transaction().transactionMode().isTransactional());
        AssertJUnit.assertEquals((String)"TRANSACTIONAL", (String)config.transaction().transactionMode().name());
        AssertJUnit.assertTrue((boolean)config.transaction().useSynchronization());
        AssertJUnit.assertFalse((boolean)config.transaction().recovery().enabled());
        AssertJUnit.assertTrue((boolean)config.transaction().autoCommit());
        AssertJUnit.assertTrue((boolean)config.invocationBatching().enabled());
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("transactionalWithDisabledInvocationBatching")).build();
        AssertJUnit.assertFalse((boolean)config.clustering().cacheMode().isClustered());
        AssertJUnit.assertTrue((boolean)config.transaction().transactionMode().isTransactional());
        AssertJUnit.assertEquals((String)"TRANSACTIONAL", (String)config.transaction().transactionMode().name());
        AssertJUnit.assertTrue((boolean)config.transaction().useSynchronization());
        AssertJUnit.assertFalse((boolean)config.transaction().recovery().enabled());
        AssertJUnit.assertTrue((boolean)config.transaction().autoCommit());
        AssertJUnit.assertFalse((boolean)config.invocationBatching().enabled());
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("transactional")).build();
        AssertJUnit.assertFalse((boolean)config.clustering().cacheMode().isClustered());
        AssertJUnit.assertTrue((boolean)config.transaction().transactionMode().isTransactional());
        AssertJUnit.assertEquals((String)"TRANSACTIONAL", (String)config.transaction().transactionMode().name());
        AssertJUnit.assertFalse((boolean)config.transaction().useSynchronization());
        AssertJUnit.assertTrue((boolean)config.transaction().autoCommit());
        AssertJUnit.assertFalse((boolean)config.invocationBatching().enabled());
        AssertJUnit.assertTrue((boolean)config.transaction().recovery().enabled());
        AssertJUnit.assertEquals((String)"transactional2", (String)config.transaction().recovery().recoveryInfoCacheName());
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("transactional2")).build();
        AssertJUnit.assertFalse((boolean)config.clustering().cacheMode().isClustered());
        AssertJUnit.assertTrue((boolean)config.transaction().transactionMode().isTransactional());
        AssertJUnit.assertEquals((String)"TRANSACTIONAL", (String)config.transaction().transactionMode().name());
        AssertJUnit.assertFalse((boolean)config.transaction().useSynchronization());
        AssertJUnit.assertFalse((boolean)config.transaction().recovery().enabled());
        AssertJUnit.assertFalse((boolean)config.transaction().autoCommit());
        AssertJUnit.assertFalse((boolean)config.invocationBatching().enabled());
        AssertJUnit.assertEquals((String)"PESSIMISTIC", (String)config.transaction().lockingMode().name());
        AssertJUnit.assertEquals((long)10000L, (long)config.transaction().cacheStopTimeout());
        AssertJUnit.assertTrue((boolean)(config.transaction().transactionManagerLookup() instanceof TestLookup));
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("transactional3")).build();
        AssertJUnit.assertTrue((boolean)config.clustering().cacheMode().isReplicated());
        AssertJUnit.assertTrue((boolean)config.transaction().transactionMode().isTransactional());
        AssertJUnit.assertEquals((String)"TRANSACTIONAL", (String)config.transaction().transactionMode().name());
        AssertJUnit.assertFalse((boolean)config.transaction().useSynchronization());
        AssertJUnit.assertTrue((boolean)config.transaction().autoCommit());
        AssertJUnit.assertFalse((boolean)config.invocationBatching().enabled());
        AssertJUnit.assertEquals((String)"OPTIMISTIC", (String)config.transaction().lockingMode().name());
        AssertJUnit.assertEquals((String)"TOTAL_ORDER", (String)config.transaction().transactionProtocol().name());
        AssertJUnit.assertFalse((boolean)config.transaction().recovery().enabled());
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("txSyncRepl")).build();
        AssertJUnit.assertTrue((boolean)config.clustering().cacheMode().isReplicated());
        AssertJUnit.assertTrue((boolean)config.transaction().transactionMode().isTransactional());
        AssertJUnit.assertEquals((String)"TRANSACTIONAL", (String)config.transaction().transactionMode().name());
        AssertJUnit.assertFalse((boolean)config.transaction().useSynchronization());
        AssertJUnit.assertTrue((boolean)config.transaction().autoCommit());
        AssertJUnit.assertFalse((boolean)config.invocationBatching().enabled());
        AssertJUnit.assertEquals((String)"OPTIMISTIC", (String)config.transaction().lockingMode().name());
        AssertJUnit.assertFalse((boolean)config.transaction().recovery().enabled());
        AssertJUnit.assertTrue((boolean)(config.transaction().transactionManagerLookup() instanceof GenericTransactionManagerLookup));
    }

    private void assertCompatibilityConverted(ConfigurationBuilderHolder holder) {
        Configuration config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("withCompatibilityEnabled")).build();
        AssertJUnit.assertFalse((boolean)config.clustering().cacheMode().isClustered());
        AssertJUnit.assertTrue((boolean)config.compatibility().enabled());
        AssertJUnit.assertTrue((boolean)(config.compatibility().marshaller() instanceof GenericJBossMarshaller));
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("withoutCompatibility")).build();
        AssertJUnit.assertFalse((boolean)config.clustering().cacheMode().isClustered());
        AssertJUnit.assertFalse((boolean)config.compatibility().enabled());
    }

    private void assertBackupsConverted(ConfigurationBuilderHolder holder) {
        Configuration config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("withSitesEnabled")).build();
        AssertJUnit.assertFalse((boolean)config.clustering().cacheMode().isClustered());
        AssertJUnit.assertTrue((boolean)config.sites().backupFor().isBackupFor("test1", "test"));
        AssertJUnit.assertTrue((boolean)config.sites().hasInUseBackup("backupTest"));
        AssertJUnit.assertTrue((boolean)config.sites().hasEnabledBackups());
        List backupConfigs = config.sites().allBackups();
        for (BackupConfiguration backupConfig : backupConfigs) {
            if (backupConfig.site().equals("backupTest")) {
                AssertJUnit.assertTrue((boolean)backupConfig.enabled());
                AssertJUnit.assertFalse((boolean)backupConfig.isAsyncBackup());
                AssertJUnit.assertEquals((String)"SYNC", (String)backupConfig.strategy().name());
                AssertJUnit.assertEquals((long)17000L, (long)backupConfig.replicationTimeout());
                AssertJUnit.assertTrue((boolean)backupConfig.isTwoPhaseCommit());
                AssertJUnit.assertEquals((int)15, (int)backupConfig.takeOffline().afterFailures());
                AssertJUnit.assertEquals((long)12000L, (long)backupConfig.takeOffline().minTimeToWait());
                AssertJUnit.assertEquals((String)"IGNORE", (String)backupConfig.backupFailurePolicy().name());
                continue;
            }
            if (!backupConfig.site().equals("backupTest1")) continue;
            AssertJUnit.assertFalse((boolean)backupConfig.enabled());
            AssertJUnit.assertTrue((boolean)backupConfig.isAsyncBackup());
            AssertJUnit.assertEquals((String)"ASYNC", (String)backupConfig.strategy().name());
            AssertJUnit.assertEquals((long)18000L, (long)backupConfig.replicationTimeout());
            AssertJUnit.assertFalse((boolean)backupConfig.isTwoPhaseCommit());
            AssertJUnit.assertEquals((String)"org.infinispan.xsite.CountingCustomFailurePolicy", (String)backupConfig.failurePolicyClass());
            AssertJUnit.assertEquals((int)17, (int)backupConfig.takeOffline().afterFailures());
            AssertJUnit.assertEquals((long)13000L, (long)backupConfig.takeOffline().minTimeToWait());
            AssertJUnit.assertEquals((String)"CUSTOM", (String)backupConfig.backupFailurePolicy().name());
        }
        AssertJUnit.assertEquals((Object)BackupFailurePolicy.IGNORE, (Object)config.sites().getFailurePolicy("backupTest"));
        AssertJUnit.assertEquals((Object)BackupFailurePolicy.CUSTOM, (Object)config.sites().getFailurePolicy("backupTest1"));
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("withEmptyBackups")).build();
        AssertJUnit.assertFalse((boolean)config.clustering().cacheMode().isClustered());
        AssertJUnit.assertTrue((boolean)config.sites().backupFor().isBackupFor("test1", "test"));
        AssertJUnit.assertFalse((boolean)config.sites().hasEnabledBackups());
        AssertJUnit.assertEquals((int)0, (int)config.sites().allBackups().size());
    }

    private void assertLockingConverted(ConfigurationBuilderHolder holder) {
        Configuration config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("lockingOverriding")).build();
        AssertJUnit.assertFalse((boolean)config.clustering().cacheMode().isClustered());
        AssertJUnit.assertEquals((String)"REPEATABLE_READ", (String)config.locking().isolationLevel().name());
        AssertJUnit.assertEquals((int)1000, (int)config.locking().concurrencyLevel());
        AssertJUnit.assertEquals((long)20000L, (long)config.locking().lockAcquisitionTimeout());
        AssertJUnit.assertTrue((boolean)config.locking().useLockStriping());
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("lockingWithJDBCLoader")).build();
        AssertJUnit.assertEquals((long)1000L, (long)config.locking().lockAcquisitionTimeout());
        AssertJUnit.assertEquals((int)100, (int)config.locking().concurrencyLevel());
        AssertJUnit.assertTrue((boolean)config.locking().supportsConcurrentUpdates());
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("lockingWithStoreAsBinary")).build();
        AssertJUnit.assertEquals((String)"REPEATABLE_READ", (String)config.locking().isolationLevel().name());
        AssertJUnit.assertEquals((long)20000L, (long)config.locking().lockAcquisitionTimeout());
        AssertJUnit.assertEquals((int)1000, (int)config.locking().concurrencyLevel());
    }

    private void assertExpirationEvictionConverted(ConfigurationBuilderHolder holder) {
        Configuration config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("evictionCache")).build();
        AssertJUnit.assertFalse((boolean)config.clustering().cacheMode().isClustered());
        AssertJUnit.assertEquals((long)500L, (long)config.expiration().wakeUpInterval());
        AssertJUnit.assertEquals((long)1000L, (long)config.expiration().maxIdle());
        AssertJUnit.assertEquals((long)60000L, (long)config.expiration().lifespan());
        AssertJUnit.assertTrue((boolean)config.expiration().reaperEnabled());
        AssertJUnit.assertEquals((Object)EvictionType.COUNT, (Object)config.memory().evictionType());
        AssertJUnit.assertEquals((Object)StorageType.OBJECT, (Object)config.memory().storageType());
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("expirationCacheWithEnabledReaper")).build();
        AssertJUnit.assertFalse((boolean)config.clustering().cacheMode().isClustered());
        AssertJUnit.assertEquals((long)500L, (long)config.expiration().wakeUpInterval());
        AssertJUnit.assertEquals((long)1000L, (long)config.expiration().maxIdle());
        AssertJUnit.assertEquals((long)60000L, (long)config.expiration().lifespan());
        AssertJUnit.assertTrue((boolean)config.expiration().reaperEnabled());
    }

    private void assertCustomInterceptorsConverted(ConfigurationBuilderHolder holder) {
        Configuration config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("cacheWithCustomInterceptors")).build();
        AssertJUnit.assertFalse((boolean)config.clustering().cacheMode().isClustered());
        AssertJUnit.assertEquals((int)6, (int)config.customInterceptors().interceptors().size());
        AssertJUnit.assertEquals((String)"FIRST", (String)((InterceptorConfiguration)config.customInterceptors().interceptors().get(0)).position().name());
        AssertJUnit.assertTrue((boolean)(((InterceptorConfiguration)config.customInterceptors().interceptors().get(0)).interceptor() instanceof FooInterceptor));
        AssertJUnit.assertEquals((String)"LAST", (String)((InterceptorConfiguration)config.customInterceptors().interceptors().get(1)).position().name());
        AssertJUnit.assertTrue((boolean)(((InterceptorConfiguration)config.customInterceptors().interceptors().get(1)).interceptor() instanceof FooInterceptor));
        AssertJUnit.assertEquals((String)"OTHER_THAN_FIRST_OR_LAST", (String)((InterceptorConfiguration)config.customInterceptors().interceptors().get(2)).position().name());
        AssertJUnit.assertEquals((int)3, (int)((InterceptorConfiguration)config.customInterceptors().interceptors().get(2)).index());
        AssertJUnit.assertTrue((boolean)(((InterceptorConfiguration)config.customInterceptors().interceptors().get(2)).interceptor() instanceof FooInterceptor));
        AssertJUnit.assertEquals((String)"OTHER_THAN_FIRST_OR_LAST", (String)((InterceptorConfiguration)config.customInterceptors().interceptors().get(3)).position().name());
        AssertJUnit.assertEquals(FooInterceptor.class, (Object)((InterceptorConfiguration)config.customInterceptors().interceptors().get(3)).before());
        AssertJUnit.assertTrue((boolean)(((InterceptorConfiguration)config.customInterceptors().interceptors().get(3)).interceptor() instanceof FooInterceptor));
        AssertJUnit.assertEquals((String)"OTHER_THAN_FIRST_OR_LAST", (String)((InterceptorConfiguration)config.customInterceptors().interceptors().get(4)).position().name());
        AssertJUnit.assertEquals(FooInterceptor.class, (Object)((InterceptorConfiguration)config.customInterceptors().interceptors().get(4)).after());
        AssertJUnit.assertTrue((boolean)(((InterceptorConfiguration)config.customInterceptors().interceptors().get(4)).interceptor() instanceof FooInterceptor));
        AssertJUnit.assertEquals((String)"FIRST", (String)((InterceptorConfiguration)config.customInterceptors().interceptors().get(5)).position().name());
        AssertJUnit.assertTrue((boolean)(((InterceptorConfiguration)config.customInterceptors().interceptors().get(0)).interceptor() instanceof FooInterceptor));
    }

    private void assertDeadlockDetectionConverted(ConfigurationBuilderHolder holder) {
        Configuration config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("withDeadlockDetection")).build();
        AssertJUnit.assertFalse((boolean)config.jmxStatistics().enabled());
        AssertJUnit.assertTrue((boolean)config.clustering().cacheMode().isDistributed());
        AssertJUnit.assertTrue((boolean)config.clustering().cacheMode().isSynchronous());
        AssertJUnit.assertEquals((long)20000L, (long)config.clustering().remoteTimeout());
        AssertJUnit.assertFalse((boolean)config.deadlockDetection().enabled());
        AssertJUnit.assertEquals((long)-1L, (long)config.deadlockDetection().spinDuration());
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("lockingWithJDBCLoader")).build();
        AssertJUnit.assertFalse((boolean)config.deadlockDetection().enabled());
        AssertJUnit.assertEquals((long)-1L, (long)config.deadlockDetection().spinDuration());
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("withDeadlockDetectionDisabled")).build();
        AssertJUnit.assertFalse((boolean)config.jmxStatistics().enabled());
        AssertJUnit.assertTrue((boolean)config.clustering().cacheMode().isDistributed());
        AssertJUnit.assertTrue((boolean)config.clustering().cacheMode().isSynchronous());
        AssertJUnit.assertEquals((long)20000L, (long)config.clustering().remoteTimeout());
        AssertJUnit.assertFalse((boolean)config.deadlockDetection().enabled());
    }

    private void assertJmxStatisticsConverted(ConfigurationBuilderHolder holder) {
        Configuration config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("jmxEnabled")).build();
        AssertJUnit.assertFalse((boolean)config.clustering().cacheMode().isClustered());
        AssertJUnit.assertTrue((boolean)config.jmxStatistics().enabled());
    }

    private void assertStoreAsBinaryConverted(ConfigurationBuilderHolder holder) {
        Configuration config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("lockingWithStoreAsBinary")).build();
        AssertJUnit.assertFalse((boolean)config.clustering().cacheMode().isClustered());
        AssertJUnit.assertEquals((Object)StorageType.BINARY, (Object)config.memory().storageType());
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("lockingWithStoreAsBinaryDisabled")).build();
        AssertJUnit.assertFalse((boolean)config.clustering().cacheMode().isClustered());
        AssertJUnit.assertEquals((Object)StorageType.OBJECT, (Object)config.memory().storageType());
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("withoutStoreAsBinary")).build();
        AssertJUnit.assertFalse((boolean)config.clustering().cacheMode().isClustered());
        AssertJUnit.assertEquals((Object)StorageType.OBJECT, (Object)config.memory().storageType());
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("storeKeyValueBinary")).build();
        AssertJUnit.assertFalse((boolean)config.clustering().cacheMode().isClustered());
        AssertJUnit.assertEquals((Object)StorageType.BINARY, (Object)config.memory().storageType());
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("lazyDeserializationCache")).build();
        AssertJUnit.assertFalse((boolean)config.clustering().cacheMode().isClustered());
        AssertJUnit.assertEquals((Object)StorageType.BINARY, (Object)config.memory().storageType());
    }

    private void assertClusteringConverted(ConfigurationBuilderHolder holder) {
        Configuration config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("transactional3")).build();
        AssertJUnit.assertTrue((boolean)config.clustering().cacheMode().isReplicated());
        AssertJUnit.assertTrue((boolean)config.clustering().cacheMode().isSynchronous());
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("lockingSyncInval")).build();
        AssertJUnit.assertTrue((boolean)config.clustering().cacheMode().isInvalidation());
        AssertJUnit.assertTrue((boolean)config.clustering().cacheMode().isSynchronous());
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("lockingAsyncInval")).build();
        AssertJUnit.assertTrue((boolean)config.clustering().cacheMode().isInvalidation());
        AssertJUnit.assertFalse((boolean)config.clustering().cacheMode().isSynchronous());
        AssertJUnit.assertTrue((boolean)config.clustering().stateTransfer().fetchInMemoryState());
        AssertJUnit.assertTrue((boolean)config.clustering().stateTransfer().awaitInitialTransfer());
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("syncRepl")).build();
        AssertJUnit.assertTrue((boolean)config.clustering().cacheMode().isReplicated());
        AssertJUnit.assertTrue((boolean)config.clustering().cacheMode().isSynchronous());
        AssertJUnit.assertEquals((long)15000L, (long)config.clustering().sync().replTimeout());
        AssertJUnit.assertEquals((long)15000L, (long)config.clustering().remoteTimeout());
        AssertJUnit.assertFalse((boolean)config.clustering().stateTransfer().fetchInMemoryState());
        AssertJUnit.assertTrue((boolean)config.clustering().stateTransfer().awaitInitialTransfer());
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("asyncRepl")).build();
        AssertJUnit.assertTrue((boolean)config.clustering().cacheMode().isReplicated());
        AssertJUnit.assertFalse((boolean)config.clustering().cacheMode().isSynchronous());
        AssertJUnit.assertFalse((boolean)config.clustering().stateTransfer().fetchInMemoryState());
        AssertJUnit.assertTrue((boolean)config.clustering().stateTransfer().awaitInitialTransfer());
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("asyncReplQueue")).build();
        AssertJUnit.assertTrue((boolean)config.clustering().cacheMode().isReplicated());
        AssertJUnit.assertFalse((boolean)config.clustering().cacheMode().isSynchronous());
        AssertJUnit.assertFalse((boolean)config.clustering().stateTransfer().fetchInMemoryState());
        AssertJUnit.assertTrue((boolean)config.clustering().stateTransfer().awaitInitialTransfer());
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("txSyncRepl")).build();
        AssertJUnit.assertTrue((boolean)config.clustering().cacheMode().isReplicated());
        AssertJUnit.assertTrue((boolean)config.clustering().cacheMode().isSynchronous());
        AssertJUnit.assertEquals((long)15000L, (long)config.clustering().remoteTimeout());
        AssertJUnit.assertFalse((boolean)config.clustering().stateTransfer().fetchInMemoryState());
        AssertJUnit.assertTrue((boolean)config.clustering().stateTransfer().awaitInitialTransfer());
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("dist")).build();
        AssertJUnit.assertTrue((boolean)config.clustering().cacheMode().isDistributed());
        AssertJUnit.assertTrue((boolean)config.clustering().cacheMode().isSynchronous());
        AssertJUnit.assertEquals((long)120000L, (long)config.clustering().stateTransfer().timeout());
        AssertJUnit.assertTrue((boolean)config.clustering().stateTransfer().fetchInMemoryState());
        AssertJUnit.assertTrue((boolean)config.clustering().stateTransfer().awaitInitialTransfer());
        AssertJUnit.assertEquals((int)3, (int)config.clustering().hash().numOwners());
        AssertJUnit.assertTrue((boolean)config.clustering().l1().enabled());
        AssertJUnit.assertEquals((long)600000L, (long)config.clustering().l1().lifespan());
        AssertJUnit.assertEquals((long)1200L, (long)config.clustering().l1().cleanupTaskFrequency());
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("dist_with_capacity_factors")).build();
        AssertJUnit.assertTrue((boolean)config.clustering().cacheMode().isDistributed());
        AssertJUnit.assertTrue((boolean)config.clustering().cacheMode().isSynchronous());
        AssertJUnit.assertEquals((long)120000L, (long)config.clustering().stateTransfer().timeout());
        AssertJUnit.assertTrue((boolean)config.clustering().stateTransfer().fetchInMemoryState());
        AssertJUnit.assertTrue((boolean)config.clustering().stateTransfer().awaitInitialTransfer());
        AssertJUnit.assertEquals((int)3, (int)config.clustering().hash().numOwners());
        AssertJUnit.assertEquals((int)1000, (int)config.clustering().hash().numSegments());
        AssertJUnit.assertTrue((boolean)config.clustering().l1().enabled());
        AssertJUnit.assertEquals((long)610000L, (long)config.clustering().l1().lifespan());
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("groups")).build();
        AssertJUnit.assertTrue((boolean)config.clustering().cacheMode().isDistributed());
        AssertJUnit.assertTrue((boolean)config.clustering().cacheMode().isSynchronous());
        AssertJUnit.assertTrue((boolean)config.clustering().stateTransfer().fetchInMemoryState());
        AssertJUnit.assertTrue((boolean)config.clustering().stateTransfer().awaitInitialTransfer());
        AssertJUnit.assertTrue((boolean)config.clustering().hash().groups().enabled());
        AssertJUnit.assertEquals((int)1, (int)config.clustering().hash().groups().groupers().size());
        AssertJUnit.assertTrue((boolean)(config.clustering().hash().groups().groupers().get(0) instanceof KXGrouper));
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("groupsDisabled")).build();
        AssertJUnit.assertTrue((boolean)config.clustering().cacheMode().isDistributed());
        AssertJUnit.assertTrue((boolean)config.clustering().cacheMode().isSynchronous());
        AssertJUnit.assertTrue((boolean)config.clustering().stateTransfer().fetchInMemoryState());
        AssertJUnit.assertTrue((boolean)config.clustering().stateTransfer().awaitInitialTransfer());
        AssertJUnit.assertFalse((boolean)config.clustering().hash().groups().enabled());
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("chunkSize")).build();
        AssertJUnit.assertTrue((boolean)config.clustering().cacheMode().isDistributed());
        AssertJUnit.assertFalse((boolean)config.clustering().cacheMode().isSynchronous());
        AssertJUnit.assertTrue((boolean)config.clustering().stateTransfer().fetchInMemoryState());
        AssertJUnit.assertTrue((boolean)config.clustering().stateTransfer().awaitInitialTransfer());
        AssertJUnit.assertEquals((long)120000L, (long)config.clustering().stateTransfer().timeout());
        AssertJUnit.assertEquals((int)1000, (int)config.clustering().stateTransfer().chunkSize());
        AssertJUnit.assertEquals((int)3, (int)config.clustering().hash().numOwners());
        AssertJUnit.assertTrue((boolean)config.clustering().l1().enabled());
        AssertJUnit.assertEquals((long)600000L, (long)config.clustering().l1().lifespan());
        AssertJUnit.assertEquals((long)1200L, (long)config.clustering().l1().cleanupTaskFrequency());
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("distAsync")).build();
        AssertJUnit.assertTrue((boolean)config.clustering().cacheMode().isDistributed());
        AssertJUnit.assertFalse((boolean)config.clustering().cacheMode().isSynchronous());
        AssertJUnit.assertEquals((long)120000L, (long)config.clustering().stateTransfer().timeout());
        AssertJUnit.assertTrue((boolean)config.clustering().stateTransfer().fetchInMemoryState());
        AssertJUnit.assertTrue((boolean)config.clustering().stateTransfer().awaitInitialTransfer());
        AssertJUnit.assertEquals((int)3, (int)config.clustering().hash().numOwners());
        AssertJUnit.assertTrue((boolean)config.clustering().l1().enabled());
        AssertJUnit.assertEquals((long)600000L, (long)config.clustering().l1().lifespan());
        AssertJUnit.assertEquals((long)1200L, (long)config.clustering().l1().cleanupTaskFrequency());
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("localCache")).build();
        AssertJUnit.assertFalse((boolean)config.clustering().cacheMode().isClustered());
        AssertJUnit.assertTrue((boolean)config.clustering().cacheMode().isSynchronous());
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("hashWithFactory")).build();
        AssertJUnit.assertTrue((boolean)config.clustering().cacheMode().isDistributed());
        AssertJUnit.assertTrue((boolean)config.clustering().cacheMode().isSynchronous());
        AssertJUnit.assertTrue((boolean)(config.clustering().hash().consistentHashFactory() instanceof ReplicatedConsistentHashFactory));
        AssertJUnit.assertFalse((boolean)config.clustering().l1().enabled());
    }

    private void assertPersistenceConverted(ConfigurationBuilderHolder holder) {
        Configuration config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("withClusterLoader")).build();
        AssertJUnit.assertFalse((boolean)config.clustering().cacheMode().isClustered());
        AssertJUnit.assertFalse((boolean)config.persistence().usingAsyncStore());
        AssertJUnit.assertTrue((boolean)config.persistence().usingStores());
        AssertJUnit.assertEquals((int)1, (int)config.persistence().stores().size());
        AssertJUnit.assertTrue((boolean)(config.persistence().stores().get(0) instanceof ClusterLoaderConfiguration));
        ClusterLoaderConfiguration clusterLoaderConfiguration = (ClusterLoaderConfiguration)config.persistence().stores().get(0);
        AssertJUnit.assertEquals((long)15000L, (long)clusterLoaderConfiguration.remoteCallTimeout());
        AssertJUnit.assertTrue((boolean)clusterLoaderConfiguration.preload());
        AssertJUnit.assertTrue((boolean)clusterLoaderConfiguration.fetchPersistentState());
        AssertJUnit.assertTrue((boolean)clusterLoaderConfiguration.ignoreModifications());
        AssertJUnit.assertTrue((boolean)clusterLoaderConfiguration.purgeOnStartup());
        AssertJUnit.assertTrue((boolean)clusterLoaderConfiguration.shared());
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("withFileStore")).build();
        AssertJUnit.assertFalse((boolean)config.clustering().cacheMode().isClustered());
        AssertJUnit.assertTrue((boolean)config.persistence().usingAsyncStore());
        AssertJUnit.assertFalse((boolean)config.persistence().passivation());
        AssertJUnit.assertTrue((boolean)config.persistence().usingStores());
        AssertJUnit.assertEquals((int)1, (int)config.persistence().stores().size());
        AssertJUnit.assertTrue((boolean)(config.persistence().stores().get(0) instanceof SingleFileStoreConfiguration));
        SingleFileStoreConfiguration singleFileStoreConfiguration = (SingleFileStoreConfiguration)config.persistence().stores().get(0);
        AssertJUnit.assertEquals((String)"/tmp/FileCacheStore-Location", (String)singleFileStoreConfiguration.location());
        AssertJUnit.assertEquals((int)5000, (int)singleFileStoreConfiguration.maxEntries());
        AssertJUnit.assertTrue((boolean)singleFileStoreConfiguration.preload());
        AssertJUnit.assertTrue((boolean)singleFileStoreConfiguration.fetchPersistentState());
        AssertJUnit.assertTrue((boolean)singleFileStoreConfiguration.ignoreModifications());
        AssertJUnit.assertTrue((boolean)singleFileStoreConfiguration.purgeOnStartup());
        AssertJUnit.assertTrue((boolean)singleFileStoreConfiguration.async().enabled());
        AssertJUnit.assertEquals((int)5, (int)singleFileStoreConfiguration.async().threadPoolSize());
        AssertJUnit.assertEquals((int)700, (int)singleFileStoreConfiguration.async().modificationQueueSize());
        AssertJUnit.assertFalse((boolean)singleFileStoreConfiguration.singletonStore().enabled());
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("withFileStoreDisabledAsync")).build();
        AssertJUnit.assertFalse((boolean)config.clustering().cacheMode().isClustered());
        AssertJUnit.assertFalse((boolean)config.persistence().usingAsyncStore());
        AssertJUnit.assertFalse((boolean)config.persistence().passivation());
        AssertJUnit.assertTrue((boolean)config.persistence().usingStores());
        AssertJUnit.assertEquals((int)1, (int)config.persistence().stores().size());
        AssertJUnit.assertTrue((boolean)(config.persistence().stores().get(0) instanceof SingleFileStoreConfiguration));
        singleFileStoreConfiguration = (SingleFileStoreConfiguration)config.persistence().stores().get(0);
        AssertJUnit.assertEquals((String)"/tmp/FileCacheStore-Location", (String)singleFileStoreConfiguration.location());
        AssertJUnit.assertEquals((int)5000, (int)singleFileStoreConfiguration.maxEntries());
        AssertJUnit.assertTrue((boolean)singleFileStoreConfiguration.preload());
        AssertJUnit.assertTrue((boolean)singleFileStoreConfiguration.fetchPersistentState());
        AssertJUnit.assertTrue((boolean)singleFileStoreConfiguration.ignoreModifications());
        AssertJUnit.assertTrue((boolean)singleFileStoreConfiguration.purgeOnStartup());
        AssertJUnit.assertFalse((boolean)singleFileStoreConfiguration.async().enabled());
        AssertJUnit.assertFalse((boolean)singleFileStoreConfiguration.singletonStore().enabled());
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("withLoaderDefaults")).build();
        AssertJUnit.assertFalse((boolean)config.clustering().cacheMode().isClustered());
        AssertJUnit.assertFalse((boolean)config.persistence().usingAsyncStore());
        AssertJUnit.assertFalse((boolean)config.persistence().passivation());
        AssertJUnit.assertTrue((boolean)config.persistence().usingStores());
        AssertJUnit.assertEquals((int)1, (int)config.persistence().stores().size());
        AssertJUnit.assertTrue((boolean)(config.persistence().stores().get(0) instanceof SingleFileStoreConfiguration));
        singleFileStoreConfiguration = (SingleFileStoreConfiguration)config.persistence().stores().get(0);
        AssertJUnit.assertEquals((String)"/tmp/Another-FileCacheStore-Location", (String)singleFileStoreConfiguration.location());
        AssertJUnit.assertTrue((boolean)singleFileStoreConfiguration.preload());
        AssertJUnit.assertTrue((boolean)singleFileStoreConfiguration.fetchPersistentState());
        AssertJUnit.assertTrue((boolean)singleFileStoreConfiguration.ignoreModifications());
        AssertJUnit.assertTrue((boolean)singleFileStoreConfiguration.purgeOnStartup());
        AssertJUnit.assertFalse((boolean)singleFileStoreConfiguration.shared());
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("withClusterLoader1")).build();
        AssertJUnit.assertFalse((boolean)config.clustering().cacheMode().isClustered());
        AssertJUnit.assertFalse((boolean)config.persistence().usingAsyncStore());
        AssertJUnit.assertFalse((boolean)config.persistence().passivation());
        AssertJUnit.assertTrue((boolean)config.persistence().usingStores());
        AssertJUnit.assertEquals((int)1, (int)config.persistence().stores().size());
        AssertJUnit.assertTrue((boolean)(config.persistence().stores().get(0) instanceof ClusterLoaderConfiguration));
        clusterLoaderConfiguration = (ClusterLoaderConfiguration)config.persistence().stores().get(0);
        AssertJUnit.assertEquals((long)15000L, (long)clusterLoaderConfiguration.remoteCallTimeout());
        AssertJUnit.assertTrue((boolean)clusterLoaderConfiguration.preload());
        AssertJUnit.assertTrue((boolean)clusterLoaderConfiguration.fetchPersistentState());
        AssertJUnit.assertTrue((boolean)clusterLoaderConfiguration.ignoreModifications());
        AssertJUnit.assertTrue((boolean)clusterLoaderConfiguration.purgeOnStartup());
        AssertJUnit.assertTrue((boolean)clusterLoaderConfiguration.shared());
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("lockingWithJDBCLoader")).build();
        AssertJUnit.assertTrue((boolean)config.clustering().cacheMode().isClustered());
        AssertJUnit.assertTrue((boolean)config.clustering().cacheMode().isSynchronous());
        AssertJUnit.assertEquals((long)20000L, (long)config.clustering().sync().replTimeout());
        AssertJUnit.assertFalse((boolean)config.persistence().usingAsyncStore());
        AssertJUnit.assertTrue((boolean)config.persistence().passivation());
        AssertJUnit.assertTrue((boolean)config.persistence().usingStores());
        AssertJUnit.assertEquals((int)1, (int)config.persistence().stores().size());
        AssertJUnit.assertTrue((boolean)(config.persistence().stores().get(0) instanceof SingleFileStoreConfiguration));
        singleFileStoreConfiguration = (SingleFileStoreConfiguration)config.persistence().stores().get(0);
        AssertJUnit.assertTrue((boolean)singleFileStoreConfiguration.preload());
        AssertJUnit.assertTrue((boolean)singleFileStoreConfiguration.fetchPersistentState());
        AssertJUnit.assertTrue((boolean)singleFileStoreConfiguration.ignoreModifications());
        AssertJUnit.assertTrue((boolean)singleFileStoreConfiguration.purgeOnStartup());
        AssertJUnit.assertFalse((boolean)singleFileStoreConfiguration.shared());
        AssertJUnit.assertFalse((boolean)singleFileStoreConfiguration.async().enabled());
        AssertJUnit.assertTrue((boolean)singleFileStoreConfiguration.singletonStore().enabled());
        AssertJUnit.assertEquals((String)"${java.io.tmpdir}", (String)singleFileStoreConfiguration.location());
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("jdbcStringBasedWithConnectionPool")).build();
        AssertJUnit.assertFalse((boolean)config.clustering().cacheMode().isClustered());
        AssertJUnit.assertFalse((boolean)config.persistence().usingAsyncStore());
        AssertJUnit.assertFalse((boolean)config.persistence().passivation());
        AssertJUnit.assertTrue((boolean)config.persistence().usingStores());
        AssertJUnit.assertEquals((int)1, (int)config.persistence().stores().size());
        AssertJUnit.assertTrue((boolean)(config.persistence().stores().get(0) instanceof JdbcStringBasedStoreConfiguration));
        JdbcStringBasedStoreConfiguration jdbcStringBasedStoreConfiguration = (JdbcStringBasedStoreConfiguration)config.persistence().stores().get(0);
        AssertJUnit.assertFalse((boolean)jdbcStringBasedStoreConfiguration.fetchPersistentState());
        AssertJUnit.assertFalse((boolean)jdbcStringBasedStoreConfiguration.ignoreModifications());
        AssertJUnit.assertFalse((boolean)jdbcStringBasedStoreConfiguration.purgeOnStartup());
        AssertJUnit.assertEquals((String)"org.infinispan.persistence.jdbc.configuration.DummyKey2StringMapper", (String)jdbcStringBasedStoreConfiguration.key2StringMapper());
        AssertJUnit.assertTrue((boolean)jdbcStringBasedStoreConfiguration.table().dropOnExit());
        AssertJUnit.assertTrue((boolean)jdbcStringBasedStoreConfiguration.table().createOnStart());
        AssertJUnit.assertEquals((String)"ISPN_STRING_TABLE", (String)jdbcStringBasedStoreConfiguration.table().tableNamePrefix());
        AssertJUnit.assertEquals((String)"ID_COLUMN", (String)jdbcStringBasedStoreConfiguration.table().idColumnName());
        AssertJUnit.assertEquals((String)"VARCHAR(255)", (String)jdbcStringBasedStoreConfiguration.table().idColumnType());
        AssertJUnit.assertEquals((String)"DATA_COLUMN", (String)jdbcStringBasedStoreConfiguration.table().dataColumnName());
        AssertJUnit.assertEquals((String)"BINARY", (String)jdbcStringBasedStoreConfiguration.table().dataColumnType());
        AssertJUnit.assertEquals((String)"TIMESTAMP_COLUMN", (String)jdbcStringBasedStoreConfiguration.table().timestampColumnName());
        AssertJUnit.assertEquals((String)"BIGINT", (String)jdbcStringBasedStoreConfiguration.table().timestampColumnType());
        PooledConnectionFactoryConfiguration connectionPool = (PooledConnectionFactoryConfiguration)jdbcStringBasedStoreConfiguration.connectionFactory();
        AssertJUnit.assertEquals((String)"jdbc:h2:mem:infinispan_string_based;DB_CLOSE_DELAY=-1", (String)connectionPool.connectionUrl());
        AssertJUnit.assertEquals((String)"sa", (String)connectionPool.username());
        AssertJUnit.assertEquals((String)"sa", (String)connectionPool.password());
        AssertJUnit.assertEquals((String)"org.h2.Driver", (String)connectionPool.driverClass());
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("jdbcStringBasedWithDataSource")).build();
        AssertJUnit.assertFalse((boolean)config.clustering().cacheMode().isClustered());
        AssertJUnit.assertFalse((boolean)config.persistence().usingAsyncStore());
        AssertJUnit.assertFalse((boolean)config.persistence().passivation());
        AssertJUnit.assertTrue((boolean)config.persistence().usingStores());
        AssertJUnit.assertEquals((int)1, (int)config.persistence().stores().size());
        AssertJUnit.assertTrue((boolean)(config.persistence().stores().get(0) instanceof JdbcStringBasedStoreConfiguration));
        jdbcStringBasedStoreConfiguration = (JdbcStringBasedStoreConfiguration)config.persistence().stores().get(0);
        AssertJUnit.assertFalse((boolean)jdbcStringBasedStoreConfiguration.fetchPersistentState());
        AssertJUnit.assertTrue((boolean)jdbcStringBasedStoreConfiguration.ignoreModifications());
        AssertJUnit.assertTrue((boolean)jdbcStringBasedStoreConfiguration.purgeOnStartup());
        AssertJUnit.assertEquals((String)"org.infinispan.persistence.jdbc.configuration.DummyKey2StringMapper", (String)jdbcStringBasedStoreConfiguration.key2StringMapper());
        AssertJUnit.assertTrue((boolean)jdbcStringBasedStoreConfiguration.table().dropOnExit());
        AssertJUnit.assertTrue((boolean)jdbcStringBasedStoreConfiguration.table().createOnStart());
        AssertJUnit.assertEquals((int)50, (int)jdbcStringBasedStoreConfiguration.table().batchSize());
        AssertJUnit.assertEquals((int)70, (int)jdbcStringBasedStoreConfiguration.table().fetchSize());
        AssertJUnit.assertEquals((String)"ISPN_STRING_TABLE", (String)jdbcStringBasedStoreConfiguration.table().tableNamePrefix());
        AssertJUnit.assertEquals((String)"ID_COLUMN", (String)jdbcStringBasedStoreConfiguration.table().idColumnName());
        AssertJUnit.assertEquals((String)"VARCHAR(255)", (String)jdbcStringBasedStoreConfiguration.table().idColumnType());
        AssertJUnit.assertEquals((String)"DATA_COLUMN", (String)jdbcStringBasedStoreConfiguration.table().dataColumnName());
        AssertJUnit.assertEquals((String)"BINARY", (String)jdbcStringBasedStoreConfiguration.table().dataColumnType());
        AssertJUnit.assertEquals((String)"TIMESTAMP_COLUMN", (String)jdbcStringBasedStoreConfiguration.table().timestampColumnName());
        AssertJUnit.assertEquals((String)"BIGINT", (String)jdbcStringBasedStoreConfiguration.table().timestampColumnType());
        ManagedConnectionFactoryConfiguration managedConnectionFactoryConfiguration = (ManagedConnectionFactoryConfiguration)jdbcStringBasedStoreConfiguration.connectionFactory();
        AssertJUnit.assertEquals((String)"url", (String)managedConnectionFactoryConfiguration.jndiUrl());
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("jdbcStringBasedWithSimpleConnection")).build();
        AssertJUnit.assertFalse((boolean)config.clustering().cacheMode().isClustered());
        AssertJUnit.assertFalse((boolean)config.persistence().usingAsyncStore());
        AssertJUnit.assertFalse((boolean)config.persistence().passivation());
        AssertJUnit.assertTrue((boolean)config.persistence().usingStores());
        AssertJUnit.assertEquals((int)1, (int)config.persistence().stores().size());
        AssertJUnit.assertTrue((boolean)(config.persistence().stores().get(0) instanceof JdbcStringBasedStoreConfiguration));
        jdbcStringBasedStoreConfiguration = (JdbcStringBasedStoreConfiguration)config.persistence().stores().get(0);
        AssertJUnit.assertTrue((boolean)jdbcStringBasedStoreConfiguration.fetchPersistentState());
        AssertJUnit.assertTrue((boolean)jdbcStringBasedStoreConfiguration.ignoreModifications());
        AssertJUnit.assertFalse((boolean)jdbcStringBasedStoreConfiguration.purgeOnStartup());
        AssertJUnit.assertEquals((String)"org.infinispan.persistence.jdbc.configuration.DummyKey2StringMapper", (String)jdbcStringBasedStoreConfiguration.key2StringMapper());
        AssertJUnit.assertFalse((boolean)jdbcStringBasedStoreConfiguration.table().dropOnExit());
        AssertJUnit.assertFalse((boolean)jdbcStringBasedStoreConfiguration.table().createOnStart());
        AssertJUnit.assertEquals((String)"ISPN_STRING_TABLE", (String)jdbcStringBasedStoreConfiguration.table().tableNamePrefix());
        AssertJUnit.assertEquals((String)"ID_COLUMN", (String)jdbcStringBasedStoreConfiguration.table().idColumnName());
        AssertJUnit.assertEquals((String)"VARCHAR(255)", (String)jdbcStringBasedStoreConfiguration.table().idColumnType());
        AssertJUnit.assertEquals((String)"DATA_COLUMN", (String)jdbcStringBasedStoreConfiguration.table().dataColumnName());
        AssertJUnit.assertEquals((String)"BINARY", (String)jdbcStringBasedStoreConfiguration.table().dataColumnType());
        AssertJUnit.assertEquals((String)"TIMESTAMP_COLUMN", (String)jdbcStringBasedStoreConfiguration.table().timestampColumnName());
        AssertJUnit.assertEquals((String)"BIGINT", (String)jdbcStringBasedStoreConfiguration.table().timestampColumnType());
        SimpleConnectionFactoryConfiguration simpleConnectionFactoryConfiguration = (SimpleConnectionFactoryConfiguration)jdbcStringBasedStoreConfiguration.connectionFactory();
        AssertJUnit.assertEquals((String)"jdbc:h2:mem:infinispan_string_based;DB_CLOSE_DELAY=-1", (String)simpleConnectionFactoryConfiguration.connectionUrl());
        AssertJUnit.assertEquals((String)"sa", (String)simpleConnectionFactoryConfiguration.username());
        AssertJUnit.assertEquals((String)"sa", (String)simpleConnectionFactoryConfiguration.password());
        AssertJUnit.assertEquals((String)"org.h2.Driver", (String)simpleConnectionFactoryConfiguration.driverClass());
        AssertJUnit.assertTrue((boolean)jdbcStringBasedStoreConfiguration.singletonStore().enabled());
        AssertJUnit.assertEquals((String)"testValue", (String)jdbcStringBasedStoreConfiguration.properties().getProperty("testName"));
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("withRemoteStore")).build();
        AssertJUnit.assertFalse((boolean)config.clustering().cacheMode().isClustered());
        AssertJUnit.assertFalse((boolean)config.persistence().usingAsyncStore());
        AssertJUnit.assertFalse((boolean)config.persistence().passivation());
        AssertJUnit.assertTrue((boolean)config.persistence().usingStores());
        AssertJUnit.assertEquals((int)1, (int)config.persistence().stores().size());
        AssertJUnit.assertTrue((boolean)(config.persistence().stores().get(0) instanceof RemoteStoreConfiguration));
        RemoteStoreConfiguration remoteStoreConfiguration = (RemoteStoreConfiguration)config.persistence().stores().get(0);
        AssertJUnit.assertFalse((boolean)remoteStoreConfiguration.fetchPersistentState());
        AssertJUnit.assertTrue((boolean)remoteStoreConfiguration.shared());
        AssertJUnit.assertFalse((boolean)remoteStoreConfiguration.preload());
        AssertJUnit.assertFalse((boolean)remoteStoreConfiguration.ignoreModifications());
        AssertJUnit.assertFalse((boolean)remoteStoreConfiguration.purgeOnStartup());
        AssertJUnit.assertTrue((boolean)remoteStoreConfiguration.tcpNoDelay());
        AssertJUnit.assertEquals((String)"org.infinispan.client.hotrod.impl.transport.tcp.RoundRobinBalancingStrategy", (String)remoteStoreConfiguration.balancingStrategy());
        AssertJUnit.assertEquals((String)"org.infinispan.client.hotrod.impl.transport.tcp.TcpTransportFactory", (String)remoteStoreConfiguration.transportFactory());
        AssertJUnit.assertEquals((int)32, (int)remoteStoreConfiguration.keySizeEstimate());
        AssertJUnit.assertEquals((int)512, (int)remoteStoreConfiguration.valueSizeEstimate());
        AssertJUnit.assertFalse((boolean)remoteStoreConfiguration.forceReturnValues());
        AssertJUnit.assertEquals((long)5000L, (long)remoteStoreConfiguration.connectionTimeout());
        AssertJUnit.assertFalse((boolean)remoteStoreConfiguration.hotRodWrapping());
        AssertJUnit.assertEquals((String)"org.infinispan.commons.marshall.jboss.GenericJBossMarshaller", (String)remoteStoreConfiguration.marshaller());
        AssertJUnit.assertEquals((String)"1.0", (String)remoteStoreConfiguration.protocolVersion());
        AssertJUnit.assertTrue((boolean)remoteStoreConfiguration.rawValues());
        AssertJUnit.assertEquals((String)"test", (String)remoteStoreConfiguration.remoteCacheName());
        AssertJUnit.assertEquals((long)12500L, (long)remoteStoreConfiguration.socketTimeout());
        AssertJUnit.assertEquals((int)1, (int)remoteStoreConfiguration.servers().size());
        AssertJUnit.assertEquals((String)"127.0.0.1", (String)((RemoteServerConfiguration)remoteStoreConfiguration.servers().get(0)).host());
        AssertJUnit.assertEquals((int)19711, (int)((RemoteServerConfiguration)remoteStoreConfiguration.servers().get(0)).port());
        AssertJUnit.assertTrue((boolean)(remoteStoreConfiguration.asyncExecutorFactory().factory() instanceof DefaultAsyncExecutorFactory));
        AssertJUnit.assertEquals((int)1, (int)remoteStoreConfiguration.asyncExecutorFactory().properties().getIntProperty("pool_size", 0));
        AssertJUnit.assertEquals((int)10000, (int)remoteStoreConfiguration.asyncExecutorFactory().properties().getIntProperty("queue_size", 0));
        org.infinispan.persistence.remote.configuration.ConnectionPoolConfiguration remoteConnectionPoolConfiguration = remoteStoreConfiguration.connectionPool();
        AssertJUnit.assertEquals((int)99, (int)remoteConnectionPoolConfiguration.maxActive());
        AssertJUnit.assertEquals((int)97, (int)remoteConnectionPoolConfiguration.maxIdle());
        AssertJUnit.assertEquals((int)27, (int)remoteConnectionPoolConfiguration.minIdle());
        AssertJUnit.assertEquals((int)98, (int)remoteConnectionPoolConfiguration.maxTotal());
        AssertJUnit.assertEquals((String)"CREATE_NEW", (String)remoteConnectionPoolConfiguration.exhaustedAction().name());
        AssertJUnit.assertEquals((long)50L, (long)remoteConnectionPoolConfiguration.minEvictableIdleTime());
        AssertJUnit.assertEquals((long)60000L, (long)remoteConnectionPoolConfiguration.timeBetweenEvictionRuns());
        AssertJUnit.assertFalse((boolean)remoteConnectionPoolConfiguration.testWhileIdle());
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("withRestStore")).build();
        AssertJUnit.assertFalse((boolean)config.clustering().cacheMode().isClustered());
        AssertJUnit.assertFalse((boolean)config.persistence().usingAsyncStore());
        AssertJUnit.assertFalse((boolean)config.persistence().passivation());
        AssertJUnit.assertTrue((boolean)config.persistence().usingStores());
        AssertJUnit.assertEquals((int)1, (int)config.persistence().stores().size());
        AssertJUnit.assertTrue((boolean)(config.persistence().stores().get(0) instanceof RestStoreConfiguration));
        RestStoreConfiguration restStoreConfiguration = (RestStoreConfiguration)config.persistence().stores().get(0);
        AssertJUnit.assertFalse((boolean)restStoreConfiguration.fetchPersistentState());
        AssertJUnit.assertFalse((boolean)restStoreConfiguration.ignoreModifications());
        AssertJUnit.assertTrue((boolean)restStoreConfiguration.purgeOnStartup());
        AssertJUnit.assertTrue((boolean)restStoreConfiguration.shared());
        AssertJUnit.assertFalse((boolean)restStoreConfiguration.preload());
        AssertJUnit.assertEquals((String)"org.infinispan.persistence.keymappers.WrappedByteArrayOrPrimitiveMapper", (String)restStoreConfiguration.key2StringMapper());
        AssertJUnit.assertEquals((String)"/rest/___defaultcache/", (String)restStoreConfiguration.path());
        AssertJUnit.assertEquals((String)"localhost", (String)restStoreConfiguration.host());
        AssertJUnit.assertEquals((int)18212, (int)restStoreConfiguration.port());
        AssertJUnit.assertTrue((boolean)restStoreConfiguration.appendCacheNameToPath());
        ConnectionPoolConfiguration restConnectionPool = restStoreConfiguration.connectionPool();
        AssertJUnit.assertEquals((int)10000, (int)restConnectionPool.connectionTimeout());
        AssertJUnit.assertEquals((int)10, (int)restConnectionPool.maxConnectionsPerHost());
        AssertJUnit.assertEquals((int)10, (int)restConnectionPool.maxTotalConnections());
        AssertJUnit.assertEquals((int)20000, (int)restConnectionPool.bufferSize());
        AssertJUnit.assertEquals((int)10000, (int)restConnectionPool.socketTimeout());
        AssertJUnit.assertTrue((boolean)restConnectionPool.tcpNoDelay());
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("withLevelDBStore")).build();
        AssertJUnit.assertFalse((boolean)config.clustering().cacheMode().isClustered());
        AssertJUnit.assertFalse((boolean)config.persistence().usingAsyncStore());
        AssertJUnit.assertTrue((boolean)config.persistence().passivation());
        AssertJUnit.assertTrue((boolean)config.persistence().usingStores());
        AssertJUnit.assertEquals((int)1, (int)config.persistence().stores().size());
        AssertJUnit.assertTrue((boolean)(config.persistence().stores().get(0) instanceof RocksDBStoreConfiguration));
        RocksDBStoreConfiguration rocksDBStoreConfiguration = (RocksDBStoreConfiguration)config.persistence().stores().get(0);
        AssertJUnit.assertEquals((String)"/tmp/leveldb/data", (String)rocksDBStoreConfiguration.location());
        AssertJUnit.assertEquals((String)"/tmp/leveldb/expired", (String)rocksDBStoreConfiguration.expiredLocation());
        AssertJUnit.assertFalse((boolean)rocksDBStoreConfiguration.shared());
        AssertJUnit.assertTrue((boolean)rocksDBStoreConfiguration.preload());
        AssertJUnit.assertEquals((int)20, (int)rocksDBStoreConfiguration.clearThreshold());
        AssertJUnit.assertEquals((int)30, (int)rocksDBStoreConfiguration.expiryQueueSize());
        AssertJUnit.assertEquals((int)10, (int)rocksDBStoreConfiguration.blockSize());
        AssertJUnit.assertEquals((long)50L, (long)rocksDBStoreConfiguration.cacheSize());
        AssertJUnit.assertEquals((String)"SNAPPY", (String)rocksDBStoreConfiguration.compressionType().name());
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("withJpaStore")).build();
        AssertJUnit.assertFalse((boolean)config.clustering().cacheMode().isClustered());
        AssertJUnit.assertFalse((boolean)config.persistence().usingAsyncStore());
        AssertJUnit.assertTrue((boolean)config.persistence().passivation());
        AssertJUnit.assertTrue((boolean)config.persistence().usingStores());
        AssertJUnit.assertEquals((int)1, (int)config.persistence().stores().size());
        AssertJUnit.assertTrue((boolean)(config.persistence().stores().get(0) instanceof JpaStoreConfiguration));
        JpaStoreConfiguration jpaStoreConfiguration = (JpaStoreConfiguration)config.persistence().stores().get(0);
        AssertJUnit.assertEquals((String)"TestPersistentName", (String)jpaStoreConfiguration.persistenceUnitName());
        AssertJUnit.assertEquals((long)80L, (long)jpaStoreConfiguration.batchSize());
        AssertJUnit.assertEquals((String)"org.infinispan.tools.customs.CustomDataContainer", (String)jpaStoreConfiguration.entityClass().getCanonicalName());
        AssertJUnit.assertFalse((boolean)jpaStoreConfiguration.storeMetadata());
    }

    private void assertUnsafeConverted(ConfigurationBuilderHolder holder) {
        Configuration config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("withUnsafe")).build();
        AssertJUnit.assertTrue((boolean)config.unsafe().unreliableReturnValues());
        config = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("withUnsafeDisabled")).build();
        AssertJUnit.assertFalse((boolean)config.unsafe().unreliableReturnValues());
    }
}

