/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator;

import java.util.Properties;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.tools.store.migrator.Element;
import org.infinispan.tools.store.migrator.StoreType;

public class StoreProperties {
    private final Element root;
    private final Properties properties;
    private final StoreType storeType;
    private final String cacheName;

    public StoreProperties(Element root, Properties properties) {
        this.root = root;
        this.properties = properties;
        this.validate();
        this.storeType = StoreType.valueOf(this.get(Element.TYPE).toUpperCase());
        this.cacheName = this.get(Element.CACHE_NAME);
    }

    public boolean isTargetStore() {
        return this.root == Element.TARGET;
    }

    public String cacheName() {
        return this.cacheName;
    }

    public StoreType storeType() {
        return this.storeType;
    }

    public String get(Element ... elements) {
        return this.properties.getProperty(this.key(elements));
    }

    public String key(Element ... elements) {
        StringBuilder sb = new StringBuilder(this.root.toString().toLowerCase());
        sb.append(".");
        for (int i = 0; i < elements.length; ++i) {
            sb.append(elements[i].toString());
            if (i == elements.length - 1) continue;
            sb.append(".");
        }
        return sb.toString();
    }

    public void required(String ... required) {
        for (String prop : required) {
            if (this.properties.get(prop) != null) continue;
            String msg = String.format("The property %s must be specified.", prop);
            throw new CacheConfigurationException(msg);
        }
    }

    public void required(Element ... required) {
        for (Element prop : required) {
            if (this.properties.get(this.key(prop)) != null) continue;
            String msg = String.format("The property '%s' must be specified.", this.key(prop));
            throw new CacheConfigurationException(msg);
        }
    }

    private void validate() {
        this.required(Element.TYPE);
        this.required(Element.CACHE_NAME);
    }
}

