/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferImpl;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.marshall.core.MarshalledEntryImpl;
import org.infinispan.tools.store.migrator.Element;
import org.infinispan.tools.store.migrator.StoreIterator;
import org.infinispan.tools.store.migrator.StoreProperties;
import org.infinispan.tools.store.migrator.marshaller.SerializationConfigUtil;

public class SingleFileStoreReader
implements StoreIterator {
    private final FileChannel channel;
    private final StreamingMarshaller marshaller;

    public SingleFileStoreReader(StoreProperties props) {
        props.required(Element.LOCATION);
        String location = props.get(Element.LOCATION) + props.get(Element.CACHE_NAME) + ".dat";
        File file = new File(location);
        if (!file.exists() || file.isDirectory()) {
            throw new CacheException(String.format("Unable to read SingleFileStore at '%s'", location));
        }
        try {
            this.channel = new RandomAccessFile(file, "rw").getChannel();
        }
        catch (FileNotFoundException e) {
            throw new CacheException((Throwable)e);
        }
        this.marshaller = SerializationConfigUtil.getMarshaller(props);
    }

    @Override
    public void close() throws Exception {
        this.channel.close();
    }

    @Override
    public Iterator<MarshalledEntry> iterator() {
        return new SingleFileIterator();
    }

    class SingleFileIterator
    implements Iterator<MarshalledEntry> {
        private static final int KEY_POS = 24;
        int filePos = 4;

        SingleFileIterator() {
        }

        @Override
        public boolean hasNext() {
            java.nio.ByteBuffer buf = this.readFileEntry();
            return buf.remaining() <= 0;
        }

        @Override
        public MarshalledEntry next() {
            while (true) {
                java.nio.ByteBuffer buf;
                if ((buf = this.readFileEntry()).remaining() > 0) {
                    throw new NoSuchElementException();
                }
                buf.flip();
                int entrySize = buf.getInt();
                int keyLen = buf.getInt();
                int dataLen = buf.getInt();
                int metadataLen = buf.getInt();
                buf.getLong();
                if (entrySize < 24 + keyLen + dataLen + metadataLen) {
                    throw new CacheException(String.format("Failed to read entries from file. Error at offset %d", this.filePos));
                }
                if (keyLen > 0) {
                    try {
                        if (buf.capacity() < keyLen) {
                            buf = java.nio.ByteBuffer.allocate(keyLen);
                        }
                        buf.clear().limit(keyLen);
                        byte[] data = new byte[keyLen + dataLen + metadataLen];
                        SingleFileStoreReader.this.channel.read(java.nio.ByteBuffer.wrap(data), this.filePos + 24);
                        this.filePos += entrySize;
                        ByteBufferImpl keyBb = new ByteBufferImpl(data, 0, keyLen);
                        ByteBufferImpl valueBb = new ByteBufferImpl(data, keyLen, dataLen);
                        return new MarshalledEntryImpl((ByteBuffer)keyBb, (ByteBuffer)valueBb, (ByteBuffer)null, SingleFileStoreReader.this.marshaller);
                    }
                    catch (IOException e) {
                        throw new CacheException(String.format("Unable to read file entry at offset %d", this.filePos), (Throwable)e);
                    }
                }
                this.filePos += entrySize;
            }
        }

        java.nio.ByteBuffer readFileEntry() {
            java.nio.ByteBuffer buf = java.nio.ByteBuffer.allocate(24);
            buf.clear().limit(24);
            try {
                SingleFileStoreReader.this.channel.read(buf, this.filePos);
            }
            catch (IOException e) {
                throw new CacheException((Throwable)e);
            }
            return buf;
        }
    }
}

