/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.xsd;

import gnu.getopt.Getopt;
import java.io.File;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.infinispan.tools.ToolUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSDoc {
    private final Map<String, Document> xmls = new LinkedHashMap<String, Document>();
    private final Map<String, Schema> latestSchemas = new LinkedHashMap<String, Schema>();
    private final Transformer xslt;
    private final DocumentBuilder docBuilder;
    private final Document indexDoc;
    private Element indexRoot;
    private TransformerFactory factory = TransformerFactory.newInstance();

    XSDoc() throws Exception {
        this.factory.setURIResolver((href, base) -> {
            Document doc = this.xmls.get(ToolUtils.getBaseFileName(href));
            if (doc != null) {
                return new DOMSource(doc);
            }
            return null;
        });
        ClassLoader cl = XSDoc.class.getClassLoader();
        try (InputStream xsl = cl.getResourceAsStream("xsd/xsdoc.xslt");){
            this.xslt = this.factory.newTransformer(new StreamSource(xsl));
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        this.docBuilder = dbf.newDocumentBuilder();
        this.indexDoc = this.docBuilder.newDocument();
        this.indexRoot = this.indexDoc.createElement("files");
        this.indexDoc.appendChild(this.indexRoot);
    }

    void load(String fileName) throws Exception {
        Document doc = this.docBuilder.parse(new File(fileName));
        String name = ToolUtils.getBaseFileName(fileName);
        this.xmls.put(name, doc);
        Schema schema = new Schema(doc, name);
        Schema current = this.latestSchemas.get(schema.namespace);
        if (schema.since(current)) {
            this.latestSchemas.put(schema.namespace, schema);
        }
    }

    private void transform(String name, Document doc, File outputDir) {
        try {
            this.xslt.transform(new DOMSource(doc), new StreamResult(new File(outputDir, name + ".html")));
            Element item = this.indexDoc.createElement("file");
            item.setAttribute("name", name + ".html");
            String ns = XSDoc.getDocumentNamespace(doc);
            item.setAttribute("ns", ns);
            this.indexRoot.appendChild(item);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getDocumentNamespace(Document doc) {
        Node child = doc.getFirstChild();
        while (!(child instanceof Element)) {
            child = child.getNextSibling();
        }
        return ((Element)child).getAttribute("targetNamespace");
    }

    void transformAll(File outputDir) {
        this.latestSchemas.values().forEach(schema -> this.transform(schema.name, schema.doc, outputDir));
    }

    private void generateIndex(File outputDir) throws Exception {
        ToolUtils.printDocument(this.indexDoc, System.out);
        ClassLoader cl = XSDoc.class.getClassLoader();
        try (InputStream xsl = cl.getResourceAsStream("xsd/index.xslt");){
            Transformer indexXSLT = this.factory.newTransformer(new StreamSource(xsl));
            indexXSLT.transform(new DOMSource(this.indexDoc), new StreamResult(new File(outputDir, "index.html")));
        }
    }

    public static void main(String[] argv) throws Exception {
        XSDoc xsDoc = new XSDoc();
        String outputDir = System.getProperty("user.dir");
        Getopt opts = new Getopt("xsdoc", argv, "o:");
        int opt = opts.getopt();
        while (opt > -1) {
            switch (opt) {
                case 111: {
                    outputDir = opts.getOptarg();
                }
            }
            opt = opts.getopt();
        }
        File outDir = new File(outputDir);
        outDir.mkdirs();
        for (int i = opts.getOptind(); i < argv.length; ++i) {
            xsDoc.load(argv[i]);
        }
        xsDoc.transformAll(outDir);
        xsDoc.generateIndex(outDir);
    }

    public class Schema {
        final String namespace;
        final String name;
        final Document doc;
        final int major;
        final int minor;

        public Schema(Document doc, String name) {
            this.name = name;
            this.doc = doc;
            String versionedNamespace = XSDoc.getDocumentNamespace(doc);
            if (versionedNamespace.startsWith("urn:")) {
                int versionSeparator = versionedNamespace.lastIndexOf(58);
                this.namespace = versionedNamespace.substring(0, versionSeparator);
                String[] versionParts = versionedNamespace.substring(versionSeparator + 1).split("\\.");
                this.major = Integer.parseInt(versionParts[0]);
                this.minor = Integer.parseInt(versionParts[1]);
            } else {
                this.namespace = versionedNamespace;
                this.major = 0;
                this.minor = 0;
            }
        }

        public boolean since(Schema schema) {
            return schema == null || this.major > schema.major || this.major == schema.major && this.minor >= schema.minor;
        }
    }
}

