/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.rocksdb;

import java.util.Properties;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.persistence.rocksdb.configuration.RocksDBStoreConfigurationBuilder;
import org.infinispan.tools.store.migrator.AbstractReaderTest;
import org.infinispan.tools.store.migrator.Element;
import org.infinispan.tools.store.migrator.StoreType;
import org.infinispan.tools.store.migrator.TestUtil;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(testName="tools.store.migrator.rocksdb.RocksDBReaderTest", groups={"functional"})
public class RocksDBReaderTest
extends AbstractReaderTest {
    private static final String SOURCE_DIR = "target/test-classes/leveldbstore/";

    private String getTargetDirectory() {
        return "target/test-classes/leveldbstore//rocksdbstore-" + this.segmentCount + "/";
    }

    @Factory
    public Object[] factory() {
        return new Object[]{new RocksDBReaderTest().segmented(29), new RocksDBReaderTest()};
    }

    @Override
    public ConfigurationBuilder getTargetCacheConfig() {
        ConfigurationBuilder builder = super.getTargetCacheConfig();
        String targetDir = this.getTargetDirectory();
        ((RocksDBStoreConfigurationBuilder)((RocksDBStoreConfigurationBuilder)((RocksDBStoreConfigurationBuilder)builder.persistence().addStore(RocksDBStoreConfigurationBuilder.class)).location(targetDir).expiredLocation(targetDir + "expired").preload(true)).ignoreModifications(true)).segmented(this.segmentCount > 0);
        return builder;
    }

    @Override
    protected void configureStoreProperties(Properties properties, Element type) {
        super.configureStoreProperties(properties, type);
        properties.put(TestUtil.propKey(type, Element.TYPE), StoreType.ROCKSDB.toString());
        properties.put(TestUtil.propKey(type, Element.LOCATION), type == Element.SOURCE ? SOURCE_DIR : this.getTargetDirectory());
    }
}

