/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.conf;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jgroups.Constructable;
import org.jgroups.Header;
import org.jgroups.util.Triple;
import org.jgroups.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ClassConfigurator {
    public static final String MAGIC_NUMBER_FILE = "jg-magic-map.xml";
    public static final String PROTOCOL_ID_FILE = "jg-protocol-ids.xml";
    private static final int MAX_MAGIC_VALUE = 100;
    private static final short MIN_CUSTOM_MAGIC_NUMBER = 1024;
    private static final short MIN_CUSTOM_PROTOCOL_ID = 512;
    private static final Map<Class, Short> classMap = new IdentityHashMap<Class, Short>(100);
    private static final Supplier<? extends Object>[] magicMap = new Supplier[100];
    private static final Map<Short, Object> magicMapUser = new HashMap<Short, Object>();
    private static final Map<Class, Short> protocol_ids = new HashMap<Class, Short>(100);
    private static final Map<Short, Class> protocol_names = new HashMap<Short, Class>(100);

    public static void add(short magic, Class clazz) {
        if (magic < 1024) {
            throw new IllegalArgumentException("magic ID (" + magic + ") must be >= " + 1024);
        }
        if (magicMapUser.containsKey(magic) || classMap.containsKey(clazz)) {
            ClassConfigurator.alreadyInMagicMap(magic, clazz.getName());
        }
        Object inst = null;
        try {
            inst = clazz.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("failed creating instance " + clazz, e);
        }
        Supplier val = clazz;
        if (Header.class.isAssignableFrom(clazz)) {
            ClassConfigurator.checkSameId((Header)inst, magic);
            val = ((Header)inst).create();
        }
        if (Constructable.class.isAssignableFrom(clazz) && !(inst = (Object)(val = ((Constructable)inst).create()).get()).getClass().equals(clazz)) {
            throw new IllegalStateException(String.format("%s.create() returned the wrong class: %s\n", clazz.getSimpleName(), inst.getClass().getSimpleName()));
        }
        magicMapUser.put(magic, val);
        classMap.put(clazz, magic);
    }

    public static void addProtocol(short id, Class protocol) {
        if (id < 512) {
            throw new IllegalArgumentException("protocol ID (" + id + ") needs to be greater than or equal to " + 512);
        }
        if (protocol_ids.containsKey(protocol)) {
            ClassConfigurator.alreadyInProtocolsMap(id, protocol.getName());
        }
        protocol_ids.put(protocol, id);
    }

    public static <T> T create(short id) throws Exception {
        if (id >= 1024) {
            Object val = magicMapUser.get(id);
            if (val == null) {
                throw new ClassNotFoundException("Class for magic number " + id + " cannot be found");
            }
            return val instanceof Supplier ? ((Supplier)val).get() : ((Class)val).newInstance();
        }
        Supplier<? extends Object> supplier = magicMap[id];
        if (supplier == null) {
            throw new ClassNotFoundException("Class for magic number " + id + " cannot be found");
        }
        return (T)supplier.get();
    }

    public static Class get(String clazzname, ClassLoader loader) throws ClassNotFoundException {
        return Util.loadClass(clazzname, loader != null ? loader : ClassConfigurator.class.getClassLoader());
    }

    public static Class get(String clazzname) throws ClassNotFoundException {
        return Util.loadClass(clazzname, ClassConfigurator.class);
    }

    public static short getMagicNumber(Class clazz) {
        Short i = classMap.get(clazz);
        if (i == null) {
            return -1;
        }
        return i;
    }

    public static short getProtocolId(Class protocol) {
        Short retval = protocol_ids.get(protocol);
        return retval != null ? retval : (short)0;
    }

    public static Class getProtocol(short id) {
        return protocol_names.get(id);
    }

    public static String printClassMap() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Class, Short> entry : classMap.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append('\n');
        }
        return sb.toString();
    }

    protected static void init() throws Exception {
        Class clazz;
        boolean external;
        short m;
        Util.loadClass("javax.xml.parsers.DocumentBuilderFactory", ClassConfigurator.class);
        String magic_number_file = null;
        String protocol_id_file = null;
        try {
            magic_number_file = Util.getProperty(new String[]{"jgroups.conf.magic_number_file", "org.jgroups.conf.magicNumberFile"}, null, null, MAGIC_NUMBER_FILE);
            protocol_id_file = Util.getProperty(new String[]{"jgroups.conf.protocol_id_file", "org.jgroups.conf.protocolIDFile"}, null, null, PROTOCOL_ID_FILE);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        List<Triple<Short, String, Boolean>> mapping = ClassConfigurator.readMappings(magic_number_file);
        for (Triple<Short, String, Boolean> tuple : mapping) {
            m = tuple.getVal1();
            if (m >= 100) {
                throw new IllegalArgumentException("ID " + m + " is bigger than MAX_MAGIC_VALUE (" + 100 + "); increase MAX_MAGIC_VALUE");
            }
            external = tuple.getVal3();
            if (external) {
                if (magicMap[m] == null) continue;
                ClassConfigurator.alreadyInMagicMap(m, tuple.getVal2());
                continue;
            }
            clazz = Util.loadClass(tuple.getVal2(), ClassConfigurator.class);
            if (magicMap[m] != null) {
                ClassConfigurator.alreadyInMagicMap(m, clazz.getName());
            }
            if (Constructable.class.isAssignableFrom(clazz)) {
                Constructable obj = (Constructable)clazz.newInstance();
                ClassConfigurator.magicMap[m] = obj.create();
            } else {
                Supplier<Object> supplier = () -> {
                    try {
                        return clazz.newInstance();
                    }
                    catch (Throwable throwable) {
                        return null;
                    }
                };
                ClassConfigurator.magicMap[m] = supplier;
            }
            Object inst = magicMap[m].get();
            if (!inst.getClass().equals(clazz)) {
                throw new IllegalStateException(String.format("%s.create() returned the wrong class: %s\n", clazz.getSimpleName(), inst.getClass().getSimpleName()));
            }
            if (inst instanceof Header) {
                ClassConfigurator.checkSameId((Header)inst, m);
            }
            classMap.put(clazz, m);
        }
        mapping = ClassConfigurator.readMappings(protocol_id_file);
        for (Triple<Short, String, Boolean> tuple : mapping) {
            m = tuple.getVal1();
            external = tuple.getVal3();
            if (external) {
                if (!protocol_names.containsKey(m)) continue;
                ClassConfigurator.alreadyInProtocolsMap(m, tuple.getVal2());
                continue;
            }
            clazz = Util.loadClass(tuple.getVal2(), ClassConfigurator.class);
            if (protocol_ids.containsKey(clazz)) {
                ClassConfigurator.alreadyInProtocolsMap(m, clazz.getName());
            }
            protocol_ids.put(clazz, m);
            protocol_names.put(m, clazz);
        }
    }

    protected static void checkSameId(Header hdr, short magic) {
        short tmp_id = hdr.getMagicId();
        if (tmp_id != magic) {
            throw new IllegalStateException(String.format("mismatch between %s.getId() (%d) and the defined ID (%d)", hdr.getClass().getSimpleName(), magic, tmp_id));
        }
    }

    protected static void alreadyInMagicMap(short magic, String classname) {
        throw new IllegalArgumentException("key " + magic + " (" + classname + ')' + " is already in magic map; make sure that all keys are unique");
    }

    protected static void alreadyInProtocolsMap(short prot_id, String classname) {
        throw new IllegalArgumentException("ID " + prot_id + " (" + classname + ')' + " is already in protocol-ids map; make sure that all protocol IDs are unique");
    }

    protected static List<Triple<Short, String, Boolean>> readMappings(String name) throws Exception {
        InputStream stream = Util.getResourceAsStream(name, ClassConfigurator.class);
        if (stream == null) {
            stream = new FileInputStream(name);
        }
        return ClassConfigurator.parse(stream);
    }

    protected static List<Triple<Short, String, Boolean>> parse(InputStream stream) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(stream);
        NodeList class_list = document.getElementsByTagName("class");
        LinkedList<Triple<Short, String, Boolean>> list = new LinkedList<Triple<Short, String, Boolean>>();
        for (int i = 0; i < class_list.getLength(); ++i) {
            if (class_list.item(i).getNodeType() != 1) continue;
            list.add(ClassConfigurator.parseClassData(class_list.item(i)));
        }
        return list;
    }

    protected static Triple<Short, String, Boolean> parseClassData(Node protocol) {
        protocol.normalize();
        NamedNodeMap attrs = protocol.getAttributes();
        boolean external = false;
        String magicnumber = attrs.getNamedItem("id").getNodeValue();
        String clazzname = attrs.getNamedItem("name").getNodeValue();
        Node tmp = attrs.getNamedItem("external");
        if (tmp != null) {
            external = Boolean.parseBoolean(tmp.getNodeValue());
        }
        return new Triple<Short, String, Boolean>(Short.valueOf(magicnumber), clazzname, external);
    }

    static {
        try {
            ClassConfigurator.init();
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

