/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.infinispan.Version;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.remoting.transport.Address;
import org.infinispan.server.infinispan.SecurityActions;
import org.infinispan.server.infinispan.spi.service.CacheContainerServiceName;
import org.infinispan.stats.CacheContainerStats;
import org.infinispan.xsite.GlobalXSiteAdminOperations;
import org.infinispan.xsite.status.SiteStatus;
import org.jboss.as.clustering.infinispan.DefaultCacheContainer;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;

public class CacheContainerMetricsHandler
extends AbstractRuntimeOnlyHandler {
    public static final CacheContainerMetricsHandler INSTANCE = new CacheContainerMetricsHandler();

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String cacheContainerName = address.getLastElement().getValue();
        String attrName = operation.require("name").asString();
        ServiceController controller = context.getServiceRegistry(false).getService(CacheContainerServiceName.CACHE_CONTAINER.getServiceName(cacheContainerName));
        DefaultCacheContainer cacheManager = (DefaultCacheContainer)controller.getValue();
        CacheManagerMetrics metric = CacheManagerMetrics.getStat(attrName);
        ModelNode result = new ModelNode();
        if (metric == null) {
            context.getFailureDescription().set(String.format("Unknown metric %s", attrName));
        } else if (cacheManager == null) {
            context.getFailureDescription().set(String.format("Unavailable cache container %s", attrName));
        } else {
            CacheContainerStats stats = cacheManager.getStats();
            switch (metric) {
                case CACHE_MANAGER_STATUS: {
                    result.set(SecurityActions.getCacheManagerStatus(cacheManager).toString());
                    break;
                }
                case IS_COORDINATOR: {
                    result.set(SecurityActions.getCacheManagerIsCoordinator(cacheManager));
                    break;
                }
                case LOCAL_ADDRESS: {
                    Address localAddress = SecurityActions.getCacheManagerLocalAddress(cacheManager);
                    result.set(localAddress != null ? localAddress.toString() : "N/A");
                    break;
                }
                case COORDINATOR_ADDRESS: {
                    Address coordinatorAddress = SecurityActions.getCacheManagerCoordinatorAddress(cacheManager);
                    result.set(coordinatorAddress != null ? coordinatorAddress.toString() : "N/A");
                    break;
                }
                case CLUSTER_AVAILABILITY: {
                    result.set(SecurityActions.getCacheManagerClusterAvailability(cacheManager));
                    break;
                }
                case CLUSTER_NAME: {
                    String clusterName = SecurityActions.getCacheManagerClusterName(cacheManager);
                    result.set(clusterName != null ? clusterName : "N/A");
                    break;
                }
                case DEFINED_CACHE_NAMES: {
                    String definedCacheNames = SecurityActions.getDefinedCacheNames(cacheManager);
                    result.set(definedCacheNames != null ? definedCacheNames : "N/A");
                    break;
                }
                case CLUSTER_SIZE: {
                    List<Address> members = SecurityActions.getMembers(cacheManager);
                    result.set(members != null ? Integer.toString(members.size()) : "N/A");
                    break;
                }
                case CREATED_CACHE_COUNT: {
                    result.set(SecurityActions.getCacheCreatedCount(cacheManager));
                    break;
                }
                case DEFINED_CACHE_COUNT: {
                    result.set(SecurityActions.getDefinedCacheCount(cacheManager));
                    break;
                }
                case MEMBERS: {
                    List<Address> members = SecurityActions.getMembers(cacheManager);
                    result.set(members != null ? members.toString() : "N/A");
                    break;
                }
                case RUNNING_CACHE_COUNT: {
                    result.set(SecurityActions.getRunningCacheCount(cacheManager));
                    break;
                }
                case VERSION: {
                    result.set(Version.getVersion());
                    break;
                }
                case AVERAGE_READ_TIME: {
                    result.set(stats.getAverageReadTime());
                    break;
                }
                case AVERAGE_WRITE_TIME: {
                    result.set(stats.getAverageWriteTime());
                    break;
                }
                case AVERAGE_REMOVE_TIME: {
                    result.set(stats.getAverageRemoveTime());
                    break;
                }
                case TIME_SINCE_START: {
                    result.set(stats.getTimeSinceStart());
                    break;
                }
                case EVICTIONS: {
                    result.set(stats.getEvictions());
                    break;
                }
                case HIT_RATIO: {
                    result.set(stats.getHitRatio());
                    break;
                }
                case HITS: {
                    result.set(stats.getHits());
                    break;
                }
                case MISSES: {
                    result.set(stats.getMisses());
                    break;
                }
                case NUMBER_OF_ENTRIES: {
                    result.set(stats.getCurrentNumberOfEntries());
                    break;
                }
                case OFF_HEAP_MEMORY_USED: {
                    result.set(stats.getOffHeapMemoryUsed());
                    break;
                }
                case READ_WRITE_RATIO: {
                    result.set(stats.getReadWriteRatio());
                    break;
                }
                case REMOVE_HITS: {
                    result.set(stats.getHits());
                    break;
                }
                case REMOVE_MISSES: {
                    result.set(stats.getRemoveMisses());
                    break;
                }
                case STORES: {
                    result.set(stats.getStores());
                    break;
                }
                case TIME_SINCE_RESET: {
                    result.set(stats.getTimeSinceStart());
                    break;
                }
                case ONLINE_SITES: 
                case OFFLINE_SITES: 
                case MIXED_SITES: {
                    GlobalComponentRegistry registry = SecurityActions.getGlobalComponentRegistry(cacheManager);
                    Collection<String> sites = CacheContainerMetricsHandler.filterSitesByStatus(registry, metric);
                    if (sites.isEmpty()) {
                        result.setEmptyList();
                        break;
                    }
                    result.set(CacheContainerMetricsHandler.toModelNodeCollection(sites));
                    break;
                }
                default: {
                    context.getFailureDescription().set(String.format("Unknown metric %s", new Object[]{metric}));
                }
            }
            context.getResult().set(result);
        }
        context.stepCompleted();
    }

    public void registerMetrics(ManagementResourceRegistration container) {
        for (CacheManagerMetrics metric : CacheManagerMetrics.values()) {
            container.registerMetric(metric.definition, (OperationStepHandler)this);
        }
    }

    private static Collection<String> filterSitesByStatus(GlobalComponentRegistry registry, CacheManagerMetrics metric) {
        GlobalXSiteAdminOperations operations = (GlobalXSiteAdminOperations)registry.getComponent(GlobalXSiteAdminOperations.class);
        if (operations == null) {
            return Collections.emptyList();
        }
        Map siteStatusMap = operations.globalStatus();
        if (siteStatusMap.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<String> filterSites = new LinkedList<String>();
        block5: for (Map.Entry statusEntry : siteStatusMap.entrySet()) {
            String siteName = (String)statusEntry.getKey();
            SiteStatus status = (SiteStatus)statusEntry.getValue();
            switch (metric) {
                case ONLINE_SITES: {
                    if (!status.isOnline()) continue block5;
                    filterSites.add(siteName);
                    continue block5;
                }
                case OFFLINE_SITES: {
                    if (!status.isOffline()) continue block5;
                    filterSites.add(siteName);
                    continue block5;
                }
                case MIXED_SITES: {
                    if (status.isOnline() || status.isOffline()) continue block5;
                    filterSites.add(siteName);
                    continue block5;
                }
            }
            return Collections.emptyList();
        }
        return filterSites;
    }

    private static Collection<ModelNode> toModelNodeCollection(Collection<String> collection) {
        if (collection == null || collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ModelNode> modelNodeCollection = new ArrayList<ModelNode>(collection.size());
        collection.forEach(e -> modelNodeCollection.add(new ModelNode().set(e)));
        return modelNodeCollection;
    }

    public static enum CacheManagerMetrics {
        CACHE_MANAGER_STATUS("cache-manager-status", ModelType.STRING, true),
        CLUSTER_NAME("cluster-name", ModelType.STRING, true, true),
        CLUSTER_AVAILABILITY("cluster-availability", ModelType.STRING, true, true),
        IS_COORDINATOR("is-coordinator", ModelType.BOOLEAN, true, true),
        COORDINATOR_ADDRESS("coordinator-address", ModelType.STRING, true, true),
        LOCAL_ADDRESS("local-address", ModelType.STRING, true, true),
        DEFINED_CACHE_NAMES("defined-cache-names", ModelType.INT, true, true),
        DEFINED_CACHE_COUNT("defined-cache-count", ModelType.INT, true, true),
        RUNNING_CACHE_COUNT("running-cache-count", ModelType.INT, true, true),
        CREATED_CACHE_COUNT("created-cache-count", ModelType.INT, true, true),
        MEMBERS("members", ModelType.INT, true, true),
        CLUSTER_SIZE("cluster-size", ModelType.INT, true, true),
        VERSION("version", ModelType.INT, true, true),
        ONLINE_SITES("sites-online", ModelType.LIST, ModelType.STRING, false),
        OFFLINE_SITES("sites-offline", ModelType.LIST, ModelType.STRING, false),
        MIXED_SITES("sites-mixed", ModelType.LIST, ModelType.STRING, false),
        AVERAGE_READ_TIME("average-read-time", ModelType.LONG, true),
        AVERAGE_WRITE_TIME("average-write-time", ModelType.LONG, true),
        AVERAGE_REMOVE_TIME("average-remove-time", ModelType.LONG, true),
        TIME_SINCE_START("time-since-start", ModelType.LONG, true),
        EVICTIONS("evictions", ModelType.LONG, true),
        HIT_RATIO("hit-ratio", ModelType.DOUBLE, true),
        HITS("hits", ModelType.LONG, true),
        MISSES("misses", ModelType.LONG, true),
        NUMBER_OF_ENTRIES("number-of-entries", ModelType.INT, true),
        OFF_HEAP_MEMORY_USED("off-heap-memory-used", ModelType.LONG, true),
        READ_WRITE_RATIO("read-write-ratio", ModelType.DOUBLE, true),
        REMOVE_HITS("remove-hits", ModelType.LONG, true),
        REMOVE_MISSES("remove-misses", ModelType.LONG, true),
        STORES("stores", ModelType.LONG, true),
        TIME_SINCE_RESET("time-since-reset", ModelType.LONG, true);

        private static final Map<String, CacheManagerMetrics> MAP;
        final AttributeDefinition definition;
        final boolean clustered;

        private CacheManagerMetrics(AttributeDefinition definition, boolean clustered) {
            this.definition = definition;
            this.clustered = clustered;
        }

        private CacheManagerMetrics(String attributeName, ModelType type, boolean allowNull) {
            this(attributeName, type, allowNull, false);
        }

        private CacheManagerMetrics(String attributeName, ModelType type, boolean allowNull, boolean clustered) {
            this((AttributeDefinition)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(attributeName, type, allowNull).setStorageRuntime()).build(), clustered);
        }

        private CacheManagerMetrics(String attributeName, ModelType outerType, ModelType innerType, boolean allowNull) {
            if (outerType != ModelType.LIST) {
                throw new IllegalArgumentException();
            }
            if (innerType != ModelType.STRING) {
                throw new IllegalArgumentException();
            }
            this.definition = ((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder(attributeName).setAllowNull(allowNull)).build();
            this.clustered = false;
        }

        public final String toString() {
            return this.definition.getName();
        }

        public static CacheManagerMetrics getStat(String stringForm) {
            return MAP.get(stringForm);
        }

        static {
            MAP = new HashMap<String, CacheManagerMetrics>();
            for (CacheManagerMetrics metric : CacheManagerMetrics.values()) {
                MAP.put(metric.toString(), metric);
            }
        }
    }
}

