/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.analyzer.impl;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.analyzer.spi.AnalyzerReference;
import org.hibernate.search.analyzer.spi.ScopedAnalyzer;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.elasticsearch.analyzer.impl.ElasticsearchAnalyzer;
import org.hibernate.search.elasticsearch.analyzer.impl.ElasticsearchAnalyzerReference;
import org.hibernate.search.elasticsearch.analyzer.impl.ScopedElasticsearchAnalyzerReference;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ScopedElasticsearchAnalyzer
implements ElasticsearchAnalyzer,
ScopedAnalyzer {
    private static final Log log = LoggerFactory.make();
    private final ElasticsearchAnalyzerReference globalAnalyzerReference;
    private final Map<String, ElasticsearchAnalyzerReference> scopedAnalyzers = new HashMap<String, ElasticsearchAnalyzerReference>();

    public ScopedElasticsearchAnalyzer(ElasticsearchAnalyzerReference globalAnalyzerReference) {
        this.globalAnalyzerReference = globalAnalyzerReference;
    }

    public ScopedElasticsearchAnalyzer(Builder builder) {
        this.globalAnalyzerReference = builder.globalAnalyzerReference;
        this.scopedAnalyzers.putAll(builder.scopedAnalyzers);
    }

    private ElasticsearchAnalyzerReference getDelegate(String fieldName) {
        ElasticsearchAnalyzerReference analyzerReference = this.scopedAnalyzers.get(fieldName);
        if (analyzerReference == null) {
            analyzerReference = this.globalAnalyzerReference;
        }
        return analyzerReference;
    }

    public String getName(String fieldName) {
        return this.getDelegate(fieldName).getAnalyzer().getName(fieldName);
    }

    @Override
    public AnalyzerDef getDefinition(String fieldName) {
        return this.getDelegate(fieldName).getAnalyzer().getDefinition(fieldName);
    }

    @Override
    public Class<?> getLuceneClass(String fieldName) {
        return this.getDelegate(fieldName).getAnalyzer().getLuceneClass(fieldName);
    }

    public void close() {
    }

    public Builder startCopy() {
        return new Builder(this.globalAnalyzerReference, this.scopedAnalyzers);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("<");
        sb.append((Object)this.globalAnalyzerReference);
        sb.append(",");
        sb.append(this.scopedAnalyzers);
        sb.append(">");
        return sb.toString();
    }

    private static ElasticsearchAnalyzerReference getElasticsearchAnalyzerReference(AnalyzerReference analyzerReference) {
        if (!analyzerReference.is(ElasticsearchAnalyzerReference.class)) {
            throw log.analyzerReferenceIsNotRemote(analyzerReference);
        }
        return (ElasticsearchAnalyzerReference)analyzerReference.unwrap(ElasticsearchAnalyzerReference.class);
    }

    public static class Builder
    implements ScopedAnalyzer.Builder {
        private ElasticsearchAnalyzerReference globalAnalyzerReference;
        private final Map<String, ElasticsearchAnalyzerReference> scopedAnalyzers = new HashMap<String, ElasticsearchAnalyzerReference>();

        public Builder(ElasticsearchAnalyzerReference globalAnalyzerReference, Map<String, ElasticsearchAnalyzerReference> scopedAnalyzers) {
            this.globalAnalyzerReference = globalAnalyzerReference;
            this.scopedAnalyzers.putAll(scopedAnalyzers);
        }

        public ElasticsearchAnalyzerReference getGlobalAnalyzerReference() {
            return this.globalAnalyzerReference;
        }

        public void setGlobalAnalyzerReference(AnalyzerReference globalAnalyzerReference) {
            this.globalAnalyzerReference = ScopedElasticsearchAnalyzer.getElasticsearchAnalyzerReference(globalAnalyzerReference);
        }

        public void addAnalyzerReference(String scope, AnalyzerReference analyzerReference) {
            this.scopedAnalyzers.put(scope, ScopedElasticsearchAnalyzer.getElasticsearchAnalyzerReference(analyzerReference));
        }

        public ScopedElasticsearchAnalyzerReference build() {
            ScopedElasticsearchAnalyzer analyzer = new ScopedElasticsearchAnalyzer(this);
            return new ScopedElasticsearchAnalyzerReference(analyzer);
        }
    }
}

