/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.MemoryConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.container.StorageType;
import org.infinispan.eviction.EvictionType;

public class MemoryConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<MemoryConfiguration> {
    private AttributeSet attributes = MemoryConfiguration.attributeDefinitionSet();

    MemoryConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public MemoryConfigurationBuilder storageType(StorageType storageType) {
        this.attributes.attribute(MemoryConfiguration.STORAGE_TYPE).set((Object)storageType);
        return this;
    }

    public MemoryConfigurationBuilder size(long size) {
        this.attributes.attribute(MemoryConfiguration.SIZE).set((Object)size);
        return this;
    }

    public MemoryConfigurationBuilder evictionType(EvictionType type) {
        this.attributes.attribute(MemoryConfiguration.EVICTION_TYPE).set((Object)type);
        return this;
    }

    public MemoryConfigurationBuilder addressCount(int addressCount) {
        this.attributes.attribute(MemoryConfiguration.ADDRESS_COUNT).set((Object)addressCount);
        return this;
    }

    public void validate() {
        EvictionType evictionType;
        StorageType type = (StorageType)((Object)this.attributes.attribute(MemoryConfiguration.STORAGE_TYPE).get());
        if (type != StorageType.OBJECT && this.getBuilder().compatibility().isEnabled()) {
            throw new CacheConfigurationException("Compatibility mode requires OBJECT storage type but was: " + (Object)((Object)type));
        }
        long size = (Long)this.attributes.attribute(MemoryConfiguration.SIZE).get();
        if (size > 0L && (evictionType = (EvictionType)((Object)this.attributes.attribute(MemoryConfiguration.EVICTION_TYPE).get())) == EvictionType.MEMORY && type != StorageType.BINARY) {
            throw new CacheConfigurationException("MEMORY based eviction requires binary but was : " + (Object)((Object)type));
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    public MemoryConfiguration create() {
        return new MemoryConfiguration(this.attributes.protect());
    }

    public MemoryConfigurationBuilder read(MemoryConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public String toString() {
        return "DataContainerConfigurationBuilder [attributes=" + this.attributes + "]";
    }
}

