/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.BasicInvocationStage;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.interceptors.impl.BaseRpcInterceptor;
import org.infinispan.jmx.JmxStatisticsExposer;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.MeasurementType;
import org.infinispan.jmx.annotations.Parameter;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.concurrent.locks.RemoteLockCommand;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="Invalidation", description="Component responsible for invalidating entries on remote caches when entries are written to locally.")
public class InvalidationInterceptor
extends BaseRpcInterceptor
implements JmxStatisticsExposer {
    private final AtomicLong invalidations = new AtomicLong(0L);
    private CommandsFactory commandsFactory;
    private boolean statisticsEnabled;
    private static final Log log = LogFactory.getLog(InvalidationInterceptor.class);

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void injectDependencies(CommandsFactory commandsFactory) {
        this.commandsFactory = commandsFactory;
    }

    @Start
    private void start() {
        this.setStatisticsEnabled(this.cacheConfiguration.jmxStatistics().enabled());
    }

    @Override
    public BasicInvocationStage visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        if (!this.isPutForExternalRead(command)) {
            return this.handleInvalidate(ctx, command, command.getKey());
        }
        return this.invokeNext(ctx, command);
    }

    @Override
    public BasicInvocationStage visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleInvalidate(ctx, command, command.getKey());
    }

    @Override
    public BasicInvocationStage visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleInvalidate(ctx, command, command.getKey());
    }

    @Override
    public BasicInvocationStage visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return this.invokeNext(ctx, command).thenCompose((stage, rCtx, rCommand, rv) -> {
            ClearCommand clearCommand = (ClearCommand)rCommand;
            if (!this.isLocalModeForced(clearCommand) && rCtx.isOriginLocal()) {
                CompletableFuture<Map<Address, Response>> remoteInvocation = this.rpcManager.invokeRemotelyAsync(null, clearCommand, this.getBroadcastRpcOptions(this.defaultSynchronous));
                return this.returnWithAsync((CompletableFuture<?>)remoteInvocation.thenApply(responses -> null));
            }
            return stage;
        });
    }

    @Override
    public BasicInvocationStage visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        Object[] keys = command.getMap() == null ? null : command.getMap().keySet().toArray();
        return this.handleInvalidate(ctx, command, keys);
    }

    @Override
    public BasicInvocationStage visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (!command.isOnePhaseCommit()) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNext(ctx, command).thenCompose((stage, rCtx, rCommand, rv) -> {
            log.tracef("Entering InvalidationInterceptor's prepare phase.  Ctx flags are empty", new Object[0]);
            TxInvocationContext txInvocationContext = (TxInvocationContext)rCtx;
            if (!this.shouldInvokeRemoteTxCommand(txInvocationContext)) {
                log.tracef("Nothing to invalidate - no modifications in the transaction.", new Object[0]);
                return stage;
            }
            if (txInvocationContext.getTransaction() == null) {
                throw new IllegalStateException("We must have an associated transaction");
            }
            PrepareCommand prepareCommand = (PrepareCommand)rCommand;
            List<WriteCommand> mods = Arrays.asList(prepareCommand.getModifications());
            Collection<Object> remoteKeys = this.keysToInvalidateForPrepare(mods, txInvocationContext);
            if (remoteKeys == null) {
                return stage;
            }
            CompletableFuture<Map<Address, Response>> remoteInvocation = this.invalidateAcrossCluster(this.defaultSynchronous, remoteKeys.toArray(), txInvocationContext);
            return this.returnWithAsync((CompletableFuture<?>)remoteInvocation.handle((responses, t) -> {
                if (t == null) {
                    return null;
                }
                log.unableToRollbackEvictionsDuringPrepare((Throwable)t);
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException("Unable to broadcast invalidation messages", (Throwable)t);
            }));
        });
    }

    @Override
    public BasicInvocationStage visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        return this.invokeNext(ctx, command).thenCompose((stage, rCtx, rCommand, rv) -> {
            Set<Object> affectedKeys = ctx.getAffectedKeys();
            log.tracef("On commit, send invalidate for keys: %s", affectedKeys);
            CompletableFuture<Map<Address, Response>> remoteInvocation = null;
            try {
                remoteInvocation = this.invalidateAcrossCluster(this.defaultSynchronous, affectedKeys.toArray(), rCtx);
                return this.returnWithAsync((CompletableFuture<?>)remoteInvocation.handle((responses, t) -> {
                    if (t != null) {
                        throw this.wrapException((Throwable)t);
                    }
                    return null;
                }));
            }
            catch (Throwable t2) {
                throw this.wrapException(t2);
            }
        });
    }

    private RuntimeException wrapException(Throwable t) {
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        return log.unableToBroadcastInvalidation(t);
    }

    @Override
    public BasicInvocationStage visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        if (!ctx.isOriginLocal()) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNext(ctx, command).thenCompose((stage, rCtx, rCommand, rv) -> {
            LockControlCommand lockControlCommand = (LockControlCommand)rCommand;
            boolean sync = !lockControlCommand.isUnlock();
            ((LocalTxInvocationContext)rCtx).remoteLocksAcquired(this.rpcManager.getTransport().getMembers());
            CompletableFuture<Map<Address, Response>> remoteInvocation = this.rpcManager.invokeRemotelyAsync(null, lockControlCommand, this.getBroadcastRpcOptions(sync));
            return this.returnWithAsync((CompletableFuture<?>)remoteInvocation.thenApply(responses -> null));
        });
    }

    private InvocationStage handleInvalidate(InvocationContext ctx, WriteCommand command, Object ... keys) throws Throwable {
        if (ctx.isInTxScope()) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNext(ctx, command).thenCompose((stage, rCtx, rCommand, rv) -> {
            WriteCommand writeCommand = (WriteCommand)rCommand;
            if (writeCommand.isSuccessful() && keys != null && keys.length != 0 && !this.isLocalModeForced(writeCommand)) {
                CompletableFuture<Map<Address, Response>> remoteInvocation = this.invalidateAcrossCluster(this.isSynchronous(writeCommand), keys, rCtx);
                return this.returnWithAsync((CompletableFuture<?>)remoteInvocation.thenApply(responses -> rv));
            }
            return stage;
        });
    }

    private Collection<Object> keysToInvalidateForPrepare(List<WriteCommand> modifications, InvocationContext ctx) throws Throwable {
        if (!ctx.isInTxScope()) {
            return null;
        }
        if (modifications.isEmpty()) {
            return null;
        }
        InvalidationFilterVisitor filterVisitor = new InvalidationFilterVisitor(modifications.size());
        filterVisitor.visitCollection(ctx, modifications);
        if (filterVisitor.containsPutForExternalRead) {
            log.debug("Modification list contains a putForExternalRead operation.  Not invalidating.");
        } else if (filterVisitor.containsLocalModeFlag) {
            log.debug("Modification list contains a local mode flagged operation.  Not invalidating.");
        } else {
            return filterVisitor.result;
        }
        return null;
    }

    private CompletableFuture<Map<Address, Response>> invalidateAcrossCluster(boolean synchronous, Object[] keys, InvocationContext ctx) throws Throwable {
        this.incrementInvalidations();
        InvalidateCommand invalidateCommand = this.commandsFactory.buildInvalidateCommand(0L, keys);
        if (log.isDebugEnabled()) {
            log.debug("Cache [" + this.rpcManager.getAddress() + "] replicating " + invalidateCommand);
        }
        RemoteLockCommand command = invalidateCommand;
        if (ctx.isInTxScope()) {
            TxInvocationContext txCtx = (TxInvocationContext)ctx;
            command = this.commandsFactory.buildPrepareCommand(txCtx.getGlobalTransaction(), Collections.singletonList(invalidateCommand), true);
        }
        return this.rpcManager.invokeRemotelyAsync(null, command, this.getBroadcastRpcOptions(synchronous));
    }

    private RpcOptions getBroadcastRpcOptions(boolean synchronous) {
        return this.rpcManager.getRpcOptionsBuilder(synchronous ? ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS : ResponseMode.ASYNCHRONOUS).build();
    }

    private void incrementInvalidations() {
        if (this.statisticsEnabled) {
            this.invalidations.incrementAndGet();
        }
    }

    private boolean isPutForExternalRead(FlagAffectedCommand command) {
        if (command.hasAnyFlag(FlagBitSets.PUT_FOR_EXTERNAL_READ)) {
            log.trace("Put for external read called.  Suppressing clustered invalidation.");
            return true;
        }
        return false;
    }

    @Override
    @ManagedOperation(description="Resets statistics gathered by this component", displayName="Reset statistics")
    public void resetStatistics() {
        this.invalidations.set(0L);
    }

    @Override
    @ManagedAttribute(displayName="Statistics enabled", description="Enables or disables the gathering of statistics by this component", dataType=DataType.TRAIT, writable=true)
    public boolean getStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @Override
    public void setStatisticsEnabled(@Parameter(name="enabled", description="Whether statistics should be enabled or disabled (true/false)") boolean enabled) {
        this.statisticsEnabled = enabled;
    }

    @ManagedAttribute(description="Number of invalidations", displayName="Number of invalidations", measurementType=MeasurementType.TRENDSUP)
    public long getInvalidations() {
        return this.invalidations.get();
    }

    private static class InvalidationFilterVisitor
    extends AbstractVisitor {
        Set<Object> result;
        boolean containsPutForExternalRead = false;
        boolean containsLocalModeFlag = false;

        InvalidationFilterVisitor(int maxSetSize) {
            this.result = new HashSet<Object>(maxSetSize);
        }

        private void processCommand(FlagAffectedCommand command) {
            this.containsLocalModeFlag = this.containsLocalModeFlag || command.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL);
        }

        @Override
        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            this.processCommand(command);
            this.containsPutForExternalRead = this.containsPutForExternalRead || command.hasAnyFlag(FlagBitSets.PUT_FOR_EXTERNAL_READ);
            this.result.add(command.getKey());
            return null;
        }

        @Override
        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            this.processCommand(command);
            this.result.add(command.getKey());
            return null;
        }

        @Override
        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
            this.processCommand(command);
            this.result.addAll(command.getAffectedKeys());
            return null;
        }
    }
}

