/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.inboundhandler.action;

import org.infinispan.distribution.TriangleOrderManager;
import org.infinispan.remoting.inboundhandler.action.Action;
import org.infinispan.remoting.inboundhandler.action.ActionState;
import org.infinispan.remoting.inboundhandler.action.ActionStatus;
import org.infinispan.util.concurrent.BlockingTaskAwareExecutorService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TriangleOrderAction
implements Action {
    private static final Log log = LogFactory.getLog(TriangleOrderAction.class);
    private static final boolean trace = log.isTraceEnabled();
    private final TriangleOrderManager triangleOrderManager;
    private final BlockingTaskAwareExecutorService remoteExecutorService;
    private final int segmentId;
    private final long sequenceNumber;

    public TriangleOrderAction(TriangleOrderManager triangleOrderManager, BlockingTaskAwareExecutorService remoteExecutorService, int segmentId, long sequenceNumber) {
        this.triangleOrderManager = triangleOrderManager;
        this.remoteExecutorService = remoteExecutorService;
        this.segmentId = segmentId;
        this.sequenceNumber = sequenceNumber;
    }

    @Override
    public ActionStatus check(ActionState state) {
        if (trace) {
            log.tracef("Checking if next for segment %s and sequence %s", this.segmentId, this.sequenceNumber);
        }
        return this.triangleOrderManager.isNext(this.segmentId, this.sequenceNumber, state.getCommandTopologyId()) ? ActionStatus.READY : ActionStatus.NOT_READY;
    }

    @Override
    public void onFinally(ActionState state) {
        this.triangleOrderManager.markDelivered(this.segmentId, this.sequenceNumber, state.getCommandTopologyId());
        this.remoteExecutorService.checkForReadyTasks();
    }
}

