/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.filter;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.filter.AbstractKeyValueFilterConverter;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.Metadata;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.remote.impl.ExternalizerIds;
import org.infinispan.query.remote.impl.ProtobufMetadataManagerImpl;
import org.infinispan.query.remote.impl.filter.JPAProtobufFilterAndConverter;

public final class JPABinaryProtobufFilterAndConverter<K, V>
extends AbstractKeyValueFilterConverter<K, V, Object> {
    private SerializationContext serCtx;
    private final JPAProtobufFilterAndConverter delegate;

    @Inject
    protected void injectDependencies(ComponentRegistry componentRegistry, EmbeddedCacheManager cacheManager) {
        componentRegistry.wireDependencies((Object)this.delegate);
        this.serCtx = ProtobufMetadataManagerImpl.getSerializationContextInternal(cacheManager);
    }

    public JPABinaryProtobufFilterAndConverter(String queryString, Map<String, Object> namedParameters) {
        this.delegate = new JPAProtobufFilterAndConverter(queryString, namedParameters);
    }

    private JPABinaryProtobufFilterAndConverter(JPAProtobufFilterAndConverter delegate) {
        this.delegate = delegate;
    }

    public Object filterAndConvert(K key, V value, Metadata metadata) {
        Optional<ObjectFilter.FilterResult> filterResult = Optional.ofNullable(this.delegate.filterAndConvert(key, value, metadata));
        return filterResult.map(fr -> {
            Object instance = fr.getInstance();
            if (instance != null) {
                return instance;
            }
            return Arrays.stream(fr.getProjection()).map(this::toByteArray).toArray();
        }).orElse(null);
    }

    private Object toByteArray(Object ref) {
        try {
            return ProtobufUtil.toWrappedByteArray((SerializationContext)this.serCtx, (Object)ref);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static final class Externalizer
    extends AbstractExternalizer<JPABinaryProtobufFilterAndConverter> {
        public void writeObject(ObjectOutput output, JPABinaryProtobufFilterAndConverter object) throws IOException {
            output.writeObject((Object)object.delegate);
        }

        public JPABinaryProtobufFilterAndConverter readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            JPAProtobufFilterAndConverter delegate = (JPAProtobufFilterAndConverter)((Object)input.readObject());
            return new JPABinaryProtobufFilterAndConverter(delegate);
        }

        public Integer getId() {
            return ExternalizerIds.JPA_BINARY_PROTOBUF_FILTER_AND_CONVERTER;
        }

        public Set<Class<? extends JPABinaryProtobufFilterAndConverter>> getTypeClasses() {
            return Collections.singleton(JPABinaryProtobufFilterAndConverter.class);
        }
    }
}

