/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.indexing;

import java.util.HashMap;
import org.apache.lucene.document.Field;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.engine.impl.LuceneOptionsImpl;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.protostream.AnnotationMetadataCreator;
import org.infinispan.protostream.descriptors.AnnotationElement;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.query.remote.impl.indexing.FieldMapping;
import org.infinispan.query.remote.impl.indexing.IndexingMetadata;
import org.infinispan.query.remote.impl.logging.Log;
import org.jboss.logging.Logger;

final class IndexingMetadataCreator
implements AnnotationMetadataCreator<IndexingMetadata, Descriptor> {
    private static final Log log = (Log)LogFactory.getLog(IndexingMetadataCreator.class, Log.class);

    IndexingMetadataCreator() {
    }

    public IndexingMetadata create(Descriptor descriptor, AnnotationElement.Annotation annotation) {
        AnnotationElement.Value indexedValue = annotation.getDefaultAttributeValue();
        if (Boolean.TRUE.equals(indexedValue.getValue())) {
            String v;
            String indexName = null;
            String v1 = (String)annotation.getAttributeValue("index").getValue();
            if (!v1.isEmpty()) {
                indexName = v1;
            }
            String entityAnalyzer = null;
            AnnotationElement.Annotation entityAnalyzerAnnotation = (AnnotationElement.Annotation)descriptor.getAnnotations().get("Analyzer");
            if (entityAnalyzerAnnotation != null && !(v = (String)entityAnalyzerAnnotation.getAttributeValue("definition").getValue()).isEmpty()) {
                entityAnalyzer = v;
            }
            HashMap<String, FieldMapping> fields = new HashMap<String, FieldMapping>(descriptor.getFields().size());
            for (FieldDescriptor fd : descriptor.getFields()) {
                AnnotationElement.Annotation indexedFieldAnnotation;
                AnnotationElement.Annotation fieldAnnotation;
                String v2;
                String fieldLevelAnalyzer = null;
                AnnotationElement.Annotation fieldAnalyzerAnnotation = (AnnotationElement.Annotation)descriptor.getAnnotations().get("Analyzer");
                if (fieldAnalyzerAnnotation != null && !(v2 = (String)fieldAnalyzerAnnotation.getAttributeValue("definition").getValue()).isEmpty()) {
                    fieldLevelAnalyzer = v2;
                }
                if ((fieldAnnotation = (AnnotationElement.Annotation)fd.getAnnotations().get("Field")) != null) {
                    String fieldName = fd.getName();
                    String v3 = (String)fieldAnnotation.getAttributeValue("name").getValue();
                    if (!v3.isEmpty()) {
                        fieldName = v3;
                    }
                    AnnotationElement.Value indexAttribute = fieldAnnotation.getAttributeValue("index");
                    boolean isIndexed = "Index.YES".equals(indexAttribute.getValue());
                    AnnotationElement.Value boostAttribute = fieldAnnotation.getAttributeValue("boost");
                    float fieldLevelBoost = ((Float)boostAttribute.getValue()).floatValue();
                    AnnotationElement.Value analyzeAttribute = fieldAnnotation.getAttributeValue("analyze");
                    boolean isAnalyzed = "Analyze.YES".equals(analyzeAttribute.getValue());
                    AnnotationElement.Value storeAttribute = fieldAnnotation.getAttributeValue("store");
                    boolean isStored = "Store.YES".equals(storeAttribute.getValue());
                    AnnotationElement.Value indexNullAsAttribute = fieldAnnotation.getAttributeValue("indexNullAs");
                    String indexNullAs = (String)indexNullAsAttribute.getValue();
                    AnnotationElement.Annotation fieldLevelAnalyzerAnnotation2 = (AnnotationElement.Annotation)fieldAnnotation.getAttributeValue("analyzer").getValue();
                    String fieldLevelAnalyzer2 = (String)fieldLevelAnalyzerAnnotation2.getAttributeValue("definition").getValue();
                    if (!fieldLevelAnalyzer2.isEmpty()) {
                        fieldLevelAnalyzer = fieldLevelAnalyzer2;
                    }
                    LuceneOptionsImpl luceneOptions = new LuceneOptionsImpl(Field.Index.toIndex((boolean)isIndexed, (boolean)isAnalyzed), Field.TermVector.NO, isStored ? Store.YES : Store.NO, indexNullAs, fieldLevelBoost, 1.0f);
                    fields.put(fieldName, new FieldMapping(fieldName, isIndexed, fieldLevelBoost, isAnalyzed, isStored, fieldLevelAnalyzer, indexNullAs, (LuceneOptions)luceneOptions));
                }
                if ((indexedFieldAnnotation = (AnnotationElement.Annotation)fd.getAnnotations().get("IndexedField")) == null) continue;
                if (fieldAnnotation != null) {
                    throw new IllegalStateException("Annotation 'IndexedField' cannot be used together with 'Field' on field " + fd.getFullName());
                }
                if (log.isEnabled(Logger.Level.WARN)) {
                    log.warnf("Detected usage of deprecated annotation '%s' on field %s", "IndexedField", fd.getFullName());
                }
                AnnotationElement.Value indexAttribute = indexedFieldAnnotation.getAttributeValue("index");
                boolean isIndexed = Boolean.TRUE.equals(indexAttribute.getValue());
                AnnotationElement.Value storeAttribute = indexedFieldAnnotation.getAttributeValue("store");
                boolean isStored = Boolean.TRUE.equals(storeAttribute.getValue());
                String indexNullAs = "_null_";
                LuceneOptionsImpl luceneOptions = new LuceneOptionsImpl(isIndexed ? Field.Index.NOT_ANALYZED : Field.Index.NO, Field.TermVector.NO, isStored ? Store.YES : Store.NO, indexNullAs, 1.0f, 1.0f);
                fields.put(fd.getName(), new FieldMapping(fd.getName(), isIndexed, 1.0f, false, isStored, null, indexNullAs, (LuceneOptions)luceneOptions));
            }
            return new IndexingMetadata(true, indexName, entityAnalyzer, fields);
        }
        return IndexingMetadata.NO_INDEXING;
    }
}

