/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.settings.impl;

import com.google.gson.JsonElement;
import java.util.Map;
import java.util.TreeMap;
import org.hibernate.search.analyzer.spi.AnalyzerReference;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.CharFilterDef;
import org.hibernate.search.annotations.TokenFilterDef;
import org.hibernate.search.annotations.TokenizerDef;
import org.hibernate.search.elasticsearch.analyzer.impl.ElasticsearchAnalyzer;
import org.hibernate.search.elasticsearch.analyzer.impl.ElasticsearchAnalyzerReference;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.settings.impl.ElasticsearchAnalyzerDefinitionTranslator;
import org.hibernate.search.elasticsearch.settings.impl.model.AnalysisDefinition;
import org.hibernate.search.elasticsearch.settings.impl.model.AnalyzerDefinition;
import org.hibernate.search.elasticsearch.settings.impl.model.CharFilterDefinition;
import org.hibernate.search.elasticsearch.settings.impl.model.IndexSettings;
import org.hibernate.search.elasticsearch.settings.impl.model.TokenFilterDefinition;
import org.hibernate.search.elasticsearch.settings.impl.model.TokenizerDefinition;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ElasticsearchIndexSettingsBuilder {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private final ElasticsearchAnalyzerDefinitionTranslator analyzerDefinitionTranslator;
    private final Map<String, AnalyzerDefinition> analyzers = new TreeMap<String, AnalyzerDefinition>();
    private final Map<String, TokenizerDefinition> tokenizers = new TreeMap<String, TokenizerDefinition>();
    private final Map<String, TokenFilterDefinition> tokenFilters = new TreeMap<String, TokenFilterDefinition>();
    private final Map<String, CharFilterDefinition> charFilters = new TreeMap<String, CharFilterDefinition>();
    private EntityIndexBinding binding;

    public ElasticsearchIndexSettingsBuilder(ElasticsearchAnalyzerDefinitionTranslator analyzerDefinitionTranslator) {
        this.analyzerDefinitionTranslator = analyzerDefinitionTranslator;
    }

    public Class<?> getBeanClass() {
        return this.binding.getDocumentBuilder().getBeanClass();
    }

    public void setBinding(EntityIndexBinding binding) {
        this.binding = binding;
    }

    public IndexSettings build() {
        IndexSettings settings = new IndexSettings();
        if (!this.analyzers.isEmpty()) {
            this.getAnalysis(settings).setAnalyzers(this.analyzers);
        }
        if (!this.tokenizers.isEmpty()) {
            this.getAnalysis(settings).setTokenizers(this.tokenizers);
        }
        if (!this.tokenFilters.isEmpty()) {
            this.getAnalysis(settings).setTokenFilters(this.tokenFilters);
        }
        if (!this.charFilters.isEmpty()) {
            this.getAnalysis(settings).setCharFilters(this.charFilters);
        }
        return settings;
    }

    private IndexSettings.Analysis getAnalysis(IndexSettings settings) {
        IndexSettings.Analysis analysis = settings.getAnalysis();
        if (analysis == null) {
            analysis = new IndexSettings.Analysis();
            settings.setAnalysis(analysis);
        }
        return analysis;
    }

    public String registerAnalyzer(AnalyzerReference analyzerReference, String fieldName) {
        if (!analyzerReference.is(ElasticsearchAnalyzerReference.class)) {
            LOG.analyzerIsNotElasticsearch(this.getBeanClass(), fieldName, analyzerReference);
            return null;
        }
        ElasticsearchAnalyzerReference elasticsearchReference = (ElasticsearchAnalyzerReference)analyzerReference.unwrap(ElasticsearchAnalyzerReference.class);
        ElasticsearchAnalyzer analyzer = elasticsearchReference.getAnalyzer();
        AnalyzerDef hibernateSearchDefinition = analyzer.getDefinition(fieldName);
        if (hibernateSearchDefinition != null) {
            return this.addAnalyzerDef(hibernateSearchDefinition);
        }
        String name = analyzer.getName(fieldName);
        if (name != null) {
            return analyzer.getName(fieldName);
        }
        Class<?> luceneClass = analyzer.getLuceneClass(fieldName);
        return this.analyzerDefinitionTranslator.translate(luceneClass);
    }

    private String addAnalyzerDef(AnalyzerDef hibernateSearchDefinition) {
        AnalyzerDefinition analyzerDefinition = new AnalyzerDefinition();
        String localName = hibernateSearchDefinition.name();
        String remoteName = localName;
        if (this.analyzers.containsKey(remoteName)) {
            return remoteName;
        }
        TokenizerDef hibernateSearchTokenizerDef = hibernateSearchDefinition.tokenizer();
        String tokenizerName = this.addTokenizerDef(localName, hibernateSearchTokenizerDef);
        analyzerDefinition.setTokenizer(tokenizerName);
        for (CharFilterDef charFilterDef : hibernateSearchDefinition.charFilters()) {
            String charFilterName = this.addCharFilterDef(localName, charFilterDef);
            analyzerDefinition.addCharFilter(charFilterName);
        }
        for (CharFilterDef charFilterDef : hibernateSearchDefinition.filters()) {
            String tokenFilterName = this.addTokenFilterDef(localName, (TokenFilterDef)charFilterDef);
            analyzerDefinition.addTokenFilter(tokenFilterName);
        }
        this.analyzers.put(remoteName, analyzerDefinition);
        return remoteName;
    }

    private String addTokenizerDef(String analyzerDefinitionName, TokenizerDef hibernateSearchDef) {
        String remoteName = hibernateSearchDef.name();
        TokenizerDefinition elasticsearchDefinition = this.analyzerDefinitionTranslator.translate(hibernateSearchDef);
        if (remoteName.isEmpty() && !this.hasParameters(elasticsearchDefinition)) {
            remoteName = elasticsearchDefinition.getType();
        } else {
            if (remoteName.isEmpty()) {
                remoteName = analyzerDefinitionName + "_" + hibernateSearchDef.factory().getSimpleName();
            }
            if (this.tokenizers.containsKey(remoteName)) {
                throw LOG.tokenizerNamingConflict(remoteName);
            }
            this.tokenizers.put(remoteName, elasticsearchDefinition);
        }
        return remoteName;
    }

    private String addCharFilterDef(String analyzerDefinitionName, CharFilterDef hibernateSearchDef) {
        String remoteName = hibernateSearchDef.name();
        CharFilterDefinition elasticsearchDefinition = this.analyzerDefinitionTranslator.translate(hibernateSearchDef);
        if (remoteName.isEmpty() && !this.hasParameters(elasticsearchDefinition)) {
            remoteName = elasticsearchDefinition.getType();
        } else {
            if (remoteName.isEmpty()) {
                remoteName = analyzerDefinitionName + "_" + hibernateSearchDef.factory().getSimpleName();
            }
            if (this.charFilters.containsKey(remoteName)) {
                throw LOG.charFilterNamingConflict(remoteName);
            }
            this.charFilters.put(remoteName, elasticsearchDefinition);
        }
        return remoteName;
    }

    private String addTokenFilterDef(String analyzerDefinitionName, TokenFilterDef hibernateSearchDef) {
        String remoteName = hibernateSearchDef.name();
        TokenFilterDefinition elasticsearchDefinition = this.analyzerDefinitionTranslator.translate(hibernateSearchDef);
        if (remoteName.isEmpty() && !this.hasParameters(elasticsearchDefinition)) {
            remoteName = elasticsearchDefinition.getType();
        } else {
            if (remoteName.isEmpty()) {
                remoteName = analyzerDefinitionName + "_" + hibernateSearchDef.factory().getSimpleName();
            }
            if (this.tokenFilters.containsKey(remoteName)) {
                throw LOG.tokenFilterNamingConflict(remoteName);
            }
            this.tokenFilters.put(remoteName, elasticsearchDefinition);
        }
        return remoteName;
    }

    private boolean hasParameters(AnalysisDefinition definition) {
        Map<String, JsonElement> parameters = definition.getParameters();
        return parameters != null && !parameters.isEmpty();
    }
}

