/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import org.infinispan.atomic.Delta;
import org.infinispan.atomic.DeltaCompositeKey;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.DeltaAwareCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.lifecycle.ComponentStatus;

public class ApplyDeltaCommand
extends AbstractDataWriteCommand {
    public static final int COMMAND_ID = 25;
    private Collection<Object> keys;
    private Delta delta;

    public ApplyDeltaCommand() {
    }

    public ApplyDeltaCommand(Object deltaAwareValueKey, Delta delta, Collection<Object> keys, CommandInvocationId commandInvocationId) {
        super(deltaAwareValueKey, EnumUtil.bitSetOf((Enum)Flag.DELTA_WRITE), commandInvocationId);
        if (keys == null || keys.isEmpty()) {
            throw new IllegalArgumentException("At least one key to be locked needs to be specified");
        }
        this.keys = keys;
        this.delta = delta;
    }

    public Delta getDelta() {
        return this.delta;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        CacheEntry contextEntry = ctx.lookupEntry(this.key);
        if (!(contextEntry instanceof DeltaAwareCacheEntry)) {
            throw new IllegalStateException();
        }
        DeltaAwareCacheEntry deltaAwareCacheEntry = (DeltaAwareCacheEntry)contextEntry;
        deltaAwareCacheEntry.appendDelta(this.delta);
        return null;
    }

    @Override
    public byte getCommandId() {
        return 25;
    }

    @Override
    public String toString() {
        return "ApplyDeltaCommand[key=" + this.key + ", delta=" + this.delta + ", keys=" + this.keys + ']';
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        output.writeObject(this.delta);
        MarshallUtil.marshallCollection(this.keys, (ObjectOutput)output);
        output.writeLong(FlagBitSets.copyWithoutRemotableFlags(this.getFlagsBitSet()));
        CommandInvocationId.writeTo(output, this.commandInvocationId);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        this.delta = (Delta)input.readObject();
        this.keys = MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new);
        this.setFlagsBitSet(input.readLong());
        this.commandInvocationId = CommandInvocationId.readFrom(input);
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitApplyDeltaCommand(ctx, this);
    }

    public Object[] getKeys() {
        return this.keys.toArray();
    }

    public Object[] getCompositeKeys() {
        Object[] compositeKeys = new DeltaCompositeKey[this.keys.size()];
        int i = 0;
        for (Object k : this.keys) {
            compositeKeys[i++] = new DeltaCompositeKey(this.key, k);
        }
        return compositeKeys;
    }

    @Override
    public boolean ignoreCommandOnStatus(ComponentStatus status) {
        switch (status) {
            case FAILED: 
            case INITIALIZING: 
            case STOPPING: 
            case TERMINATED: {
                return true;
            }
        }
        return false;
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.OWNER;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApplyDeltaCommand)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ApplyDeltaCommand that = (ApplyDeltaCommand)o;
        return this.keys.equals(that.keys);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.keys.hashCode();
    }

    @Override
    public boolean isSuccessful() {
        return true;
    }

    @Override
    public boolean isConditional() {
        return false;
    }

    @Override
    public ValueMatcher getValueMatcher() {
        return ValueMatcher.MATCH_ALWAYS;
    }

    @Override
    public void setValueMatcher(ValueMatcher valueMatcher) {
    }

    @Override
    public void updateStatusFromRemoteResponse(Object remoteResponse) {
    }
}

