/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.lang.reflect.Method;
import java.util.Properties;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.persistence.Store;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.AbstractPersistenceConfigurationChildBuilder;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.SingletonStoreConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.XmlConfigHelper;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class AbstractStoreConfigurationBuilder<T extends StoreConfiguration, S extends AbstractStoreConfigurationBuilder<T, S>>
extends AbstractPersistenceConfigurationChildBuilder
implements StoreConfigurationBuilder<T, S> {
    private static final Log log = LogFactory.getLog(AbstractStoreConfigurationBuilder.class);
    protected final AttributeSet attributes;
    protected final AsyncStoreConfigurationBuilder<S> async;
    protected final SingletonStoreConfigurationBuilder<S> singletonStore;
    @Deprecated
    protected boolean preload;
    @Deprecated
    protected boolean shared;
    @Deprecated
    protected boolean ignoreModifications;
    @Deprecated
    protected Properties properties;
    @Deprecated
    protected boolean purgeOnStartup;
    @Deprecated
    protected boolean fetchPersistentState;

    @Deprecated
    public AbstractStoreConfigurationBuilder(PersistenceConfigurationBuilder builder) {
        super(builder);
        this.attributes = AbstractStoreConfiguration.attributeDefinitionSet();
        this.async = new AsyncStoreConfigurationBuilder(this);
        this.singletonStore = new SingletonStoreConfigurationBuilder(this);
        this.initCompatibilitySettings();
    }

    public AbstractStoreConfigurationBuilder(PersistenceConfigurationBuilder builder, AttributeSet attributes) {
        super(builder);
        this.attributes = attributes;
        this.async = new AsyncStoreConfigurationBuilder(this);
        this.singletonStore = new SingletonStoreConfigurationBuilder(this);
        this.initCompatibilitySettings();
    }

    @Deprecated
    private void initCompatibilitySettings() {
        this.fetchPersistentState = (Boolean)this.attributes.attribute(AbstractStoreConfiguration.FETCH_PERSISTENT_STATE).get();
        this.preload = (Boolean)this.attributes.attribute(AbstractStoreConfiguration.PRELOAD).get();
        this.purgeOnStartup = (Boolean)this.attributes.attribute(AbstractStoreConfiguration.PURGE_ON_STARTUP).get();
        this.shared = (Boolean)this.attributes.attribute(AbstractStoreConfiguration.SHARED).get();
        this.ignoreModifications = (Boolean)this.attributes.attribute(AbstractStoreConfiguration.IGNORE_MODIFICATIONS).get();
        this.properties = (Properties)this.attributes.attribute(AbstractStoreConfiguration.PROPERTIES).get();
    }

    @Override
    public AsyncStoreConfigurationBuilder<S> async() {
        return this.async;
    }

    @Override
    public SingletonStoreConfigurationBuilder<S> singleton() {
        return this.singletonStore;
    }

    @Override
    public S fetchPersistentState(boolean b) {
        this.attributes.attribute(AbstractStoreConfiguration.FETCH_PERSISTENT_STATE).set((Object)b);
        this.fetchPersistentState = b;
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S ignoreModifications(boolean b) {
        this.attributes.attribute(AbstractStoreConfiguration.IGNORE_MODIFICATIONS).set((Object)b);
        this.ignoreModifications = b;
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S purgeOnStartup(boolean b) {
        this.attributes.attribute(AbstractStoreConfiguration.PURGE_ON_STARTUP).set((Object)b);
        this.purgeOnStartup = b;
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    public S properties(Properties properties) {
        this.attributes.attribute(AbstractStoreConfiguration.PROPERTIES).set((Object)new TypedProperties(properties));
        this.properties = properties;
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S addProperty(String key, String value) {
        TypedProperties properties = (TypedProperties)this.attributes.attribute(AbstractStoreConfiguration.PROPERTIES).get();
        properties.put((Object)key, (Object)value);
        this.attributes.attribute(AbstractStoreConfiguration.PROPERTIES).set((Object)properties);
        XmlConfigHelper.setAttributes(this.attributes, properties, false, false);
        this.properties = properties;
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S withProperties(Properties props) {
        XmlConfigHelper.showUnrecognizedAttributes(XmlConfigHelper.setAttributes(this.attributes, props, false, false));
        this.attributes.attribute(AbstractStoreConfiguration.PROPERTIES).set((Object)new TypedProperties(props));
        this.properties = props;
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S preload(boolean b) {
        this.attributes.attribute(AbstractStoreConfiguration.PRELOAD).set((Object)b);
        this.preload = b;
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S shared(boolean b) {
        this.attributes.attribute(AbstractStoreConfiguration.SHARED).set((Object)b);
        this.shared = b;
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S transactional(boolean b) {
        this.attributes.attribute(AbstractStoreConfiguration.TRANSACTIONAL).set((Object)b);
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    public void validate() {
        this.async.validate();
        this.singletonStore.validate();
        boolean shared = (Boolean)this.attributes.attribute(AbstractStoreConfiguration.SHARED).get();
        boolean fetchPersistentState = (Boolean)this.attributes.attribute(AbstractStoreConfiguration.FETCH_PERSISTENT_STATE).get();
        boolean purgeOnStartup = (Boolean)this.attributes.attribute(AbstractStoreConfiguration.PURGE_ON_STARTUP).get();
        boolean preload = (Boolean)this.attributes.attribute(AbstractStoreConfiguration.PRELOAD).get();
        boolean transactional = (Boolean)this.attributes.attribute(AbstractStoreConfiguration.TRANSACTIONAL).get();
        ConfigurationBuilder builder = this.getBuilder();
        Class configKlass = this.attributes.getKlass();
        if (configKlass != null && configKlass.isAnnotationPresent(ConfigurationFor.class)) {
            Class storeKlass = configKlass.getAnnotation(ConfigurationFor.class).value();
            if (storeKlass.isAnnotationPresent(Store.class)) {
                Store storeProps = storeKlass.getAnnotation(Store.class);
                if (!storeProps.shared() && shared) {
                    throw log.nonSharedStoreConfiguredAsShared(storeKlass.getSimpleName());
                }
            } else {
                log.warnStoreAnnotationMissing(storeKlass.getSimpleName());
            }
        } else {
            log.warnConfigurationForAnnotationMissing(this.attributes.getName());
        }
        if (!shared && !fetchPersistentState && !purgeOnStartup && builder.clustering().cacheMode().isClustered()) {
            log.staleEntriesWithoutFetchPersistentStateOrPurgeOnStartup();
        }
        if (fetchPersistentState && this.attributes.attribute(AbstractStoreConfiguration.FETCH_PERSISTENT_STATE).isModified() && this.clustering().cacheMode().isInvalidation()) {
            throw log.attributeNotAllowedInInvalidationMode(AbstractStoreConfiguration.FETCH_PERSISTENT_STATE.name());
        }
        if (shared && !preload && builder.indexing().enabled() && builder.indexing().indexLocalOnly()) {
            log.localIndexingWithSharedCacheLoaderRequiresPreload();
        }
        if (transactional && !builder.transaction().transactionMode().isTransactional()) {
            throw log.transactionalStoreInNonTransactionalCache();
        }
        if (transactional && builder.persistence().passivation()) {
            throw log.transactionalStoreInPassivatedCache();
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    public Builder<?> read(T template) {
        Method attributesMethod = ReflectionUtil.findMethod(template.getClass(), (String)"attributes");
        try {
            this.attributes.read((AttributeSet)attributesMethod.invoke(template, null));
        }
        catch (Exception e) {
            throw new CacheConfigurationException(e);
        }
        this.initCompatibilitySettings();
        this.async.read(template.async());
        this.singletonStore.read(template.singletonStore());
        return this;
    }

    public String toString() {
        return "AbstractStoreConfigurationBuilder [attributes=" + this.attributes + ", async=" + this.async + ", singletonStore=" + this.singletonStore + "]";
    }
}

