/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.DataCommand;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.locking.AbstractTxLockingInterceptor;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.util.concurrent.locks.LockUtil;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PessimisticLockingInterceptor
extends AbstractTxLockingInterceptor {
    private static final Log log = LogFactory.getLog(PessimisticLockingInterceptor.class);
    private CommandsFactory cf;
    private StateTransferManager stateTransferManager;

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void init(CommandsFactory factory, StateTransferManager stateTransferManager) {
        this.cf = factory;
        this.stateTransferManager = stateTransferManager;
    }

    @Override
    protected final Object visitDataReadCommand(InvocationContext ctx, DataCommand command) throws Throwable {
        if (!this.readNeedsLock(ctx, command)) {
            return this.invokeNext(ctx, command);
        }
        try {
            if (!this.readNeedsLock(ctx, command)) {
                return this.invokeNext(ctx, command);
            }
            Object key = command.getKey();
            if (!this.needRemoteLocks(ctx, key, (FlagAffectedCommand)command)) {
                this.acquireLocalLock(ctx, command);
                return this.invokeNext(ctx, command);
            }
            TxInvocationContext txContext = (TxInvocationContext)ctx;
            LockControlCommand lcc = this.cf.buildLockControlCommand(key, command.getFlagsBitSet(), txContext.getGlobalTransaction());
            Object result = this.invokeNextThenApply(ctx, lcc, (rCtx, rCommand, rv) -> this.invokeNext(rCtx, command));
            return PessimisticLockingInterceptor.makeStage(result).andFinally(ctx, command, (rCtx, rCommand, rv, t) -> {
                if (t != null) {
                    this.rethrowAndReleaseLocksIfNeeded(rCtx, t);
                } else {
                    this.acquireLocalLock(rCtx, (DataCommand)rCommand);
                }
            });
        }
        catch (Throwable t2) {
            this.rethrowAndReleaseLocksIfNeeded(ctx, t2);
            throw t2;
        }
    }

    private boolean readNeedsLock(InvocationContext ctx, FlagAffectedCommand command) {
        return ctx.isInTxScope() && command.hasAnyFlag(FlagBitSets.FORCE_WRITE_LOCK) && !this.hasSkipLocking(command);
    }

    private void acquireLocalLock(InvocationContext ctx, DataCommand command) throws InterruptedException {
        log.tracef("acquireLocalLock", new Object[0]);
        TxInvocationContext txContext = (TxInvocationContext)ctx;
        Object key = command.getKey();
        this.lockOrRegisterBackupLock(txContext, key, this.getLockTimeoutMillis(command));
        txContext.addAffectedKey(key);
    }

    @Override
    public Object visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        try {
            Object stage;
            if (!this.readNeedsLock(ctx, command)) {
                stage = this.invokeNext(ctx, command);
            } else {
                Collection<?> keys = command.getKeys();
                if (!this.needRemoteLocks(ctx, keys, (FlagAffectedCommand)command)) {
                    this.acquireLocalLocks(ctx, command, keys);
                    stage = this.invokeNext(ctx, command);
                } else {
                    TxInvocationContext txContext = (TxInvocationContext)ctx;
                    LockControlCommand lcc = this.cf.buildLockControlCommand(keys, command.getFlagsBitSet(), txContext.getGlobalTransaction());
                    stage = this.invokeNextThenApply(ctx, lcc, (rCtx, rLockCommand, rv) -> {
                        this.acquireLocalLocks(rCtx, command, keys);
                        return this.invokeNext(rCtx, command);
                    });
                }
            }
            return PessimisticLockingInterceptor.makeStage(stage).andExceptionally(ctx, command, (rCtx, rCommand, t) -> {
                this.releaseLocksOnFailureBeforePrepare(rCtx);
                throw t;
            });
        }
        catch (Throwable t2) {
            this.releaseLocksOnFailureBeforePrepare(ctx);
            throw t2;
        }
    }

    private void acquireLocalLocks(InvocationContext ctx, FlagAffectedCommand command, Collection<?> keys) throws InterruptedException {
        this.lockAllOrRegisterBackupLock((TxInvocationContext)ctx, keys, this.getLockTimeoutMillis(command));
        ((TxInvocationContext)ctx).addAllAffectedKeys(keys);
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (!command.isOnePhaseCommit()) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNextThenAccept(ctx, command, (rCtx, rCommand, rv) -> this.releaseLockOnTxCompletion((TxInvocationContext)rCtx));
    }

    @Override
    protected <K> Object handleWriteManyCommand(InvocationContext ctx, FlagAffectedCommand command, Collection<K> keys, boolean forwarded) throws Throwable {
        try {
            Object stage;
            if (this.hasSkipLocking(command)) {
                stage = this.invokeNext(ctx, command);
            } else if (!this.needRemoteLocks(ctx, keys, command)) {
                this.acquireLocalLocks(ctx, command, keys);
                stage = this.invokeNext(ctx, command);
            } else {
                TxInvocationContext txContext = (TxInvocationContext)ctx;
                LockControlCommand lcc = this.cf.buildLockControlCommand(keys, command.getFlagsBitSet(), txContext.getGlobalTransaction());
                stage = this.invokeNextThenApply(ctx, lcc, (rCtx, rCommand, rv) -> {
                    this.acquireLocalLocks(rCtx, command, keys);
                    return this.invokeNext(rCtx, command);
                });
            }
            return PessimisticLockingInterceptor.makeStage(stage).andExceptionally(ctx, command, (rCtx, rCommand, t) -> {
                this.rethrowAndReleaseLocksIfNeeded(rCtx, t);
                throw t;
            });
        }
        catch (Throwable t2) {
            this.rethrowAndReleaseLocksIfNeeded(ctx, t2);
            throw t2;
        }
    }

    @Override
    protected Object visitDataWriteCommand(InvocationContext ctx, DataWriteCommand command) throws Throwable {
        try {
            Object stage;
            Object key = command.getKey();
            if (this.hasSkipLocking(command)) {
                if (ctx.isInTxScope()) {
                    ((TxInvocationContext)ctx).addAffectedKey(key);
                }
                stage = this.invokeNext(ctx, command);
            } else if (!this.needRemoteLocks(ctx, key, (FlagAffectedCommand)command)) {
                this.acquireLocalLock(ctx, command);
                stage = this.invokeNext(ctx, command);
            } else {
                TxInvocationContext txContext = (TxInvocationContext)ctx;
                LockControlCommand lcc = this.cf.buildLockControlCommand(key, command.getFlagsBitSet(), txContext.getGlobalTransaction());
                return this.invokeNextAndHandle(ctx, lcc, (rCtx, rCommand, rv, t) -> {
                    this.rethrowAndReleaseLocksIfNeeded(rCtx, t);
                    this.acquireLocalLock(rCtx, command);
                    return this.invokeNext(rCtx, command);
                });
            }
            return PessimisticLockingInterceptor.makeStage(stage).andExceptionally(ctx, command, (rCtx, rCommand, t) -> {
                this.rethrowAndReleaseLocksIfNeeded(rCtx, t);
                throw t;
            });
        }
        catch (Throwable t2) {
            this.releaseLocksOnFailureBeforePrepare(ctx);
            throw t2;
        }
    }

    @Override
    public Object visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
        try {
            Object stage;
            if (this.hasSkipLocking(command)) {
                stage = this.invokeNext(ctx, command);
            } else {
                Object[] compositeKeys = command.getCompositeKeys();
                HashSet<Object> keysToLock = new HashSet<Object>(Arrays.asList(compositeKeys));
                if (!this.needRemoteLocks(ctx, keysToLock, (FlagAffectedCommand)command)) {
                    this.acquireLocalCompositeLocks(command, keysToLock, ctx);
                    stage = this.invokeNext(ctx, command);
                } else {
                    TxInvocationContext txContext = (TxInvocationContext)ctx;
                    LockControlCommand lcc = this.cf.buildLockControlCommand(keysToLock, command.getFlagsBitSet(), txContext.getGlobalTransaction());
                    stage = this.invokeNextThenApply(ctx, lcc, (rCtx, rCommand, rv) -> {
                        ((TxInvocationContext)rCtx).addAllAffectedKeys(keysToLock);
                        this.acquireLocalCompositeLocks(command, keysToLock, rCtx);
                        return this.invokeNext(rCtx, command);
                    });
                }
            }
            return PessimisticLockingInterceptor.makeStage(stage).andExceptionally(ctx, command, (rCtx, rCommand, t) -> {
                this.lockManager.unlockAll(rCtx);
                throw t;
            });
        }
        catch (Throwable t2) {
            this.lockManager.unlockAll(ctx);
            throw t2;
        }
    }

    private void acquireLocalCompositeLocks(ApplyDeltaCommand command, Set<Object> keysToLock, InvocationContext ctx1) throws InterruptedException {
        if (this.cdl.localNodeIsPrimaryOwner(command.getKey())) {
            this.lockAllAndRecord(ctx1, keysToLock, this.getLockTimeoutMillis(command));
        } else if (this.cdl.localNodeIsOwner(command.getKey())) {
            TxInvocationContext txContext = (TxInvocationContext)ctx1;
            for (Object key : keysToLock) {
                ((AbstractCacheTransaction)txContext.getCacheTransaction()).addBackupLockForKey(key);
            }
        }
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        if (!ctx.isInTxScope()) {
            throw new IllegalStateException("Locks should only be acquired within the scope of a transaction!");
        }
        boolean skipLocking = this.hasSkipLocking(command);
        if (skipLocking) {
            return false;
        }
        if (ctx.isOriginLocal()) {
            boolean needBackupLocks;
            boolean isSingleKeyAndLocal = !command.multipleKeys() && this.cdl.localNodeIsPrimaryOwner(command.getSingleKey());
            boolean bl = needBackupLocks = !isSingleKeyAndLocal || this.isStateTransferInProgress();
            if (needBackupLocks && !command.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL)) {
                LocalTransaction localTx = (LocalTransaction)ctx.getCacheTransaction();
                if (localTx.getAffectedKeys().containsAll(command.getKeys())) {
                    if (this.trace) {
                        log.tracef("Already own locks on keys: %s, skipping remote call", command.getKeys());
                    }
                    return true;
                }
            } else {
                if (this.trace) {
                    log.tracef("Single key %s and local, skipping remote call", command.getSingleKey());
                }
                return this.localLockCommandWork(ctx, command);
            }
        }
        return this.invokeNextAndHandle(ctx, command, (rCtx, rCommand, rv, t) -> {
            this.rethrowAndReleaseLocksIfNeeded(rCtx, t);
            return this.localLockCommandWork(rCtx, (LockControlCommand)rCommand);
        });
    }

    private boolean localLockCommandWork(InvocationContext ctx, LockControlCommand command) throws InterruptedException {
        TxInvocationContext txInvocationContext = (TxInvocationContext)ctx;
        if (ctx.isOriginLocal()) {
            txInvocationContext.addAllAffectedKeys(command.getKeys());
        }
        if (command.isUnlock()) {
            if (ctx.isOriginLocal()) {
                throw new AssertionError((Object)"There's no advancedCache.unlock so this must have originated remotely.");
            }
            this.releaseLocksOnFailureBeforePrepare(ctx);
            return false;
        }
        try {
            this.lockAllOrRegisterBackupLock(txInvocationContext, command.getKeys(), this.getLockTimeoutMillis(command));
        }
        catch (Throwable t) {
            this.releaseLocksOnFailureBeforePrepare(ctx);
            throw t;
        }
        return true;
    }

    private void rethrowAndReleaseLocksIfNeeded(InvocationContext ctx, Throwable throwable) throws Throwable {
        if (throwable != null) {
            if (!(throwable instanceof OutdatedTopologyException)) {
                this.releaseLocksOnFailureBeforePrepare(ctx);
            }
            throw throwable;
        }
    }

    private boolean needRemoteLocks(InvocationContext ctx, Collection<?> keys, FlagAffectedCommand command) throws Throwable {
        boolean needBackupLocks = ctx.isOriginLocal() && (!this.isLockOwner(keys) || this.isStateTransferInProgress());
        boolean needRemoteLock = false;
        if (needBackupLocks && !command.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL)) {
            TxInvocationContext txContext = (TxInvocationContext)ctx;
            LocalTransaction localTransaction = (LocalTransaction)txContext.getCacheTransaction();
            boolean bl = needRemoteLock = !localTransaction.getAffectedKeys().containsAll(keys);
            if (!needRemoteLock) {
                log.tracef("We already have lock for keys %s, skip remote lock acquisition", keys);
            }
        }
        return needRemoteLock;
    }

    private boolean needRemoteLocks(InvocationContext ctx, Object key, FlagAffectedCommand command) throws Throwable {
        boolean needBackupLocks = ctx.isOriginLocal() && (!this.isLockOwner(key) || this.isStateTransferInProgress());
        boolean needRemoteLock = false;
        if (needBackupLocks && !command.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL)) {
            TxInvocationContext txContext = (TxInvocationContext)ctx;
            LocalTransaction localTransaction = (LocalTransaction)txContext.getCacheTransaction();
            boolean bl = needRemoteLock = !localTransaction.getAffectedKeys().contains(key);
            if (!needRemoteLock) {
                log.tracef("We already have lock for key %s, skip remote lock acquisition", key);
            }
        }
        return needRemoteLock;
    }

    private boolean isLockOwner(Collection<?> keys) {
        for (Object key : keys) {
            if (LockUtil.isLockOwner(key, this.cdl)) continue;
            return false;
        }
        return true;
    }

    private boolean isLockOwner(Object key) {
        return LockUtil.isLockOwner(key, this.cdl);
    }

    private boolean isStateTransferInProgress() {
        return this.stateTransferManager != null && this.stateTransferManager.isStateTransferInProgress();
    }

    private void releaseLocksOnFailureBeforePrepare(InvocationContext ctx) {
        this.lockManager.unlockAll(ctx);
        if (ctx.isOriginLocal() && ctx.isInTxScope() && this.rpcManager != null) {
            TxInvocationContext txContext = (TxInvocationContext)ctx;
            TxCompletionNotificationCommand command = this.cf.buildTxCompletionNotificationCommand(null, txContext.getGlobalTransaction());
            LocalTransaction cacheTransaction = (LocalTransaction)txContext.getCacheTransaction();
            this.rpcManager.invokeRemotely(cacheTransaction.getRemoteLocksAcquired(), command, this.rpcManager.getDefaultRpcOptions(false, DeliverOrder.NONE));
        }
    }
}

