/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.xsite;

import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.remoting.transport.BackupResponse;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.BackupSender;

public class BaseBackupInterceptor
extends DDAsyncInterceptor {
    protected BackupSender backupSender;
    protected TransactionTable txTable;
    private static final Log log = LogFactory.getLog(BaseBackupInterceptor.class);

    @Inject
    void init(BackupSender sender, TransactionTable txTable) {
        this.backupSender = sender;
        this.txTable = txTable;
    }

    @Override
    public final Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return this.handleMultipleKeysWriteCommand(ctx, command);
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (!this.shouldInvokeRemoteTxCommand(ctx)) {
            return this.invokeNext(ctx, command);
        }
        boolean isTxFromRemoteSite = this.isTxFromRemoteSite(command.getGlobalTransaction());
        if (isTxFromRemoteSite) {
            return this.invokeNext(ctx, command);
        }
        BackupResponse backupResponse = this.backupSender.backupPrepare(command);
        return this.processBackupResponse(ctx, command, backupResponse);
    }

    protected Object processBackupResponse(TxInvocationContext ctx, VisitableCommand command, BackupResponse backupResponse) {
        return this.invokeNextThenAccept(ctx, command, (rCtx, rCommand, rv) -> this.backupSender.processResponses(backupResponse, command, ctx.getTransaction()));
    }

    protected Object handleMultipleKeysWriteCommand(InvocationContext ctx, WriteCommand command) throws Throwable {
        if (!ctx.isOriginLocal() || this.skipXSiteBackup(command)) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNextThenAccept(ctx, command, (rCtx, rCommand, rv) -> this.backupSender.processResponses(this.backupSender.backupWrite(command), command));
    }

    protected boolean isTxFromRemoteSite(GlobalTransaction gtx) {
        LocalTransaction remoteTx = this.txTable.getLocalTransaction(gtx);
        return remoteTx != null && remoteTx.isFromRemoteSite();
    }

    protected boolean shouldInvokeRemoteTxCommand(TxInvocationContext ctx) {
        boolean shouldBackupRemotely = ctx.isOriginLocal() && ctx.hasModifications() && !((AbstractCacheTransaction)ctx.getCacheTransaction()).isFromStateTransfer();
        this.getLog().tracef("Should backup remotely? %s", shouldBackupRemotely);
        return shouldBackupRemotely;
    }

    protected final boolean skipXSiteBackup(FlagAffectedCommand command) {
        return command.hasAnyFlag(FlagBitSets.SKIP_XSITE_BACKUP);
    }

    protected Log getLog() {
        return log;
    }
}

