/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import org.infinispan.security.Security;

final class SecurityActions {
    SecurityActions() {
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return Security.doPrivileged(action);
    }

    static void registerMBean(Object mbean, ObjectName objectName, MBeanServer mBeanServer) throws Exception {
        SecurityActions.doPrivileged(() -> {
            try {
                mBeanServer.registerMBean(mbean, objectName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        });
    }

    static void unregisterMBean(ObjectName objectName, MBeanServer mBeanServer) throws Exception {
        SecurityActions.doPrivileged(() -> {
            try {
                mBeanServer.unregisterMBean(objectName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        });
    }

    static Set<ObjectName> queryNames(ObjectName target, QueryExp query, MBeanServer mBeanServer) throws MalformedObjectNameException {
        HashSet results = new HashSet();
        return SecurityActions.doPrivileged(() -> {
            results.addAll(mBeanServer.queryNames(target, query));
            return results;
        });
    }
}

