/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.infinispan.server.commons.controller.Operations;
import org.infinispan.server.endpoint.subsystem.CacheIgnoreReadWriteHandler;
import org.infinispan.server.endpoint.subsystem.CommonConnectorResource;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

public class CacheDisablingCascadeHandler
implements OperationStepHandler {
    private final BiFunction<ModelNode, ModelNode, ModelNode> modelNodeOp;

    public CacheDisablingCascadeHandler(BiFunction<ModelNode, ModelNode, ModelNode> modelNodeOp) {
        this.modelNodeOp = modelNodeOp;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        ModelNode cacheNames = operation.get("cache-names");
        Resource endpointResource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        Stream connectorResources = endpointResource.getChildTypes().stream().flatMap(type -> endpointResource.getChildren(type).stream());
        connectorResources.forEach(resourceEntry -> {
            ModelNode list = resourceEntry.getModel().get("ignored-caches");
            ModelNode result = this.modelNodeOp.apply(list, cacheNames);
            PathElement pathElement = resourceEntry.getPathElement();
            ModelNode op = Operations.createWriteAttributeOperation((PathAddress)PathAddress.pathAddress((PathAddress)address, (PathElement[])new PathElement[]{pathElement}), (String)"ignored-caches", (ModelNode)result);
            context.addStep(op, (OperationStepHandler)new CacheIgnoreReadWriteHandler((AttributeDefinition)CommonConnectorResource.IGNORED_CACHES), OperationContext.Stage.MODEL);
        });
    }
}

