/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.NettyRestServer;
import org.infinispan.rest.configuration.ExtendedHeaders;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.server.endpoint.EndpointLogger;
import org.infinispan.server.endpoint.subsystem.EncryptableService;
import org.infinispan.server.endpoint.subsystem.EncryptableServiceHelper;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class RestService
implements Service<NettyRestServer>,
EncryptableService {
    private static final String DEFAULT_CONTEXT_PATH = "";
    private final InjectedValue<PathManager> pathManagerInjector = new InjectedValue();
    private final InjectedValue<EmbeddedCacheManager> cacheManagerInjector = new InjectedValue();
    private final InjectedValue<SecurityDomainContext> securityDomainContextInjector = new InjectedValue();
    private final InjectedValue<SocketBinding> socketBinding = new InjectedValue();
    private final InjectedValue<SecurityRealm> encryptionSecurityRealm = new InjectedValue();
    private final Map<String, InjectedValue<SecurityRealm>> sniDomains = new HashMap<String, InjectedValue<SecurityRealm>>();
    private final ModelNode config;
    private final String serverName;
    private NettyRestServer restServer;
    private boolean clientAuth;

    public RestService(String serverName, ModelNode config) {
        this.serverName = serverName;
        this.config = config.clone();
    }

    private String cleanContextPath(String s) {
        if (s.endsWith("/")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    public synchronized void start(StartContext startContext) throws StartException {
        String path = this.config.hasDefined("context-path") ? this.cleanContextPath(this.config.get("context-path").asString()) : DEFAULT_CONTEXT_PATH;
        RestServerConfigurationBuilder builder = new RestServerConfigurationBuilder();
        builder.name(this.serverName);
        if (this.config.hasDefined("ignored-caches")) {
            Set ignoredCaches = this.config.get("ignored-caches").asList().stream().map(ModelNode::asString).collect(Collectors.toSet());
            builder.ignoredCaches(ignoredCaches);
        }
        builder.extendedHeaders(this.config.hasDefined("extended-headers") ? ExtendedHeaders.valueOf((String)this.config.get("extended-headers").asString()) : ExtendedHeaders.ON_DEMAND);
        EncryptableServiceHelper.fillSecurityConfiguration(this, builder.ssl());
        String protocolName = this.getProtocolName();
        EndpointLogger.ROOT_LOGGER.endpointStarting(protocolName);
        try {
            SocketBinding socketBinding = (SocketBinding)this.getSocketBinding().getOptionalValue();
            if (socketBinding == null) {
                builder.startTransport(false);
                EndpointLogger.ROOT_LOGGER.startingServerWithoutTransport("REST");
            } else {
                InetSocketAddress socketAddress = socketBinding.getSocketAddress();
                builder.host(socketAddress.getAddress().getHostAddress());
                builder.port(socketAddress.getPort());
            }
            this.restServer = NettyRestServer.createServer((RestServerConfiguration)builder.build(), (EmbeddedCacheManager)((EmbeddedCacheManager)this.cacheManagerInjector.getValue()));
        }
        catch (Exception e) {
            throw EndpointLogger.ROOT_LOGGER.restContextCreationFailed(e);
        }
        try {
            this.restServer.start();
            EndpointLogger.ROOT_LOGGER.httpEndpointStarted(protocolName, path, "rest");
        }
        catch (Exception e) {
            throw EndpointLogger.ROOT_LOGGER.restContextStartFailed(e);
        }
    }

    private String getProtocolName() {
        return EncryptableServiceHelper.isSecurityEnabled(this) ? (EncryptableServiceHelper.isSniEnabled(this) ? this.serverName + "+SNI" : this.serverName + "+SSL") : this.serverName;
    }

    public synchronized void stop(StopContext stopContext) {
        this.restServer.stop();
    }

    public synchronized NettyRestServer getValue() throws IllegalStateException {
        if (this.restServer == null) {
            throw new IllegalStateException();
        }
        return this.restServer;
    }

    public InjectedValue<PathManager> getPathManagerInjector() {
        return this.pathManagerInjector;
    }

    public InjectedValue<EmbeddedCacheManager> getCacheManager() {
        return this.cacheManagerInjector;
    }

    public InjectedValue<SecurityDomainContext> getSecurityDomainContextInjector() {
        return this.securityDomainContextInjector;
    }

    public InjectedValue<SocketBinding> getSocketBinding() {
        return this.socketBinding;
    }

    @Override
    public InjectedValue<SecurityRealm> getEncryptionSecurityRealm() {
        return this.encryptionSecurityRealm;
    }

    @Override
    public InjectedValue<SecurityRealm> getSniSecurityRealm(String sniHostName) {
        return this.sniDomains.computeIfAbsent(sniHostName, v -> new InjectedValue());
    }

    @Override
    public Map<String, InjectedValue<SecurityRealm>> getSniConfiguration() {
        return this.sniDomains;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public void setClientAuth(boolean enabled) {
        this.clientAuth = enabled;
    }

    @Override
    public boolean getClientAuth() {
        return this.clientAuth;
    }
}

