/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.infinispan.protostream.DescriptorParserException;

public final class FileDescriptorSource {
    private static final String ENCODING = "UTF-8";
    private static final int BUFFER_SIZE = 1024;
    private final Map<String, char[]> descriptors = new LinkedHashMap<String, char[]>();
    private ProgressCallback progressCallback;

    public FileDescriptorSource withProgressCallback(ProgressCallback progressCallback) throws IOException {
        this.progressCallback = progressCallback;
        return this;
    }

    public FileDescriptorSource addProtoFiles(String ... classpathResources) throws IOException {
        return this.addProtoFiles((ClassLoader)null, classpathResources);
    }

    public FileDescriptorSource addProtoFiles(ClassLoader userClassLoader, String ... classpathResources) throws IOException {
        for (String classpathResource : classpathResources) {
            if (classpathResource == null) {
                throw new IllegalArgumentException("classpathResource cannot be null");
            }
            String absPath = classpathResource.startsWith("/") ? classpathResource : "/" + classpathResource;
            InputStream resourceAsStream = FileDescriptorSource.getResourceAsStream(userClassLoader, absPath);
            if (resourceAsStream == null) {
                throw new IOException("Resource not found in class path : " + classpathResource);
            }
            String path = classpathResource.startsWith("/") ? classpathResource.substring(1) : classpathResource;
            this.addProtoFile(path, resourceAsStream);
        }
        return this;
    }

    public FileDescriptorSource addProtoFile(String name, String contents) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (contents == null) {
            throw new IllegalArgumentException("contents cannot be null");
        }
        String path = name.startsWith("/") ? name.substring(1) : name;
        this.descriptors.put(path, contents.toCharArray());
        return this;
    }

    public FileDescriptorSource addProtoFile(String name, InputStream contents) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (contents == null) {
            throw new IllegalArgumentException("contents cannot be null");
        }
        String path = name.startsWith("/") ? name.substring(1) : name;
        this.descriptors.put(path, this.toCharArray(contents));
        return this;
    }

    public FileDescriptorSource addProtoFile(String name, Reader contents) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (contents == null) {
            throw new IllegalArgumentException("contents cannot be null");
        }
        String path = name.startsWith("/") ? name.substring(1) : name;
        this.descriptors.put(path, this.toCharArray(contents));
        return this;
    }

    public FileDescriptorSource addProtoFile(String name, File protofile) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (protofile == null) {
            throw new IllegalArgumentException("protofile cannot be null");
        }
        String path = name.startsWith("/") ? name.substring(1) : name;
        this.descriptors.put(path, this.toCharArray(protofile));
        return this;
    }

    public static FileDescriptorSource fromResources(ClassLoader userClassLoader, String ... classPathResources) throws IOException {
        return new FileDescriptorSource().addProtoFiles(userClassLoader, classPathResources);
    }

    public static FileDescriptorSource fromResources(String ... classPathResources) throws IOException {
        return new FileDescriptorSource().addProtoFiles(classPathResources);
    }

    public static FileDescriptorSource fromString(String name, String protoSource) {
        return new FileDescriptorSource().addProtoFile(name, protoSource);
    }

    public Map<String, char[]> getFileDescriptors() {
        return Collections.unmodifiableMap(this.descriptors);
    }

    public ProgressCallback getProgressCallback() {
        return this.progressCallback;
    }

    private char[] toCharArray(File file) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            char[] cArray = this.toCharArray(is);
            return cArray;
        }
    }

    private char[] toCharArray(InputStream is) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(is, ENCODING);){
            char[] cArray = this.toCharArray(reader);
            return cArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private char[] toCharArray(Reader reader) throws IOException {
        try {
            int count;
            CharArrayWriter writer = new CharArrayWriter();
            char[] buffer = new char[1024];
            while ((count = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, count);
            }
            char[] cArray = writer.toCharArray();
            return cArray;
        }
        finally {
            reader.close();
        }
    }

    private static InputStream getResourceAsStream(ClassLoader userClassLoader, String resourcePath) {
        if (resourcePath.startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        ClassLoader[] classLoaders = new ClassLoader[]{userClassLoader, FileDescriptorSource.class.getClassLoader(), ClassLoader.getSystemClassLoader(), Thread.currentThread().getContextClassLoader()};
        InputStream is = null;
        for (ClassLoader cl : classLoaders) {
            if (cl != null && (is = cl.getResourceAsStream(resourcePath)) != null) break;
        }
        return is;
    }

    public static interface ProgressCallback {
        public void handleError(String var1, DescriptorParserException var2);

        public void handleSuccess(String var1);
    }
}

