/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.search.analyzer.spi.AnalyzerReference;
import org.hibernate.search.analyzer.spi.AnalyzerStrategy;
import org.hibernate.search.analyzer.spi.ScopedAnalyzerReference;
import org.hibernate.search.annotations.AnalyzerDef;

public class AnalyzerReferenceRegistry {
    private final AnalyzerStrategy strategy;
    private final AnalyzerReference defaultReference;
    private final AnalyzerReference passThroughReference;
    private final Map<String, AnalyzerReference> referencesByName = new LinkedHashMap<String, AnalyzerReference>();
    private final Map<Class<?>, AnalyzerReference> referencesByClass = new LinkedHashMap();
    private final Collection<AnalyzerReference> scopedReferences = new ArrayList<AnalyzerReference>();

    AnalyzerReferenceRegistry(AnalyzerStrategy strategy) {
        this.strategy = strategy;
        this.defaultReference = strategy.createDefaultAnalyzerReference();
        this.passThroughReference = strategy.createPassThroughAnalyzerReference();
    }

    public AnalyzerReference getDefaultAnalyzerReference() {
        return this.defaultReference;
    }

    public AnalyzerReference getPassThroughAnalyzerReference() {
        return this.passThroughReference;
    }

    public Map<String, AnalyzerReference> getAnalyzerReferencesByName() {
        return Collections.unmodifiableMap(this.referencesByName);
    }

    public Map<Class<?>, AnalyzerReference> getAnalyzerReferencesByClass() {
        return Collections.unmodifiableMap(this.referencesByClass);
    }

    public AnalyzerReference getAnalyzerReference(String name) {
        AnalyzerReference reference = this.referencesByName.get(name);
        if (reference == null) {
            reference = this.strategy.createNamedAnalyzerReference(name);
            this.referencesByName.put(name, reference);
        }
        return reference;
    }

    public AnalyzerReference getAnalyzerReference(Class<?> analyzerClazz) {
        AnalyzerReference reference = this.referencesByClass.get(analyzerClazz);
        if (reference == null) {
            reference = this.strategy.createAnalyzerReference(analyzerClazz);
            this.referencesByClass.put(analyzerClazz, reference);
        }
        return reference;
    }

    public void initialize(Map<String, AnalyzerDef> analyzerDefinitions) {
        ArrayList<AnalyzerReference> references = new ArrayList<AnalyzerReference>();
        references.add(this.defaultReference);
        references.add(this.passThroughReference);
        references.addAll(this.referencesByName.values());
        references.addAll(this.referencesByClass.values());
        references.addAll(this.scopedReferences);
        this.strategy.initializeAnalyzerReferences(references, analyzerDefinitions);
    }

    public ScopedAnalyzerReference.Builder buildScopedAnalyzerReference() {
        return new ScopedAnalyzerReferenceBuilderRegisteringWrapper(this.strategy.buildScopedAnalyzerReference(this.getDefaultAnalyzerReference()));
    }

    private class ScopedAnalyzerReferenceBuilderRegisteringWrapper
    implements ScopedAnalyzerReference.Builder {
        private final ScopedAnalyzerReference.Builder delegate;

        public ScopedAnalyzerReferenceBuilderRegisteringWrapper(ScopedAnalyzerReference.Builder delegate) {
            this.delegate = delegate;
        }

        @Override
        public AnalyzerReference getGlobalAnalyzerReference() {
            return this.delegate.getGlobalAnalyzerReference();
        }

        @Override
        public void setGlobalAnalyzerReference(AnalyzerReference globalAnalyzerReference) {
            this.delegate.setGlobalAnalyzerReference(globalAnalyzerReference);
        }

        @Override
        public void addAnalyzerReference(String scope, AnalyzerReference analyzerReference) {
            this.delegate.addAnalyzerReference(scope, analyzerReference);
        }

        @Override
        public ScopedAnalyzerReference build() {
            ScopedAnalyzerReference reference = this.delegate.build();
            AnalyzerReferenceRegistry.this.scopedReferences.add(reference);
            return reference;
        }
    }
}

