/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.continuous.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.query.impl.externalizers.ExternalizerIds;

public final class ContinuousQueryResult<V> {
    private final ResultType resultType;
    private final V value;
    private final Object[] projection;

    ContinuousQueryResult(ResultType resultType, V value, Object[] projection) {
        this.resultType = resultType;
        this.value = value;
        this.projection = projection;
    }

    public ResultType getResultType() {
        return this.resultType;
    }

    public V getValue() {
        return this.value;
    }

    public Object[] getProjection() {
        return this.projection;
    }

    public String toString() {
        return "ContinuousQueryResult{resultType=" + (Object)((Object)this.resultType) + ", value=" + this.value + ", projection=" + Arrays.toString(this.projection) + '}';
    }

    public static final class Externalizer
    extends AbstractExternalizer<ContinuousQueryResult> {
        public void writeObject(ObjectOutput output, ContinuousQueryResult continuousQueryResult) throws IOException {
            output.writeInt(continuousQueryResult.resultType.ordinal());
            if (continuousQueryResult.resultType != ResultType.LEAVING) {
                if (continuousQueryResult.projection != null) {
                    output.writeObject(null);
                    int projLen = continuousQueryResult.projection.length;
                    output.writeInt(projLen);
                    for (int i = 0; i < projLen; ++i) {
                        output.writeObject(continuousQueryResult.projection[i]);
                    }
                } else {
                    output.writeObject(continuousQueryResult.value);
                }
            }
        }

        public ContinuousQueryResult readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            ResultType type = ResultType.values()[input.readInt()];
            Object value = null;
            Object[] projection = null;
            if (type != ResultType.LEAVING && (value = input.readObject()) == null) {
                int projLen = input.readInt();
                projection = new Object[projLen];
                for (int i = 0; i < projLen; ++i) {
                    projection[i] = input.readObject();
                }
            }
            return new ContinuousQueryResult<Object>(type, value, projection);
        }

        public Integer getId() {
            return ExternalizerIds.JPA_CONTINUOUS_QUERY_RESULT;
        }

        public Set<Class<? extends ContinuousQueryResult>> getTypeClasses() {
            return Collections.singleton(ContinuousQueryResult.class);
        }
    }

    public static enum ResultType {
        JOINING,
        UPDATED,
        LEAVING;

    }
}

