/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.impl;

import org.aesh.command.Command;
import org.aesh.command.CommandNotFoundException;
import org.aesh.command.CommandResolver;
import org.aesh.command.container.CommandContainer;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.registry.CommandRegistry;
import org.aesh.parser.LineParser;
import org.aesh.parser.ParsedLine;

public class AeshCommandResolver<C extends Command<CI>, CI extends CommandInvocation>
implements CommandResolver<C, CI> {
    private CommandRegistry<C, CI> registry;
    private LineParser lineParser;

    public AeshCommandResolver(CommandRegistry<C, CI> commandRegistry) {
        this.registry = commandRegistry;
        this.lineParser = new LineParser();
    }

    @Override
    public CommandRegistry<C, CI> getRegistry() {
        return this.registry;
    }

    @Override
    public CommandContainer<C, CI> resolveCommand(String line) throws CommandNotFoundException {
        return this.getCommand(this.lineParser.parseLine(line), line);
    }

    @Override
    public CommandContainer<C, CI> resolveCommand(ParsedLine line) throws CommandNotFoundException {
        return this.getCommand(line, line.line());
    }

    @Override
    public CommandContainer<C, CI> resolveCommand(String name, String line) throws CommandNotFoundException {
        return this.getCommand(name, line);
    }

    private CommandContainer<C, CI> getCommand(ParsedLine aeshLine, String line) throws CommandNotFoundException {
        return this.getCommand(aeshLine.words().get(0).word(), line);
    }

    private CommandContainer<C, CI> getCommand(String commandName, String line) throws CommandNotFoundException {
        try {
            return this.registry.getCommand(commandName, line);
        }
        catch (CommandNotFoundException e) {
            return this.registry.getCommandByAlias(commandName);
        }
    }
}

