/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandContextFactory;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.gui.GuiMain;
import org.jboss.as.cli.handlers.VersionHandler;
import org.jboss.as.protocol.StreamUtils;
import org.wildfly.security.manager.WildFlySecurityManager;

public class CliLauncher {
    private static final String JBOSS_CLI_RC_PROPERTY = "jboss.cli.rc";
    private static final String CURRENT_WORKING_DIRECTORY = "user.dir";
    private static final String JBOSS_CLI_RC_FILE = ".jbossclirc";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int exitCode = 0;
        CommandContext cmdCtx = null;
        boolean gui = false;
        try {
            String argError = null;
            List<String> commands = null;
            File file = null;
            boolean connect = false;
            String defaultController = null;
            boolean version = false;
            String username = null;
            char[] password = null;
            boolean noLocalAuth = false;
            int connectionTimeout = -1;
            for (String arg : args) {
                String value;
                if (arg.startsWith("--controller=") || arg.startsWith("controller=")) {
                    if (arg.startsWith("--")) {
                        defaultController = arg.substring(13);
                        continue;
                    }
                    defaultController = arg.substring(11);
                    continue;
                }
                if ("--connect".equals(arg) || "-c".equals(arg)) {
                    connect = true;
                    continue;
                }
                if ("--version".equals(arg)) {
                    version = true;
                    continue;
                }
                if ("--gui".equals(arg)) {
                    gui = true;
                    continue;
                }
                if (arg.startsWith("--file=") || arg.startsWith("file=")) {
                    String fileName;
                    if (file != null) {
                        argError = "Duplicate argument '--file'.";
                        break;
                    }
                    if (commands != null) {
                        argError = "Only one of '--file', '--commands' or '--command' can appear as the argument at a time.";
                        break;
                    }
                    String string = fileName = arg.startsWith("--") ? arg.substring(7) : arg.substring(5);
                    if (!fileName.isEmpty()) {
                        file = new File(fileName);
                        if (file.exists()) continue;
                        argError = "File " + file.getAbsolutePath() + " doesn't exist.";
                        break;
                    }
                    argError = "Argument '--file' is missing value.";
                    break;
                }
                if (arg.startsWith("--commands=") || arg.startsWith("commands=")) {
                    if (file != null) {
                        argError = "Only one of '--file', '--commands' or '--command' can appear as the argument at a time.";
                        break;
                    }
                    if (commands != null) {
                        argError = "Duplicate argument '--command'/'--commands'.";
                        break;
                    }
                    value = arg.startsWith("--") ? arg.substring(11) : arg.substring(9);
                    commands = Util.splitCommands(value);
                    continue;
                }
                if (arg.startsWith("--command=") || arg.startsWith("command=")) {
                    if (file != null) {
                        argError = "Only one of '--file', '--commands' or '--command' can appear as the argument at a time.";
                        break;
                    }
                    if (commands != null) {
                        argError = "'" + arg + "' is assumed to be a command(s) but the commands to execute have been specified by another argument: " + commands;
                        break;
                    }
                    value = arg.startsWith("--") ? arg.substring(10) : arg.substring(8);
                    commands = Collections.singletonList(value);
                    continue;
                }
                if (arg.startsWith("--user")) {
                    if (arg.length() > 6 && arg.charAt(6) == '=') {
                        username = arg.substring(7);
                        noLocalAuth = true;
                        continue;
                    }
                    argError = "'=' is missing after --user";
                    break;
                }
                if (arg.startsWith("--password")) {
                    if (arg.length() > 10 && arg.charAt(10) == '=') {
                        password = arg.substring(11).toCharArray();
                        continue;
                    }
                    argError = "'=' is missing after --password";
                    break;
                }
                if (arg.startsWith("-u")) {
                    if (arg.length() > 2 && arg.charAt(2) == '=') {
                        username = arg.substring(3);
                        noLocalAuth = true;
                        continue;
                    }
                    argError = "'=' is missing after -u";
                    break;
                }
                if (arg.startsWith("-p")) {
                    if (arg.length() > 2 && arg.charAt(2) == '=') {
                        password = arg.substring(3).toCharArray();
                        continue;
                    }
                    argError = "'=' is missing after -p";
                    break;
                }
                if (arg.equals("--no-local-auth")) {
                    noLocalAuth = true;
                    continue;
                }
                if (arg.startsWith("--timeout")) {
                    if (connectionTimeout > 0) {
                        argError = "Duplicate argument '--timeout'";
                        break;
                    }
                    if (arg.length() > 9 && arg.charAt(9) == '=') {
                        value = arg.substring(10);
                        try {
                            connectionTimeout = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                        if (connectionTimeout > 0) continue;
                        argError = "The timeout must be a valid positive integer: '" + value + "'";
                        break;
                    }
                    argError = "'=' is missing after --timeout";
                    break;
                }
                if (arg.equals("--help") || arg.equals("-h")) {
                    commands = Collections.singletonList("help");
                    continue;
                }
                if (arg.startsWith("--properties=")) {
                    value = arg.substring(13);
                    File propertiesFile = new File(value);
                    if (!propertiesFile.exists()) {
                        argError = "File doesn't exist: " + propertiesFile.getAbsolutePath();
                        break;
                    }
                    Properties props = new Properties();
                    FileInputStream fis = null;
                    try {
                        fis = new FileInputStream(propertiesFile);
                        props.load(fis);
                    }
                    catch (FileNotFoundException e) {
                        argError = e.getLocalizedMessage();
                        break;
                    }
                    catch (IOException e) {
                        argError = "Failed to load properties from " + propertiesFile.getAbsolutePath() + ": " + e.getLocalizedMessage();
                        break;
                    }
                    finally {
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                    for (Object prop : props.keySet()) {
                        WildFlySecurityManager.setPropertyPrivileged((String)prop, (String)props.get(prop));
                    }
                    continue;
                }
                if (arg.startsWith("-D") || arg.equals("-XX:")) continue;
                if (file != null) {
                    argError = "Only one of '--file', '--commands' or '--command' can appear as the argument at a time: " + arg;
                    break;
                }
                if (commands != null) {
                    argError = "'" + arg + "' is assumed to be a command(s) but the commands to execute have been specified by another argument: " + commands;
                    break;
                }
                commands = Util.splitCommands(arg);
            }
            if (argError != null) {
                System.err.println(argError);
                exitCode = 1;
                return;
            }
            if (version) {
                cmdCtx = CliLauncher.initCommandContext(defaultController, username, password, noLocalAuth, false, connect, connectionTimeout);
                VersionHandler.INSTANCE.handle(cmdCtx);
                return;
            }
            if (file != null) {
                cmdCtx = CliLauncher.initCommandContext(defaultController, username, password, noLocalAuth, false, connect, connectionTimeout);
                CliLauncher.processFile(file, cmdCtx);
                return;
            }
            if (commands != null) {
                cmdCtx = CliLauncher.initCommandContext(defaultController, username, password, noLocalAuth, false, connect, connectionTimeout);
                CliLauncher.processCommands(commands, cmdCtx);
                return;
            }
            if (gui) {
                cmdCtx = CliLauncher.initCommandContext(defaultController, username, password, noLocalAuth, false, true, connectionTimeout);
                CliLauncher.processGui(cmdCtx);
                return;
            }
            cmdCtx = CliLauncher.initCommandContext(defaultController, username, password, noLocalAuth, true, connect, connectionTimeout);
            cmdCtx.interact();
        }
        catch (Throwable t) {
            t.printStackTrace();
            exitCode = 1;
        }
        finally {
            if (cmdCtx != null) {
                cmdCtx.terminateSession();
                if (cmdCtx.getExitCode() != 0) {
                    exitCode = cmdCtx.getExitCode();
                }
            }
            if (!gui) {
                System.exit(exitCode);
            }
        }
        System.exit(exitCode);
    }

    private static CommandContext initCommandContext(String defaultController, String username, char[] password, boolean disableLocalAuth, boolean initConsole, boolean connect, int connectionTimeout) throws CliInitializationException {
        CommandContext cmdCtx = CommandContextFactory.getInstance().newCommandContext(defaultController, username, password, disableLocalAuth, initConsole, connectionTimeout);
        if (connect) {
            try {
                cmdCtx.connectController();
            }
            catch (CommandLineException e) {
                throw new CliInitializationException("Failed to connect to the controller", e);
            }
        }
        return cmdCtx;
    }

    private static void processGui(CommandContext cmdCtx) {
        try {
            GuiMain.start(cmdCtx);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void processCommands(List<String> commands, CommandContext cmdCtx) {
        for (int i = 0; cmdCtx.getExitCode() == 0 && i < commands.size() && !cmdCtx.isTerminated(); ++i) {
            cmdCtx.handleSafe(commands.get(i));
        }
    }

    private static void processFile(File file, CommandContext cmdCtx) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String line = reader.readLine();
            while (cmdCtx.getExitCode() == 0 && !cmdCtx.isTerminated() && line != null) {
                cmdCtx.handleSafe(line.trim());
                line = reader.readLine();
            }
        }
        catch (Throwable e) {
            try {
                throw new IllegalStateException("Failed to process file '" + file.getAbsolutePath() + "'", e);
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(reader);
                throw throwable;
            }
        }
        StreamUtils.safeClose(reader);
    }

    static void runcom(CommandContext ctx) throws CliInitializationException {
        File jbossCliRcFile = null;
        String jbossCliRc = WildFlySecurityManager.getPropertyPrivileged(JBOSS_CLI_RC_PROPERTY, null);
        if (jbossCliRc == null) {
            String dir = WildFlySecurityManager.getPropertyPrivileged(CURRENT_WORKING_DIRECTORY, null);
            File f = new File(dir, JBOSS_CLI_RC_FILE);
            if (!f.exists()) {
                dir = WildFlySecurityManager.getEnvPropertyPrivileged("JBOSS_HOME", null);
                if (dir != null && (f = new File(dir + File.separatorChar + "bin", JBOSS_CLI_RC_FILE)).exists()) {
                    jbossCliRcFile = f;
                }
            } else {
                jbossCliRcFile = f;
            }
        } else {
            jbossCliRcFile = new File(jbossCliRc);
            if (!jbossCliRcFile.exists()) {
                throw new CliInitializationException("Property jboss.cli.rc points to a file that doesn't exist: " + jbossCliRcFile.getAbsolutePath());
            }
        }
        if (jbossCliRcFile != null) {
            CliLauncher.processFile(jbossCliRcFile, ctx);
            if (ctx.getExitCode() != 0) {
                throw new CliInitializationException("Failed to process " + jbossCliRcFile.getAbsoluteFile());
            }
        }
    }
}

