/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.cli.ControllerAddress;
import org.jboss.as.cli.impl.CLIModelControllerClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.protocol.ProtocolTimeoutHandler;

public interface ModelControllerClientFactory {
    public static final String SASL_DISALLOWED_MECHANISMS = "SASL_DISALLOWED_MECHANISMS";
    public static final String JBOSS_LOCAL_USER = "JBOSS-LOCAL-USER";
    public static final Map<String, String> DISABLED_LOCAL_AUTH = Collections.singletonMap("SASL_DISALLOWED_MECHANISMS", "JBOSS-LOCAL-USER");
    public static final Map<String, String> ENABLED_LOCAL_AUTH = Collections.emptyMap();
    public static final ModelControllerClientFactory DEFAULT = new ModelControllerClientFactory(){

        @Override
        public ModelControllerClient getClient(ControllerAddress address, CallbackHandler handler, boolean disableLocalAuth, SSLContext sslContext, int connectionTimeout, ConnectionCloseHandler closeHandler, ProtocolTimeoutHandler timeoutHandler) throws IOException {
            Map saslOptions = disableLocalAuth ? DISABLED_LOCAL_AUTH : ENABLED_LOCAL_AUTH;
            return ModelControllerClient.Factory.create(address.getProtocol(), address.getHost(), address.getPort(), handler, sslContext, connectionTimeout, saslOptions);
        }
    };
    public static final ModelControllerClientFactory CUSTOM = new ModelControllerClientFactory(){

        @Override
        public ModelControllerClient getClient(ControllerAddress address, CallbackHandler handler, boolean disableLocalAuth, SSLContext sslContext, int connectionTimeout, ConnectionCloseHandler closeHandler, ProtocolTimeoutHandler timeoutHandler) throws IOException {
            Map saslOptions = disableLocalAuth ? DISABLED_LOCAL_AUTH : ENABLED_LOCAL_AUTH;
            return new CLIModelControllerClient(address, handler, connectionTimeout, closeHandler, saslOptions, sslContext, timeoutHandler);
        }
    };

    public ModelControllerClient getClient(ControllerAddress var1, CallbackHandler var2, boolean var3, SSLContext var4, int var5, ConnectionCloseHandler var6, ProtocolTimeoutHandler var7) throws IOException;

    public static interface ConnectionCloseHandler {
        public void handleClose();
    }
}

