/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.cli.handlers;

import org.infinispan.server.cli.CliInterpreterException;
import org.infinispan.server.cli.handlers.CacheCommand;
import org.infinispan.server.cli.handlers.CliCommandHandler;
import org.infinispan.server.cli.util.CliCommandBuffer;
import org.infinispan.server.cli.util.InfinispanUtil;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.cli.CommandHandlerProvider;
import org.jboss.as.cli.CommandLineException;
import org.jboss.dmr.ModelNode;

public class NoArgumentsCliCommandHandler
extends CliCommandHandler {
    protected final CliCommandBuffer buffer;

    public NoArgumentsCliCommandHandler(CacheCommand cacheCommand, CliCommandBuffer buffer) {
        super(cacheCommand);
        this.buffer = buffer;
    }

    @Override
    public boolean isAvailable(CommandContext ctx) {
        return ctx.getModelControllerClient() != null && InfinispanUtil.getCacheInfo(ctx).getContainer() != null;
    }

    @Override
    public boolean isBatchMode(CommandContext ctx) {
        return false;
    }

    @Override
    public void cliHandle(CommandContext ctx) throws CommandLineException {
        if (this.buffer.append(this.buildCommandString(ctx), this.cacheCommand.getNesting())) {
            try {
                this.invokeCliRequestIfNeeded(ctx);
            }
            catch (CliInterpreterException e) {
                ctx.printLine(e.getLocalizedMessage());
            }
        }
    }

    protected void printResult(ModelNode result, CommandContext context) throws CommandLineException {
        if (result == null || !result.has("result")) {
            return;
        }
        context.printLine(result.get("result").asString());
    }

    private void invokeCliRequestIfNeeded(CommandContext context) throws CommandLineException, CliInterpreterException {
        this.printResult(InfinispanUtil.cliRequest(context, this.buffer.getCommandAndReset()), context);
    }

    private String buildCommandString(CommandContext ctx) {
        StringBuilder command = new StringBuilder(this.cacheCommand.getName());
        if (ctx.getArgumentsString() != null) {
            command.append(' ').append(ctx.getArgumentsString());
        }
        command.append('\n');
        return command.toString();
    }

    public static class EndProvider
    implements CommandHandlerProvider {
        @Override
        public CommandHandler createCommandHandler(CommandContext ctx) {
            return new NoArgumentsCliCommandHandler(CacheCommand.END, CliCommandBuffer.INSTANCE);
        }

        @Override
        public boolean isTabComplete() {
            return true;
        }

        @Override
        public String[] getNames() {
            return new String[]{CacheCommand.END.getName()};
        }
    }

    public static class AbortProvider
    implements CommandHandlerProvider {
        @Override
        public CommandHandler createCommandHandler(CommandContext ctx) {
            return new NoArgumentsCliCommandHandler(CacheCommand.ABORT, CliCommandBuffer.INSTANCE);
        }

        @Override
        public boolean isTabComplete() {
            return true;
        }

        @Override
        public String[] getNames() {
            return new String[]{CacheCommand.ABORT.getName()};
        }
    }
}

