/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.lang.module.ModuleDescriptor;
import java.security.AccessController;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.JDKSpecific;
import org.jboss.modules.Version;

final class JDKSpecific {
    static final StackWalker WALKER = (StackWalker)AccessController.doPrivileged(new GetStackWalkerAction());
    private static final boolean JBOSS_MODULES;

    private JDKSpecific() {
    }

    static Class<?> findCallingClass(Set<ClassLoader> rejectClassLoaders) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return (Class)AccessController.doPrivileged(new FindCallingClassAction(rejectClassLoaders));
        }
        return (Class)WALKER.walk(new FindFirstWalkFunction(rejectClassLoaders));
    }

    static Collection<Class<?>> findCallingClasses(Set<ClassLoader> rejectClassLoaders) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return (Collection)AccessController.doPrivileged(new FindCallingClassesAction(rejectClassLoaders));
        }
        return (Collection)WALKER.walk(new FindAllWalkFunction(rejectClassLoaders));
    }

    static void calculateCaller(ExtLogRecord logRecord) {
        WALKER.walk(new CallerCalcFunction(logRecord));
    }

    static void calculateJdkModule(ExtLogRecord logRecord, Class<?> clazz) {
        Module module = clazz.getModule();
        if (module != null) {
            logRecord.setSourceModuleName(module.getName());
            ModuleDescriptor descriptor = module.getDescriptor();
            if (descriptor != null) {
                Optional<ModuleDescriptor.Version> optional = descriptor.version();
                if (optional.isPresent()) {
                    logRecord.setSourceModuleVersion(optional.get().toString());
                } else {
                    logRecord.setSourceModuleVersion(null);
                }
            }
        }
    }

    static void calculateModule(ExtLogRecord logRecord, Class<?> clazz) {
        org.jboss.modules.Module module = org.jboss.modules.Module.forClass(clazz);
        if (module != null) {
            logRecord.setSourceModuleName(module.getName());
            Version version = module.getVersion();
            if (version != null) {
                logRecord.setSourceModuleVersion(version.toString());
            } else {
                logRecord.setSourceModuleVersion(null);
            }
        } else {
            JDKSpecific.calculateJdkModule((ExtLogRecord)logRecord, clazz);
        }
    }

    static /* synthetic */ boolean access$000() {
        return JBOSS_MODULES;
    }

    static {
        boolean jbossModules = false;
        try {
            org.jboss.modules.Module.getStartTime();
            jbossModules = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        JBOSS_MODULES = jbossModules;
    }
}

