/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import org.jboss.modules.ConcurrentClassLoader;
import org.jboss.modules.FastCopyHashSet;
import org.jboss.modules.JDKPaths;
import org.jboss.modules.JDKSpecific;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.Module;
import org.jboss.modules.PropertyReadAction;

final class JDKSpecific {
    static final Set<String> MODULES_PACKAGES = new HashSet<String>(Arrays.asList("org/jboss/modules", "org/jboss/modules/filter", "org/jboss/modules/log", "org/jboss/modules/management", "org/jboss/modules/ref"));
    static final StackWalker STACK_WALKER = AccessController.doPrivileged(() -> StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE));
    static final ClassLoader SYSTEM_CLASS_LOADER = AccessController.doPrivileged(ClassLoader::getSystemClassLoader);
    static final ClassLoader OUR_CLASS_LOADER = JDKSpecific.class.getClassLoader();

    JDKSpecific() {
    }

    static JarFile getJarFile(File name, boolean verify) throws IOException {
        return new JarFile(name, verify, 1, JarFile.runtimeVersion());
    }

    static Class<?> getCallingUserClass() {
        return STACK_WALKER.walk(stream -> stream.skip(1L).filter(s -> !s.getDeclaringClass().equals(Module.class)).findFirst().get().getDeclaringClass());
    }

    static Class<?> getCallingClass() {
        return STACK_WALKER.walk(JDKSpecific::processFrame);
    }

    static boolean isParallelCapable(ConcurrentClassLoader cl) {
        return cl.isRegisteredAsParallelCapable();
    }

    static Package getPackage(ClassLoader cl, String packageName) {
        return cl.getDefinedPackage(packageName);
    }

    static Set<String> getJDKPaths() {
        FastCopyHashSet<String> pathSet = new FastCopyHashSet<String>(1024);
        JDKSpecific.processRuntimeImages(pathSet);
        String javaClassPath = AccessController.doPrivileged(new PropertyReadAction("java.class.path"));
        JDKPaths.processClassPathItem(javaClassPath, new FastCopyHashSet<String>(1024), pathSet);
        pathSet.addAll(MODULES_PACKAGES);
        return pathSet;
    }

    static LocalLoader getSystemLocalLoader() {
        return new PrivilegedAction<Hack>(){

            @Override
            public Hack run() {
                return new Hack();
            }
        };
    }

    static ClassLoader getPlatformClassLoader() {
        return SYSTEM_CLASS_LOADER;
    }

    static URL getSystemResource(String name) {
        URL resource = JDKSpecific.getPlatformClassLoader().getResource(name);
        return resource != null ? resource : (OUR_CLASS_LOADER != null ? OUR_CLASS_LOADER.getResource(name) : ClassLoader.getSystemResource(name));
    }

    static Enumeration<URL> getSystemResources(String name) throws IOException {
        Enumeration<URL> resources = JDKSpecific.getPlatformClassLoader().getResources(name);
        return resources != null && resources.hasMoreElements() ? resources : OUR_CLASS_LOADER.getResources(name);
    }

    static InputStream getSystemResourceAsStream(String name) {
        InputStream stream = JDKSpecific.getPlatformClassLoader().getResourceAsStream(name);
        return stream != null ? stream : (OUR_CLASS_LOADER != null ? OUR_CLASS_LOADER.getResourceAsStream(name) : ClassLoader.getSystemResourceAsStream(name));
    }

    static Class<?> getSystemClass(ConcurrentClassLoader caller, String className) throws ClassNotFoundException {
        try {
            return JDKSpecific.getPlatformClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException ignored) {
            return OUR_CLASS_LOADER != null ? OUR_CLASS_LOADER.loadClass(className) : caller.findSystemClassInternal(className);
        }
    }

    static void addInternalPackages(List<String> list) {
    }

    private static Class<?> processFrame(Stream<StackWalker.StackFrame> stream) {
        Iterator iterator = stream.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        iterator.next();
        if (!iterator.hasNext()) {
            return null;
        }
        Class<?> testClass = ((StackWalker.StackFrame)iterator.next()).getDeclaringClass();
        while (iterator.hasNext()) {
            Class<?> item = ((StackWalker.StackFrame)iterator.next()).getDeclaringClass();
            if (testClass == item) continue;
            return item;
        }
        return null;
    }

    private static void processRuntimeImages(Set<String> pathSet) {
        try {
            for (Path root : FileSystems.getFileSystem(new URI("jrt:/")).getRootDirectories()) {
                Files.walkFileTree(root, (FileVisitor<? super Path>)new JrtFileVisitor(pathSet, null));
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new IllegalStateException("Unable to process java runtime images");
        }
    }
}

