/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;

public enum Attribute {
    UNKNOWN(null),
    AWAIT_INITIAL_RETRIEVAL("await-initial-retrieval"),
    ALLOW_CREDENTIALS("allow-credentials"),
    AUTH_METHOD("auth-method"),
    CONTEXT_PATH("context-path"),
    CACHE("cache"),
    CACHE_CONTAINER("cache-container"),
    CACHE_SUFFIX("cache-suffix"),
    IGNORED_CACHES("ignored-caches"),
    IO_THREADS("io-threads"),
    EXTENDED_HEADERS("extended-headers"),
    EXTERNAL_HOST("external-host"),
    EXTERNAL_PORT("external-port"),
    IDLE_TIMEOUT("idle-timeout"),
    MECHANISMS("mechanisms"),
    HOST_NAME("host-name"),
    PATH("path"),
    LAZY_RETRIEVAL("lazy-retrieval"),
    LOCK_TIMEOUT("lock-timeout"),
    REPLICATION_TIMEOUT("replication-timeout"),
    MAX_CONTENT_LENGTH("max-content-length"),
    MAX_AGE_SECONDS("max-age-seconds"),
    COMPRESSION_LEVEL("compression-level"),
    NAME("name"),
    QOP("qop"),
    RECEIVE_BUFFER_SIZE("receive-buffer-size"),
    REQUIRE_SSL_CLIENT_AUTH("require-ssl-client-auth"),
    SEND_BUFFER_SIZE("send-buffer-size"),
    SECURITY_DOMAIN("security-domain"),
    SECURITY_MODE("security-mode"),
    SECURITY_REALM("security-realm"),
    SERVER_CONTEXT_NAME("server-context-name"),
    SERVER_NAME("server-name"),
    SOCKET_BINDING("socket-binding"),
    REST_SOCKET_BINDING("rest-socket-binding"),
    HOTROD_SOCKET_BINDING("hotrod-socket-binding"),
    SINGLE_PORT_SOCKET_BINDING("single-port-socket-binding"),
    SSL("ssl"),
    STRENGTH("strength"),
    TCP_NODELAY("tcp-nodelay"),
    TCP_KEEPALIVE("tcp-keepalive"),
    KEEP_ALIVE("keep-alive"),
    UPDATE_TIMEOUT("update-timeout"),
    VALUE("value"),
    VIRTUAL_HOST("virtual-host"),
    VIRTUAL_SERVER("virtual-server"),
    WORKER_THREADS("worker-threads");

    private final String name;
    private final AttributeDefinition definition;
    private static final Map<String, Attribute> attributes;

    private Attribute(String name) {
        this.name = name;
        this.definition = null;
    }

    public String getLocalName() {
        return this.name;
    }

    public AttributeDefinition getDefinition() {
        return this.definition;
    }

    public static Attribute forName(String localName) {
        Attribute attribute = attributes.get(localName);
        return attribute == null ? UNKNOWN : attribute;
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>();
        for (Attribute attribute : Attribute.values()) {
            String name = attribute.getLocalName();
            if (name == null) continue;
            map.put(name, attribute);
        }
        attributes = map;
    }
}

