/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.infinispan.rest.RestServer;
import org.infinispan.server.endpoint.EndpointLogger;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.router.Router;
import org.infinispan.server.router.configuration.builder.RouterConfigurationBuilder;
import org.infinispan.server.router.routes.Route;
import org.infinispan.server.router.routes.RouteDestination;
import org.infinispan.server.router.routes.RouteSource;
import org.infinispan.server.router.routes.hotrod.HotRodServerRouteDestination;
import org.infinispan.server.router.routes.hotrod.SniNettyRouteSource;
import org.infinispan.server.router.routes.rest.RestRouteSource;
import org.infinispan.server.router.routes.rest.RestServerRouteDestination;
import org.infinispan.server.router.routes.singleport.SinglePortRouteSource;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.network.SocketBinding;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

class RouterService
implements Service<Router> {
    private static final String DEFAULT_NAME = "EndpointRouter";
    private final InjectedValue<SocketBinding> restSocketBinding = new InjectedValue();
    private final InjectedValue<SocketBinding> hotrodSocketBinding = new InjectedValue();
    private final InjectedValue<SocketBinding> singlePortSocketBinding = new InjectedValue();
    private final Map<String, HotRodRouting> hotrodRouting = new HashMap<String, HotRodRouting>();
    private final Map<String, RestRouting> restRouting = new HashMap<String, RestRouting>();
    private final SinglePortRouting singlePortRouting = new SinglePortRouting();
    private final String name;
    private final RouterConfigurationBuilder configurationBuilder;
    private Router router;

    RouterService(RouterConfigurationBuilder configurationBuilder, Optional<String> serverName) {
        this.name = this.constructServerName(serverName);
        this.configurationBuilder = configurationBuilder;
    }

    private final String constructServerName(Optional<String> name) {
        return name.orElse(DEFAULT_NAME);
    }

    public synchronized void start(StartContext context) throws StartException {
        EndpointLogger.ROOT_LOGGER.endpointStarting(this.name);
        try {
            InetSocketAddress singlePortAddress;
            SocketBinding hotrodSocketBinding = (SocketBinding)this.getHotrodSocketBinding().getOptionalValue();
            InetSocketAddress hotrodAddress = hotrodSocketBinding != null ? hotrodSocketBinding.getSocketAddress() : null;
            SocketBinding restSocketBinding = (SocketBinding)this.getRestSocketBinding().getOptionalValue();
            InetSocketAddress restAddress = restSocketBinding != null ? restSocketBinding.getSocketAddress() : null;
            SocketBinding singlePortSocketBinding = (SocketBinding)this.getSinglePortSocketBinding().getOptionalValue();
            InetSocketAddress inetSocketAddress = singlePortAddress = singlePortSocketBinding != null ? singlePortSocketBinding.getSocketAddress() : null;
            if (hotrodAddress != null) {
                this.configurationBuilder.hotrod().ip(hotrodAddress.getAddress());
                this.configurationBuilder.hotrod().port(hotrodAddress.getPort());
            }
            if (restAddress != null) {
                this.configurationBuilder.rest().ip(restAddress.getAddress());
                this.configurationBuilder.rest().port(restAddress.getPort());
            }
            if (singlePortAddress != null) {
                this.configurationBuilder.singlePort().ip(singlePortAddress.getAddress());
                this.configurationBuilder.singlePort().port(singlePortAddress.getPort());
            }
            this.hotrodRouting.forEach((sniHostName, routing) -> {
                HotRodServer hotRod = (HotRodServer)routing.getHotRod().getValue();
                SecurityRealm securityRealm = (SecurityRealm)routing.getSecurityRealm().getValue();
                SniNettyRouteSource source = new SniNettyRouteSource(sniHostName, securityRealm.getSSLContext());
                HotRodServerRouteDestination destination = new HotRodServerRouteDestination(hotRod.getQualifiedName(), hotRod);
                this.configurationBuilder.routing().add(new Route((RouteSource)source, (RouteDestination)destination));
            });
            this.restRouting.forEach((path, routing) -> {
                RestServer restResource = (RestServer)routing.getRest().getValue();
                String name = routing.getName();
                RestRouteSource source = new RestRouteSource(path);
                RestServerRouteDestination destination = new RestServerRouteDestination(name, restResource);
                this.configurationBuilder.routing().add(new Route((RouteSource)source, (RouteDestination)destination));
            });
            SecurityRealm singlePortSecurityRealm = (SecurityRealm)this.singlePortRouting.getSecurityRealm().getOptionalValue();
            RestServer singlePortRestServer = (RestServer)this.singlePortRouting.getRestServer().getOptionalValue();
            HotRodServer singlePortHotRodServer = (HotRodServer)this.singlePortRouting.getHotrodServer().getOptionalValue();
            if (singlePortRestServer != null || singlePortHotRodServer != null) {
                RestServerRouteDestination destination;
                SinglePortRouteSource singlePortRouteSource = new SinglePortRouteSource();
                if (singlePortRestServer != null) {
                    destination = new RestServerRouteDestination(singlePortRestServer.getQualifiedName(), singlePortRestServer);
                    this.configurationBuilder.routing().add(new Route((RouteSource)singlePortRouteSource, (RouteDestination)destination));
                }
                if (singlePortHotRodServer != null) {
                    destination = new HotRodServerRouteDestination(singlePortHotRodServer.getQualifiedName(), singlePortHotRodServer);
                    this.configurationBuilder.routing().add(new Route((RouteSource)singlePortRouteSource, (RouteDestination)destination));
                }
                if (singlePortSecurityRealm != null) {
                    this.configurationBuilder.singlePort().sslWithAlpn(singlePortSecurityRealm.getSSLContext());
                }
            }
            this.router = new Router(this.configurationBuilder.build());
            this.router.start();
            EndpointLogger.ROOT_LOGGER.routerStarted(this.getAddressAsString(hotrodAddress), this.getAddressAsString(restAddress), this.getAddressAsString(singlePortAddress));
        }
        catch (Exception e) {
            throw EndpointLogger.ROOT_LOGGER.failedStart(e, this.name);
        }
    }

    private String getAddressAsString(InetSocketAddress address) {
        if (address == null) {
            return "None";
        }
        return NetworkUtils.formatAddress((InetSocketAddress)address);
    }

    public synchronized void stop(StopContext context) {
        if (this.router != null) {
            this.router.stop();
        }
    }

    public synchronized Router getValue() throws IllegalStateException {
        if (this.router == null) {
            throw EndpointLogger.ROOT_LOGGER.serviceNotStarted();
        }
        return this.router;
    }

    InjectedValue<SocketBinding> getHotrodSocketBinding() {
        return this.hotrodSocketBinding;
    }

    InjectedValue<SocketBinding> getSinglePortSocketBinding() {
        return this.singlePortSocketBinding;
    }

    HotRodRouting getHotRodRouting(String sniHostName) {
        return this.hotrodRouting.computeIfAbsent(sniHostName, v -> new HotRodRouting());
    }

    InjectedValue<SocketBinding> getRestSocketBinding() {
        return this.restSocketBinding;
    }

    RestRouting getRestRouting(String path, String name) {
        return this.restRouting.computeIfAbsent(path, v -> new RestRouting(name));
    }

    SinglePortRouting getSinglePortRouting() {
        return this.singlePortRouting;
    }

    public void tcpNoDelay(boolean tcpNoDelay) {
        this.configurationBuilder.hotrod().tcpNoDelay(tcpNoDelay);
    }

    public void tcpKeepAlive(boolean tcpKeepAlive) {
        this.configurationBuilder.hotrod().tcpKeepAlive(tcpKeepAlive);
    }

    public void sendBufferSize(int sendBufferSize) {
        this.configurationBuilder.hotrod().sendBufferSize(sendBufferSize);
    }

    public void receiveBufferSize(int receiveBufferSize) {
        this.configurationBuilder.hotrod().receiveBufferSize(receiveBufferSize);
    }

    static class SinglePortRouting {
        private final InjectedValue<RestServer> restServer = new InjectedValue();
        private final InjectedValue<HotRodServer> hotrodServer = new InjectedValue();
        private final InjectedValue<SecurityRealm> securityRealm = new InjectedValue();

        SinglePortRouting() {
        }

        public InjectedValue<HotRodServer> getHotrodServer() {
            return this.hotrodServer;
        }

        public InjectedValue<RestServer> getRestServer() {
            return this.restServer;
        }

        public InjectedValue<SecurityRealm> getSecurityRealm() {
            return this.securityRealm;
        }
    }

    static class RestRouting {
        private final InjectedValue<RestServer> rest = new InjectedValue();
        private final String name;

        public RestRouting(String name) {
            this.name = name;
        }

        public InjectedValue<RestServer> getRest() {
            return this.rest;
        }

        public String getName() {
            return this.name;
        }
    }

    static class HotRodRouting {
        private final InjectedValue<HotRodServer> hotRod = new InjectedValue();
        private final InjectedValue<SecurityRealm> securityRealm = new InjectedValue();

        HotRodRouting() {
        }

        public InjectedValue<HotRodServer> getHotRod() {
            return this.hotRod;
        }

        public InjectedValue<SecurityRealm> getSecurityRealm() {
            return this.securityRealm;
        }
    }
}

