/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.infinispan.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.scripting.utils.ScriptConversions;
import org.infinispan.server.infinispan.task.ServerTaskEngine;
import org.infinispan.server.infinispan.task.ServerTaskRegistry;
import org.infinispan.server.infinispan.task.ServerTaskWrapper;
import org.infinispan.tasks.ServerTask;
import org.infinispan.tasks.Task;
import org.infinispan.tasks.TaskManager;
import org.infinispan.tasks.spi.TaskEngine;

@Scope(value=Scopes.GLOBAL)
public class ServerTaskRegistryImpl
implements ServerTaskRegistry {
    private ConcurrentMap<String, ServerTaskWrapper> tasks = new ConcurrentHashMap<String, ServerTaskWrapper>();

    @Inject
    public void init(TaskManager taskManager, EmbeddedCacheManager cacheManager) {
        EncoderRegistry encoderRegistry = (EncoderRegistry)cacheManager.getGlobalComponentRegistry().getComponent(EncoderRegistry.class);
        ServerTaskEngine engine = new ServerTaskEngine(this, cacheManager, new ScriptConversions(encoderRegistry));
        taskManager.registerTaskEngine((TaskEngine)engine);
    }

    @Override
    public List<Task> getTasks() {
        Collection tasks = this.tasks.values();
        return new ArrayList<Task>(tasks);
    }

    @Override
    public <T> ServerTaskWrapper<T> getTask(String taskName) {
        return (ServerTaskWrapper)this.tasks.get(taskName);
    }

    @Override
    public boolean handles(String taskName) {
        return this.tasks.containsKey(taskName);
    }

    @Override
    public <T> void addDeployedTask(ServerTask<T> task) {
        ServerTaskWrapper<T> taskWrapper = new ServerTaskWrapper<T>(task);
        this.tasks.put(task.getName(), taskWrapper);
    }

    @Override
    public void removeDeployedTask(String name) {
        this.tasks.remove(name);
    }
}

