/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.conflict;

import java.lang.reflect.Constructor;
import java.util.List;
import org.infinispan.conflict.EntryMergePolicy;
import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.clustering.infinispan.conflict.DeployedMergePolicy;
import org.jboss.as.clustering.infinispan.conflict.DeployedMergePolicyFactory;
import org.jboss.as.clustering.infinispan.conflict.DeployedMergePolicyFactoryService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.ServicesAttachment;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.service.ServiceController;

public class DeployedMergePolicyProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext ctx) {
        DeploymentUnit deploymentUnit = ctx.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        ServicesAttachment servicesAttachment = (ServicesAttachment)deploymentUnit.getAttachment(Attachments.SERVICES);
        if (module != null && servicesAttachment != null) {
            List implementationNames = servicesAttachment.getServiceImplementations(EntryMergePolicy.class.getName());
            ModuleClassLoader classLoader = module.getClassLoader();
            for (String serviceClassName : implementationNames) {
                try {
                    ServiceController sc = ctx.getServiceRegistry().getRequiredService(DeployedMergePolicyFactoryService.SERVICE_NAME);
                    DeployedMergePolicyFactory factory = (DeployedMergePolicyFactory)DeployedMergePolicyFactory.class.cast(sc.getValue());
                    Class<EntryMergePolicy> clazz = classLoader.loadClass(serviceClassName).asSubclass(EntryMergePolicy.class);
                    Constructor<EntryMergePolicy> ctor = clazz.getConstructor(new Class[0]);
                    factory.addDeployedPolicy(new DeployedMergePolicy(ctor.newInstance(new Object[0])));
                }
                catch (Exception e) {
                    throw InfinispanMessages.MESSAGES.unableToInstantiateClass(serviceClassName);
                }
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

