/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.server.infinispan.spi.service.CacheServiceName;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerConfigurationsResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResource;
import org.jboss.as.clustering.infinispan.subsystem.PathAddressUtils;
import org.jboss.as.clustering.infinispan.subsystem.RestartableServiceHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RestartParentWriteAttributeHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class RestartServiceWriteAttributeHandler
extends RestartParentWriteAttributeHandler {
    private final RestartableServiceHandler serviceInstaller;
    private final CacheServiceName serviceNameResolver;

    public RestartServiceWriteAttributeHandler(String parentKeyName, RestartableServiceHandler serviceInstaller, CacheServiceName serviceNameResolver, AttributeDefinition ... definitions) {
        super(parentKeyName, definitions);
        this.serviceInstaller = serviceInstaller;
        this.serviceNameResolver = serviceNameResolver;
    }

    protected void recreateParentService(OperationContext context, PathAddress serviceAddress, ModelNode model) throws OperationFailedException {
        int containerPosition = PathAddressUtils.indexOfKey(serviceAddress, CacheContainerResource.CONTAINER_PATH.getKey());
        PathAddress containerAddress = serviceAddress.subAddress(0, containerPosition + 1);
        ModelNode containerModel = context.readResourceFromRoot(containerAddress).getModel();
        ModelNode operation = Util.createAddOperation((PathAddress)serviceAddress);
        this.serviceInstaller.installRuntimeServices(context, operation, containerModel, model);
    }

    protected ServiceName getParentServiceName(PathAddress parentAddress) {
        int containerPosition = PathAddressUtils.indexOfKey(parentAddress, CacheContainerResource.CONTAINER_PATH.getKey());
        String containerName = parentAddress.getElement(containerPosition).getValue();
        int resourceOffset = containerPosition + 1;
        if (parentAddress.getElement(resourceOffset).equals(CacheContainerConfigurationsResource.PATH)) {
            ++resourceOffset;
        }
        String resourceName = parentAddress.getElement(resourceOffset).getValue();
        return this.serviceNameResolver.getServiceName(containerName, resourceName);
    }

    protected boolean isResourceServiceRestartAllowed(OperationContext context, ServiceController<?> service) {
        return true;
    }
}

