/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.counter.EmbeddedCounterManagerFactory;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;

public class CounterService
implements Service<CounterConfiguration> {
    private static final Logger log = Logger.getLogger((String)CounterService.class.getPackage().getName());
    private final Dependencies dependencies;
    private final String counterConfigurationName;
    private final CounterConfiguration counterConfiguration;

    public CounterService(CounterConfiguration configuration, String configurationName, Dependencies dependencies) {
        this.counterConfiguration = configuration;
        this.counterConfigurationName = configurationName;
        this.dependencies = dependencies;
    }

    public CounterConfiguration getValue() {
        return this.counterConfiguration;
    }

    public void start(StartContext context) {
        EmbeddedCacheManager container = this.dependencies.getCacheContainer();
        CounterManager counterManager = EmbeddedCounterManagerFactory.asCounterManager((EmbeddedCacheManager)container);
        counterManager.defineCounter(this.counterConfigurationName, this.counterConfiguration);
        switch (this.counterConfiguration.type()) {
            case BOUNDED_STRONG: 
            case UNBOUNDED_STRONG: {
                counterManager.getStrongCounter(this.counterConfigurationName);
                break;
            }
            case WEAK: {
                counterManager.getWeakCounter(this.counterConfigurationName);
                break;
            }
            default: {
                log.warn((Object)("Unknown counter type " + this.counterConfiguration.type() + " did not get instantiated"));
            }
        }
    }

    public void stop(StopContext context) {
    }

    public static interface Dependencies {
        public EmbeddedCacheManager getCacheContainer();
    }
}

