/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.factory.CacheStoreFactory;
import org.infinispan.query.impl.IndexPropertyInspector;
import org.infinispan.server.infinispan.spi.service.CacheContainerServiceName;
import org.infinispan.server.infinispan.spi.service.CacheServiceName;
import org.infinispan.server.infinispan.task.ServerTaskRegistry;
import org.infinispan.server.infinispan.task.ServerTaskRegistryService;
import org.jboss.as.clustering.infinispan.conflict.DeployedMergePolicyFactory;
import org.jboss.as.clustering.infinispan.conflict.DeployedMergePolicyFactoryService;
import org.jboss.as.clustering.infinispan.cs.factory.DeployedCacheStoreFactory;
import org.jboss.as.clustering.infinispan.cs.factory.DeployedCacheStoreFactoryService;
import org.jboss.as.clustering.infinispan.subsystem.CacheConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanJndiName;
import org.jboss.as.clustering.infinispan.subsystem.RestartableServiceHandler;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.naming.ManagedReferenceInjector;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jboss.tm.XAResourceRecoveryRegistry;

public abstract class CacheAdd
extends AbstractAddStepHandler
implements RestartableServiceHandler {
    private static final Logger log = Logger.getLogger((String)CacheAdd.class.getPackage().getName());
    final CacheMode mode;

    CacheAdd(CacheMode mode) {
        this.mode = mode;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        this.populate(operation, model);
    }

    private String getConfigurationKey() {
        switch (this.mode) {
            case DIST_ASYNC: 
            case DIST_SYNC: {
                return "distributed-cache-configuration";
            }
            case REPL_ASYNC: 
            case REPL_SYNC: {
                return "replicated-cache-configuration";
            }
            case INVALIDATION_ASYNC: 
            case INVALIDATION_SYNC: {
                return "invalidation-cache-configuration";
            }
            case LOCAL: {
                return "local-cache-configuration";
            }
        }
        throw new IllegalArgumentException("Unknown cache mode " + this.mode);
    }

    private Properties extractIndexingProperties(OperationContext context, ModelNode operation, String cacheConfiguration) {
        Properties properties = new Properties();
        PathAddress cacheAddress = this.getCacheAddressFromOperation(operation);
        Resource cacheConfigResource = context.readResourceFromRoot(cacheAddress.subAddress(0, 2), true).getChild(PathElement.pathElement((String)"configurations", (String)"CONFIGURATIONS")).getChild(PathElement.pathElement((String)this.getConfigurationKey(), (String)cacheConfiguration));
        PathElement indexingPathElement = PathElement.pathElement((String)"indexing", (String)"INDEXING");
        if (cacheConfigResource == null || !cacheConfigResource.hasChild(indexingPathElement)) {
            return properties;
        }
        Resource indexingResource = cacheConfigResource.getChild(indexingPathElement);
        if (indexingResource == null) {
            return properties;
        }
        ModelNode indexingModel = indexingResource.getModel();
        boolean hasProperties = indexingModel.hasDefined("indexing-properties");
        if (!hasProperties) {
            return properties;
        }
        ModelNode modelNode = indexingResource.getModel().get("indexing-properties");
        List modelProperties = modelNode.asPropertyList();
        modelProperties.forEach(p -> properties.put(p.getName(), p.getValue().asString()));
        return properties;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ModelNode cacheModel = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        PathAddress containerAddress = this.getCacheContainerAddressFromOperation(operation);
        ModelNode containerModel = context.readResourceFromRoot(containerAddress).getModel();
        this.installRuntimeServices(context, operation, containerModel, cacheModel);
    }

    @Override
    public Collection<ServiceController<?>> installRuntimeServices(OperationContext context, ModelNode operation, ModelNode containerModel, ModelNode cacheModel) throws OperationFailedException {
        PathAddress cacheAddress = this.getCacheAddressFromOperation(operation);
        PathAddress containerAddress = this.getCacheContainerAddressFromOperation(operation);
        String cacheName = cacheAddress.getLastElement().getValue();
        String containerName = containerAddress.getLastElement().getValue();
        String configuration = CacheResource.CONFIGURATION.resolveModelAttribute(context, cacheModel).asString();
        Properties indexingProperties = this.extractIndexingProperties(context, operation, configuration);
        ServiceTarget target = context.getServiceTarget();
        ArrayList controllers = new ArrayList(2);
        controllers.add(this.installCacheService(target, containerName, cacheName, configuration, indexingProperties));
        ModelNode resolvedValue = CacheConfigurationResource.JNDI_NAME.resolveModelAttribute(context, cacheModel);
        String jndiName = InfinispanJndiName.createCacheJndiName(resolvedValue.isDefined() ? resolvedValue.asString() : null, containerName, cacheName);
        controllers.add(this.installJndiService(target, containerName, cacheName, jndiName));
        log.debugf("Cache service for cache %s installed for container %s", (Object)cacheName, (Object)containerName);
        return controllers;
    }

    @Override
    public void removeRuntimeServices(OperationContext context, ModelNode operation, ModelNode containerModel, ModelNode cacheModel) throws OperationFailedException {
        PathAddress cacheAddress = this.getCacheAddressFromOperation(operation);
        PathAddress containerAddress = this.getCacheContainerAddressFromOperation(operation);
        String cacheName = cacheAddress.getLastElement().getValue();
        String containerName = containerAddress.getLastElement().getValue();
        ModelNode resolvedValue = CacheConfigurationResource.JNDI_NAME.resolveModelAttribute(context, cacheModel);
        String jndiName = InfinispanJndiName.createCacheJndiName(resolvedValue.isDefined() ? resolvedValue.asString() : null, containerName, cacheName);
        context.removeService(ContextNames.bindInfoFor((String)jndiName).getBinderServiceName());
        context.removeService(CacheServiceName.CACHE.getServiceName(containerName, cacheName));
        log.debugf("cache %s removed for container %s", (Object)cacheName, (Object)containerName);
    }

    protected PathAddress getCacheAddressFromOperation(ModelNode operation) {
        return PathAddress.pathAddress((ModelNode)operation.get("address"));
    }

    protected PathAddress getCacheContainerAddressFromOperation(ModelNode operation) {
        PathAddress cacheAddress = this.getCacheAddressFromOperation(operation);
        PathAddress containerAddress = cacheAddress.subAddress(0, cacheAddress.size() - 1);
        return containerAddress;
    }

    ServiceController<?> installCacheService(ServiceTarget target, String containerName, String cacheName, String configurationName, Properties indexingProperties) {
        InjectedValue container = new InjectedValue();
        CacheDependencies cacheDependencies = new CacheDependencies((Value<EmbeddedCacheManager>)container);
        CacheService service = new CacheService(cacheName, configurationName, cacheDependencies);
        ServiceBuilder builder = target.addService(CacheServiceName.CACHE.getServiceName(containerName, cacheName), service).addDependency(CacheServiceName.CONFIGURATION.getServiceName(containerName, configurationName)).addDependency(CacheContainerServiceName.CACHE_CONTAINER.getServiceName(containerName), EmbeddedCacheManager.class, (Injector)container).setInitialMode(ServiceController.Mode.ACTIVE);
        builder.addDependency(DeployedCacheStoreFactoryService.SERVICE_NAME, DeployedCacheStoreFactory.class, cacheDependencies.getDeployedCacheStoreFactoryInjector());
        builder.addDependency(ServerTaskRegistryService.SERVICE_NAME, ServerTaskRegistry.class, cacheDependencies.getDeployedTaskRegistryInjector());
        builder.addDependency(DeployedMergePolicyFactoryService.SERVICE_NAME, DeployedMergePolicyFactory.class, cacheDependencies.getDeployedMergePolicyRegistryInjector());
        boolean hasInfinispanDirectory = IndexPropertyInspector.hasInfinispanDirectory((Properties)indexingProperties);
        if (hasInfinispanDirectory) {
            builder.addDependency(CacheServiceName.CACHE.getServiceName(containerName, IndexPropertyInspector.getDataCacheName((Properties)indexingProperties)));
            builder.addDependency(CacheServiceName.CACHE.getServiceName(containerName, IndexPropertyInspector.getMetadataCacheName((Properties)indexingProperties)));
            builder.addDependency(CacheServiceName.CACHE.getServiceName(containerName, IndexPropertyInspector.getLockingCacheName((Properties)indexingProperties)));
        }
        return builder.install();
    }

    ServiceController<?> installJndiService(ServiceTarget target, String containerName, String cacheName, String jndiName) {
        ServiceName cacheServiceName = CacheServiceName.CACHE.getServiceName(containerName, cacheName);
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
        BinderService binder = new BinderService(bindInfo.getBindName());
        return target.addService(bindInfo.getBinderServiceName(), (Service)binder).addAliases(new ServiceName[]{ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{jndiName})}).addDependency(cacheServiceName, Cache.class, (Injector)new ManagedReferenceInjector((Injector)binder.getManagedObjectInjector())).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)binder.getNamingStoreInjector()).setInitialMode(ServiceController.Mode.PASSIVE).install();
    }

    private <T> void addDependency(ServiceBuilder<?> builder, Dependency<T> dependency) {
        ServiceName name = dependency.getName();
        Injector<T> injector = dependency.getInjector();
        if (injector != null) {
            builder.addDependency(name, dependency.getType(), injector);
        } else {
            builder.addDependency(name);
        }
    }

    void populate(ModelNode fromModel, ModelNode toModel) throws OperationFailedException {
        for (AttributeDefinition attr : CacheResource.CACHE_ATTRIBUTES) {
            attr.validateAndSet(fromModel, toModel);
        }
    }

    private static class CacheDependencies
    implements CacheService.Dependencies {
        private final Value<EmbeddedCacheManager> container;
        private final InjectedValue<XAResourceRecoveryRegistry> recoveryRegistry = new InjectedValue();
        private final InjectedValue<DeployedCacheStoreFactory> deployedCacheStoreFactory = new InjectedValue();
        private final InjectedValue<ServerTaskRegistry> deployedTaskRegistry = new InjectedValue();
        private final InjectedValue<DeployedMergePolicyFactory> deployedMergePolicyRegistry = new InjectedValue();

        CacheDependencies(Value<EmbeddedCacheManager> container) {
            this.container = container;
        }

        Injector<XAResourceRecoveryRegistry> getRecoveryRegistryInjector() {
            return this.recoveryRegistry;
        }

        public InjectedValue<DeployedCacheStoreFactory> getDeployedCacheStoreFactoryInjector() {
            return this.deployedCacheStoreFactory;
        }

        public InjectedValue<ServerTaskRegistry> getDeployedTaskRegistryInjector() {
            return this.deployedTaskRegistry;
        }

        public InjectedValue<DeployedMergePolicyFactory> getDeployedMergePolicyRegistryInjector() {
            return this.deployedMergePolicyRegistry;
        }

        @Override
        public EmbeddedCacheManager getCacheContainer() {
            return (EmbeddedCacheManager)this.container.getValue();
        }

        @Override
        public XAResourceRecoveryRegistry getRecoveryRegistry() {
            return (XAResourceRecoveryRegistry)this.recoveryRegistry.getOptionalValue();
        }

        @Override
        public CacheStoreFactory getDeployedCacheStoreFactory() {
            return (CacheStoreFactory)this.deployedCacheStoreFactory.getValue();
        }

        @Override
        public DeployedMergePolicyFactory getDeployedMergePolicyRegistry() {
            return (DeployedMergePolicyFactory)this.deployedMergePolicyRegistry.getValue();
        }
    }

    protected class Dependency<I> {
        private final ServiceName name;
        private final Class<I> type;
        private final Injector<I> target;

        Dependency(ServiceName name) {
            this(name, null, null);
        }

        Dependency(ServiceName name, Class<I> type, Injector<I> target) {
            this.name = name;
            this.type = type;
            this.target = target;
        }

        ServiceName getName() {
            return this.name;
        }

        public Class<I> getType() {
            return this.type;
        }

        public Injector<I> getInjector() {
            return this.target;
        }
    }
}

