/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.jboss.as.clustering.infinispan.subsystem.Attribute;
import org.jboss.as.clustering.infinispan.subsystem.CacheCommands;
import org.jboss.as.clustering.infinispan.subsystem.CacheMetricsHandler;
import org.jboss.as.clustering.infinispan.subsystem.CacheReadAttributeHandler;
import org.jboss.as.clustering.infinispan.subsystem.CacheResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheWriteAttributeHandler;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.clustering.infinispan.subsystem.Mode;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ClusteredCacheResource
extends CacheResource {
    static final SimpleAttributeDefinition ASYNC_MARSHALLING = new SimpleAttributeDefinitionBuilder("async-marshalling", ModelType.BOOLEAN, true).setXmlName(Attribute.ASYNC_MARSHALLING.getLocalName()).setAllowExpression(false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode().set(false)).build();
    static final SimpleAttributeDefinition MODE = new SimpleAttributeDefinitionBuilder("mode", ModelType.STRING, false).setXmlName(Attribute.MODE.getLocalName()).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new EnumValidator(Mode.class, false, true)).build();
    static final SimpleAttributeDefinition QUEUE_FLUSH_INTERVAL = new SimpleAttributeDefinitionBuilder("queue-flush-interval", ModelType.LONG, true).setXmlName(Attribute.QUEUE_FLUSH_INTERVAL.getLocalName()).setMeasurementUnit(MeasurementUnit.MILLISECONDS).setAllowExpression(false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode().set(10)).build();
    static final SimpleAttributeDefinition QUEUE_SIZE = new SimpleAttributeDefinitionBuilder("queue-size", ModelType.INT, true).setXmlName(Attribute.QUEUE_SIZE.getLocalName()).setAllowExpression(false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode().set(0)).build();
    static final SimpleAttributeDefinition REMOTE_TIMEOUT = new SimpleAttributeDefinitionBuilder("remote-timeout", ModelType.LONG, true).setXmlName(Attribute.REMOTE_TIMEOUT.getLocalName()).setMeasurementUnit(MeasurementUnit.MILLISECONDS).setAllowExpression(false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode().set(17500)).build();
    static final AttributeDefinition[] CLUSTERED_CACHE_ATTRIBUTES = new AttributeDefinition[]{ASYNC_MARSHALLING, MODE, QUEUE_SIZE, QUEUE_FLUSH_INTERVAL, REMOTE_TIMEOUT};
    static final OperationDefinition RESET_RPC_STATISTICS = new SimpleOperationDefinitionBuilder("reset-rpc-statistics", InfinispanExtension.getResourceDescriptionResolver("clustered-cache")).build();

    public ClusteredCacheResource(PathElement pathElement, ResourceDescriptionResolver descriptionResolver, AbstractAddStepHandler addHandler, OperationStepHandler removeHandler, boolean runtimeRegistration) {
        super(pathElement, descriptionResolver, addHandler, removeHandler, runtimeRegistration);
    }

    @Override
    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        CacheWriteAttributeHandler writeHandler = new CacheWriteAttributeHandler(CLUSTERED_CACHE_ATTRIBUTES);
        for (AttributeDefinition attr : CLUSTERED_CACHE_ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attr, (OperationStepHandler)CacheReadAttributeHandler.INSTANCE, (OperationStepHandler)writeHandler);
        }
        if (this.isRuntimeRegistration()) {
            CacheMetricsHandler.INSTANCE.registerClusteredMetrics(resourceRegistration);
        }
    }

    @Override
    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        if (this.isRuntimeRegistration()) {
            resourceRegistration.registerOperationHandler(RESET_RPC_STATISTICS.getName(), (OperationStepHandler)CacheCommands.ResetRpcManagerStatisticsCommand.INSTANCE, RESET_RPC_STATISTICS.getDescriptionProvider());
        }
    }
}

