/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.affinity;

import java.security.AccessController;
import java.util.Collections;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.infinispan.Cache;
import org.infinispan.affinity.KeyAffinityService;
import org.infinispan.affinity.KeyAffinityServiceImpl;
import org.infinispan.affinity.KeyGenerator;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.clustering.infinispan.affinity.KeyAffinityServiceFactory;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.threads.JBossThreadFactory;

public class KeyAffinityServiceFactoryService
implements Service<KeyAffinityServiceFactory>,
KeyAffinityServiceFactory {
    private static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"infinispan", "affinity"});
    private final int bufferSize;
    private volatile ExecutorService executor;

    public static ServiceName getServiceName(String container) {
        return SERVICE_NAME.append(new String[]{container});
    }

    public KeyAffinityServiceFactoryService(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public KeyAffinityServiceFactory getValue() {
        return this;
    }

    public void start(StartContext context) throws StartException {
        ThreadGroup threadGroup = new ThreadGroup("KeyAffinityService ThreadGroup");
        String namePattern = "KeyAffinityService Thread Pool -- %t";
        JBossThreadFactory threadFactory = new JBossThreadFactory(threadGroup, Boolean.FALSE, null, "KeyAffinityService Thread Pool -- %t", null, null, AccessController.getContext());
        this.executor = Executors.newCachedThreadPool((ThreadFactory)threadFactory);
    }

    public void stop(StopContext context) {
        this.executor.shutdown();
    }

    @Override
    public <K> KeyAffinityService<K> createService(Cache<K, ?> cache, KeyGenerator<K> generator) {
        boolean distributed = cache.getCacheConfiguration().clustering().cacheMode().isDistributed();
        return distributed ? new KeyAffinityServiceImpl((Executor)this.executor, cache, generator, this.bufferSize, Collections.singleton(cache.getCacheManager().getAddress()), false) : new SimpleKeyAffinityService<K>(generator);
    }

    private static class SimpleKeyAffinityService<K>
    implements KeyAffinityService<K> {
        private final KeyGenerator<K> generator;
        private volatile boolean started = false;

        SimpleKeyAffinityService(KeyGenerator<K> generator) {
            this.generator = generator;
        }

        public void start() {
            this.started = true;
        }

        public void stop() {
            this.started = false;
        }

        public K getKeyForAddress(Address address) {
            return (K)this.generator.getKey();
        }

        public K getCollocatedKey(K otherKey) {
            return (K)this.generator.getKey();
        }

        public boolean isStarted() {
            return this.started;
        }
    }
}

